/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.pipes.DefaultPipesAsyncClientBuilder;
import software.amazon.awssdk.services.pipes.PipesAsyncClientBuilder;
import software.amazon.awssdk.services.pipes.PipesServiceClientConfiguration;
import software.amazon.awssdk.services.pipes.model.CreatePipeRequest;
import software.amazon.awssdk.services.pipes.model.CreatePipeResponse;
import software.amazon.awssdk.services.pipes.model.DeletePipeRequest;
import software.amazon.awssdk.services.pipes.model.DeletePipeResponse;
import software.amazon.awssdk.services.pipes.model.DescribePipeRequest;
import software.amazon.awssdk.services.pipes.model.DescribePipeResponse;
import software.amazon.awssdk.services.pipes.model.ListPipesRequest;
import software.amazon.awssdk.services.pipes.model.ListPipesResponse;
import software.amazon.awssdk.services.pipes.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.pipes.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.pipes.model.StartPipeRequest;
import software.amazon.awssdk.services.pipes.model.StartPipeResponse;
import software.amazon.awssdk.services.pipes.model.StopPipeRequest;
import software.amazon.awssdk.services.pipes.model.StopPipeResponse;
import software.amazon.awssdk.services.pipes.model.TagResourceRequest;
import software.amazon.awssdk.services.pipes.model.TagResourceResponse;
import software.amazon.awssdk.services.pipes.model.UntagResourceRequest;
import software.amazon.awssdk.services.pipes.model.UntagResourceResponse;
import software.amazon.awssdk.services.pipes.model.UpdatePipeRequest;
import software.amazon.awssdk.services.pipes.model.UpdatePipeResponse;
import software.amazon.awssdk.services.pipes.paginators.ListPipesPublisher;

@SdkPublicApi
@ThreadSafe
public interface PipesAsyncClient
extends AwsClient {
    public static final String SERVICE_NAME = "pipes";
    public static final String SERVICE_METADATA_ID = "pipes";

    default public CompletableFuture<CreatePipeResponse> createPipe(CreatePipeRequest createPipeRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CreatePipeResponse> createPipe(Consumer<CreatePipeRequest.Builder> createPipeRequest) {
        return this.createPipe((CreatePipeRequest)((Object)((CreatePipeRequest.Builder)CreatePipeRequest.builder().applyMutation(createPipeRequest)).build()));
    }

    default public CompletableFuture<DeletePipeResponse> deletePipe(DeletePipeRequest deletePipeRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeletePipeResponse> deletePipe(Consumer<DeletePipeRequest.Builder> deletePipeRequest) {
        return this.deletePipe((DeletePipeRequest)((Object)((DeletePipeRequest.Builder)DeletePipeRequest.builder().applyMutation(deletePipeRequest)).build()));
    }

    default public CompletableFuture<DescribePipeResponse> describePipe(DescribePipeRequest describePipeRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DescribePipeResponse> describePipe(Consumer<DescribePipeRequest.Builder> describePipeRequest) {
        return this.describePipe((DescribePipeRequest)((Object)((DescribePipeRequest.Builder)DescribePipeRequest.builder().applyMutation(describePipeRequest)).build()));
    }

    default public CompletableFuture<ListPipesResponse> listPipes(ListPipesRequest listPipesRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListPipesResponse> listPipes(Consumer<ListPipesRequest.Builder> listPipesRequest) {
        return this.listPipes((ListPipesRequest)((Object)((ListPipesRequest.Builder)ListPipesRequest.builder().applyMutation(listPipesRequest)).build()));
    }

    default public ListPipesPublisher listPipesPaginator(ListPipesRequest listPipesRequest) {
        return new ListPipesPublisher(this, listPipesRequest);
    }

    default public ListPipesPublisher listPipesPaginator(Consumer<ListPipesRequest.Builder> listPipesRequest) {
        return this.listPipesPaginator((ListPipesRequest)((Object)((ListPipesRequest.Builder)ListPipesRequest.builder().applyMutation(listPipesRequest)).build()));
    }

    default public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public CompletableFuture<StartPipeResponse> startPipe(StartPipeRequest startPipeRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<StartPipeResponse> startPipe(Consumer<StartPipeRequest.Builder> startPipeRequest) {
        return this.startPipe((StartPipeRequest)((Object)((StartPipeRequest.Builder)StartPipeRequest.builder().applyMutation(startPipeRequest)).build()));
    }

    default public CompletableFuture<StopPipeResponse> stopPipe(StopPipeRequest stopPipeRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<StopPipeResponse> stopPipe(Consumer<StopPipeRequest.Builder> stopPipeRequest) {
        return this.stopPipe((StopPipeRequest)((Object)((StopPipeRequest.Builder)StopPipeRequest.builder().applyMutation(stopPipeRequest)).build()));
    }

    default public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public CompletableFuture<UpdatePipeResponse> updatePipe(UpdatePipeRequest updatePipeRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UpdatePipeResponse> updatePipe(Consumer<UpdatePipeRequest.Builder> updatePipeRequest) {
        return this.updatePipe((UpdatePipeRequest)((Object)((UpdatePipeRequest.Builder)UpdatePipeRequest.builder().applyMutation(updatePipeRequest)).build()));
    }

    default public PipesServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    public static PipesAsyncClient create() {
        return (PipesAsyncClient)PipesAsyncClient.builder().build();
    }

    public static PipesAsyncClientBuilder builder() {
        return new DefaultPipesAsyncClientBuilder();
    }
}

