/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pipes.model.MeasureValueType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SingleMeasureMapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SingleMeasureMapping> {
    private static final SdkField<String> MEASURE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MeasureValue").getter(SingleMeasureMapping.getter(SingleMeasureMapping::measureValue)).setter(SingleMeasureMapping.setter(Builder::measureValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureValue").build()}).build();
    private static final SdkField<String> MEASURE_VALUE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MeasureValueType").getter(SingleMeasureMapping.getter(SingleMeasureMapping::measureValueTypeAsString)).setter(SingleMeasureMapping.setter(Builder::measureValueType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureValueType").build()}).build();
    private static final SdkField<String> MEASURE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MeasureName").getter(SingleMeasureMapping.getter(SingleMeasureMapping::measureName)).setter(SingleMeasureMapping.setter(Builder::measureName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEASURE_VALUE_FIELD, MEASURE_VALUE_TYPE_FIELD, MEASURE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SingleMeasureMapping.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String measureValue;
    private final String measureValueType;
    private final String measureName;

    private SingleMeasureMapping(BuilderImpl builder) {
        this.measureValue = builder.measureValue;
        this.measureValueType = builder.measureValueType;
        this.measureName = builder.measureName;
    }

    public final String measureValue() {
        return this.measureValue;
    }

    public final MeasureValueType measureValueType() {
        return MeasureValueType.fromValue(this.measureValueType);
    }

    public final String measureValueTypeAsString() {
        return this.measureValueType;
    }

    public final String measureName() {
        return this.measureName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.measureValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.measureValueTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.measureName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SingleMeasureMapping)) {
            return false;
        }
        SingleMeasureMapping other = (SingleMeasureMapping)obj;
        return Objects.equals(this.measureValue(), other.measureValue()) && Objects.equals(this.measureValueTypeAsString(), other.measureValueTypeAsString()) && Objects.equals(this.measureName(), other.measureName());
    }

    public final String toString() {
        return ToString.builder((String)"SingleMeasureMapping").add("MeasureValue", (Object)this.measureValue()).add("MeasureValueType", (Object)this.measureValueTypeAsString()).add("MeasureName", (Object)this.measureName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MeasureValue": {
                return Optional.ofNullable(clazz.cast(this.measureValue()));
            }
            case "MeasureValueType": {
                return Optional.ofNullable(clazz.cast(this.measureValueTypeAsString()));
            }
            case "MeasureName": {
                return Optional.ofNullable(clazz.cast(this.measureName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("MeasureValue", MEASURE_VALUE_FIELD);
        map.put("MeasureValueType", MEASURE_VALUE_TYPE_FIELD);
        map.put("MeasureName", MEASURE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SingleMeasureMapping, T> g) {
        return obj -> g.apply((SingleMeasureMapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String measureValue;
        private String measureValueType;
        private String measureName;

        private BuilderImpl() {
        }

        private BuilderImpl(SingleMeasureMapping model) {
            this.measureValue(model.measureValue);
            this.measureValueType(model.measureValueType);
            this.measureName(model.measureName);
        }

        public final String getMeasureValue() {
            return this.measureValue;
        }

        public final void setMeasureValue(String measureValue) {
            this.measureValue = measureValue;
        }

        @Override
        public final Builder measureValue(String measureValue) {
            this.measureValue = measureValue;
            return this;
        }

        public final String getMeasureValueType() {
            return this.measureValueType;
        }

        public final void setMeasureValueType(String measureValueType) {
            this.measureValueType = measureValueType;
        }

        @Override
        public final Builder measureValueType(String measureValueType) {
            this.measureValueType = measureValueType;
            return this;
        }

        @Override
        public final Builder measureValueType(MeasureValueType measureValueType) {
            this.measureValueType(measureValueType == null ? null : measureValueType.toString());
            return this;
        }

        public final String getMeasureName() {
            return this.measureName;
        }

        public final void setMeasureName(String measureName) {
            this.measureName = measureName;
        }

        @Override
        public final Builder measureName(String measureName) {
            this.measureName = measureName;
            return this;
        }

        public SingleMeasureMapping build() {
            return new SingleMeasureMapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SingleMeasureMapping> {
        public Builder measureValue(String var1);

        public Builder measureValueType(String var1);

        public Builder measureValueType(MeasureValueType var1);

        public Builder measureName(String var1);
    }
}

