/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Request;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationFilter;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationFilterListCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRegistrationsRequest
extends PinpointSmsVoiceV2Request
implements ToCopyableBuilder<Builder, DescribeRegistrationsRequest> {
    private static final SdkField<List<String>> REGISTRATION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RegistrationIds").getter(DescribeRegistrationsRequest.getter(DescribeRegistrationsRequest::registrationIds)).setter(DescribeRegistrationsRequest.setter(Builder::registrationIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RegistrationFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeRegistrationsRequest.getter(DescribeRegistrationsRequest::filters)).setter(DescribeRegistrationsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RegistrationFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeRegistrationsRequest.getter(DescribeRegistrationsRequest::nextToken)).setter(DescribeRegistrationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeRegistrationsRequest.getter(DescribeRegistrationsRequest::maxResults)).setter(DescribeRegistrationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRATION_IDS_FIELD, FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeRegistrationsRequest.memberNameToFieldInitializer();
    private final List<String> registrationIds;
    private final List<RegistrationFilter> filters;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeRegistrationsRequest(BuilderImpl builder) {
        super(builder);
        this.registrationIds = builder.registrationIds;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final boolean hasRegistrationIds() {
        return this.registrationIds != null && !(this.registrationIds instanceof SdkAutoConstructList);
    }

    public final List<String> registrationIds() {
        return this.registrationIds;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<RegistrationFilter> filters() {
        return this.filters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegistrationIds() ? this.registrationIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRegistrationsRequest)) {
            return false;
        }
        DescribeRegistrationsRequest other = (DescribeRegistrationsRequest)((Object)obj);
        return this.hasRegistrationIds() == other.hasRegistrationIds() && Objects.equals(this.registrationIds(), other.registrationIds()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeRegistrationsRequest").add("RegistrationIds", this.hasRegistrationIds() ? this.registrationIds() : null).add("Filters", this.hasFilters() ? this.filters() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegistrationIds": {
                return Optional.ofNullable(clazz.cast(this.registrationIds()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RegistrationIds", REGISTRATION_IDS_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRegistrationsRequest, T> g) {
        return obj -> g.apply((DescribeRegistrationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Request.BuilderImpl
    implements Builder {
        private List<String> registrationIds = DefaultSdkAutoConstructList.getInstance();
        private List<RegistrationFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRegistrationsRequest model) {
            super(model);
            this.registrationIds(model.registrationIds);
            this.filters(model.filters);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Collection<String> getRegistrationIds() {
            if (this.registrationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.registrationIds;
        }

        public final void setRegistrationIds(Collection<String> registrationIds) {
            this.registrationIds = RegistrationIdListCopier.copy(registrationIds);
        }

        @Override
        public final Builder registrationIds(Collection<String> registrationIds) {
            this.registrationIds = RegistrationIdListCopier.copy(registrationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registrationIds(String ... registrationIds) {
            this.registrationIds(Arrays.asList(registrationIds));
            return this;
        }

        public final List<RegistrationFilter.Builder> getFilters() {
            List<RegistrationFilter.Builder> result = RegistrationFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<RegistrationFilter.BuilderImpl> filters) {
            this.filters = RegistrationFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<RegistrationFilter> filters) {
            this.filters = RegistrationFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(RegistrationFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<RegistrationFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (RegistrationFilter)((RegistrationFilter.Builder)RegistrationFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRegistrationsRequest build() {
            return new DescribeRegistrationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PinpointSmsVoiceV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRegistrationsRequest> {
        public Builder registrationIds(Collection<String> var1);

        public Builder registrationIds(String ... var1);

        public Builder filters(Collection<RegistrationFilter> var1);

        public Builder filters(RegistrationFilter ... var1);

        public Builder filters(Consumer<RegistrationFilter.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

