/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PhoneNumberInformation;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PhoneNumberInformationListCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePhoneNumbersResponse
extends PinpointSmsVoiceV2Response
implements ToCopyableBuilder<Builder, DescribePhoneNumbersResponse> {
    private static final SdkField<List<PhoneNumberInformation>> PHONE_NUMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PhoneNumbers").getter(DescribePhoneNumbersResponse.getter(DescribePhoneNumbersResponse::phoneNumbers)).setter(DescribePhoneNumbersResponse.setter(Builder::phoneNumbers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumbers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PhoneNumberInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribePhoneNumbersResponse.getter(DescribePhoneNumbersResponse::nextToken)).setter(DescribePhoneNumbersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribePhoneNumbersResponse.memberNameToFieldInitializer();
    private final List<PhoneNumberInformation> phoneNumbers;
    private final String nextToken;

    private DescribePhoneNumbersResponse(BuilderImpl builder) {
        super(builder);
        this.phoneNumbers = builder.phoneNumbers;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPhoneNumbers() {
        return this.phoneNumbers != null && !(this.phoneNumbers instanceof SdkAutoConstructList);
    }

    public final List<PhoneNumberInformation> phoneNumbers() {
        return this.phoneNumbers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhoneNumbers() ? this.phoneNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePhoneNumbersResponse)) {
            return false;
        }
        DescribePhoneNumbersResponse other = (DescribePhoneNumbersResponse)((Object)obj);
        return this.hasPhoneNumbers() == other.hasPhoneNumbers() && Objects.equals(this.phoneNumbers(), other.phoneNumbers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePhoneNumbersResponse").add("PhoneNumbers", this.hasPhoneNumbers() ? this.phoneNumbers() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PhoneNumbers": {
                return Optional.ofNullable(clazz.cast(this.phoneNumbers()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PhoneNumbers", PHONE_NUMBERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribePhoneNumbersResponse, T> g) {
        return obj -> g.apply((DescribePhoneNumbersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Response.BuilderImpl
    implements Builder {
        private List<PhoneNumberInformation> phoneNumbers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePhoneNumbersResponse model) {
            super(model);
            this.phoneNumbers(model.phoneNumbers);
            this.nextToken(model.nextToken);
        }

        public final List<PhoneNumberInformation.Builder> getPhoneNumbers() {
            List<PhoneNumberInformation.Builder> result = PhoneNumberInformationListCopier.copyToBuilder(this.phoneNumbers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhoneNumbers(Collection<PhoneNumberInformation.BuilderImpl> phoneNumbers) {
            this.phoneNumbers = PhoneNumberInformationListCopier.copyFromBuilder(phoneNumbers);
        }

        @Override
        public final Builder phoneNumbers(Collection<PhoneNumberInformation> phoneNumbers) {
            this.phoneNumbers = PhoneNumberInformationListCopier.copy(phoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumbers(PhoneNumberInformation ... phoneNumbers) {
            this.phoneNumbers(Arrays.asList(phoneNumbers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumbers(Consumer<PhoneNumberInformation.Builder> ... phoneNumbers) {
            this.phoneNumbers(Stream.of(phoneNumbers).map(c -> (PhoneNumberInformation)((PhoneNumberInformation.Builder)PhoneNumberInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribePhoneNumbersResponse build() {
            return new DescribePhoneNumbersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PinpointSmsVoiceV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePhoneNumbersResponse> {
        public Builder phoneNumbers(Collection<PhoneNumberInformation> var1);

        public Builder phoneNumbers(PhoneNumberInformation ... var1);

        public Builder phoneNumbers(Consumer<PhoneNumberInformation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

