/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2Client;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldDefinitionsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldDefinitionsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationFieldDefinition;

public class DescribeRegistrationFieldDefinitionsIterable
implements SdkIterable<DescribeRegistrationFieldDefinitionsResponse> {
    private final PinpointSmsVoiceV2Client client;
    private final DescribeRegistrationFieldDefinitionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeRegistrationFieldDefinitionsIterable(PinpointSmsVoiceV2Client client, DescribeRegistrationFieldDefinitionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeRegistrationFieldDefinitionsResponseFetcher();
    }

    public Iterator<DescribeRegistrationFieldDefinitionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RegistrationFieldDefinition> registrationFieldDefinitions() {
        Function<DescribeRegistrationFieldDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.registrationFieldDefinitions() != null) {
                return response.registrationFieldDefinitions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeRegistrationFieldDefinitionsResponseFetcher
    implements SyncPageFetcher<DescribeRegistrationFieldDefinitionsResponse> {
        private DescribeRegistrationFieldDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRegistrationFieldDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeRegistrationFieldDefinitionsResponse nextPage(DescribeRegistrationFieldDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeRegistrationFieldDefinitionsIterable.this.client.describeRegistrationFieldDefinitions(DescribeRegistrationFieldDefinitionsIterable.this.firstRequest);
            }
            return DescribeRegistrationFieldDefinitionsIterable.this.client.describeRegistrationFieldDefinitions((DescribeRegistrationFieldDefinitionsRequest)((Object)DescribeRegistrationFieldDefinitionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

