/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.MessageFeedbackStatus;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutMessageFeedbackRequest
extends PinpointSmsVoiceV2Request
implements ToCopyableBuilder<Builder, PutMessageFeedbackRequest> {
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageId").getter(PutMessageFeedbackRequest.getter(PutMessageFeedbackRequest::messageId)).setter(PutMessageFeedbackRequest.setter(Builder::messageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageId").build()}).build();
    private static final SdkField<String> MESSAGE_FEEDBACK_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageFeedbackStatus").getter(PutMessageFeedbackRequest.getter(PutMessageFeedbackRequest::messageFeedbackStatusAsString)).setter(PutMessageFeedbackRequest.setter(Builder::messageFeedbackStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageFeedbackStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_ID_FIELD, MESSAGE_FEEDBACK_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutMessageFeedbackRequest.memberNameToFieldInitializer();
    private final String messageId;
    private final String messageFeedbackStatus;

    private PutMessageFeedbackRequest(BuilderImpl builder) {
        super(builder);
        this.messageId = builder.messageId;
        this.messageFeedbackStatus = builder.messageFeedbackStatus;
    }

    public final String messageId() {
        return this.messageId;
    }

    public final MessageFeedbackStatus messageFeedbackStatus() {
        return MessageFeedbackStatus.fromValue(this.messageFeedbackStatus);
    }

    public final String messageFeedbackStatusAsString() {
        return this.messageFeedbackStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.messageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageFeedbackStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMessageFeedbackRequest)) {
            return false;
        }
        PutMessageFeedbackRequest other = (PutMessageFeedbackRequest)((Object)obj);
        return Objects.equals(this.messageId(), other.messageId()) && Objects.equals(this.messageFeedbackStatusAsString(), other.messageFeedbackStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PutMessageFeedbackRequest").add("MessageId", (Object)this.messageId()).add("MessageFeedbackStatus", (Object)this.messageFeedbackStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MessageId": {
                return Optional.ofNullable(clazz.cast(this.messageId()));
            }
            case "MessageFeedbackStatus": {
                return Optional.ofNullable(clazz.cast(this.messageFeedbackStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("MessageId", MESSAGE_ID_FIELD);
        map.put("MessageFeedbackStatus", MESSAGE_FEEDBACK_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutMessageFeedbackRequest, T> g) {
        return obj -> g.apply((PutMessageFeedbackRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Request.BuilderImpl
    implements Builder {
        private String messageId;
        private String messageFeedbackStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(PutMessageFeedbackRequest model) {
            super(model);
            this.messageId(model.messageId);
            this.messageFeedbackStatus(model.messageFeedbackStatus);
        }

        public final String getMessageId() {
            return this.messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final String getMessageFeedbackStatus() {
            return this.messageFeedbackStatus;
        }

        public final void setMessageFeedbackStatus(String messageFeedbackStatus) {
            this.messageFeedbackStatus = messageFeedbackStatus;
        }

        @Override
        public final Builder messageFeedbackStatus(String messageFeedbackStatus) {
            this.messageFeedbackStatus = messageFeedbackStatus;
            return this;
        }

        @Override
        public final Builder messageFeedbackStatus(MessageFeedbackStatus messageFeedbackStatus) {
            this.messageFeedbackStatus(messageFeedbackStatus == null ? null : messageFeedbackStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutMessageFeedbackRequest build() {
            return new PutMessageFeedbackRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PinpointSmsVoiceV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutMessageFeedbackRequest> {
        public Builder messageId(String var1);

        public Builder messageFeedbackStatus(String var1);

        public Builder messageFeedbackStatus(MessageFeedbackStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

