/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptedOutNumberInformation;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptedOutNumberInformationListCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOptedOutNumbersResponse
extends PinpointSmsVoiceV2Response
implements ToCopyableBuilder<Builder, DescribeOptedOutNumbersResponse> {
    private static final SdkField<String> OPT_OUT_LIST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptOutListArn").getter(DescribeOptedOutNumbersResponse.getter(DescribeOptedOutNumbersResponse::optOutListArn)).setter(DescribeOptedOutNumbersResponse.setter(Builder::optOutListArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptOutListArn").build()}).build();
    private static final SdkField<String> OPT_OUT_LIST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptOutListName").getter(DescribeOptedOutNumbersResponse.getter(DescribeOptedOutNumbersResponse::optOutListName)).setter(DescribeOptedOutNumbersResponse.setter(Builder::optOutListName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptOutListName").build()}).build();
    private static final SdkField<List<OptedOutNumberInformation>> OPTED_OUT_NUMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OptedOutNumbers").getter(DescribeOptedOutNumbersResponse.getter(DescribeOptedOutNumbersResponse::optedOutNumbers)).setter(DescribeOptedOutNumbersResponse.setter(Builder::optedOutNumbers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptedOutNumbers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OptedOutNumberInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeOptedOutNumbersResponse.getter(DescribeOptedOutNumbersResponse::nextToken)).setter(DescribeOptedOutNumbersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPT_OUT_LIST_ARN_FIELD, OPT_OUT_LIST_NAME_FIELD, OPTED_OUT_NUMBERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeOptedOutNumbersResponse.memberNameToFieldInitializer();
    private final String optOutListArn;
    private final String optOutListName;
    private final List<OptedOutNumberInformation> optedOutNumbers;
    private final String nextToken;

    private DescribeOptedOutNumbersResponse(BuilderImpl builder) {
        super(builder);
        this.optOutListArn = builder.optOutListArn;
        this.optOutListName = builder.optOutListName;
        this.optedOutNumbers = builder.optedOutNumbers;
        this.nextToken = builder.nextToken;
    }

    public final String optOutListArn() {
        return this.optOutListArn;
    }

    public final String optOutListName() {
        return this.optOutListName;
    }

    public final boolean hasOptedOutNumbers() {
        return this.optedOutNumbers != null && !(this.optedOutNumbers instanceof SdkAutoConstructList);
    }

    public final List<OptedOutNumberInformation> optedOutNumbers() {
        return this.optedOutNumbers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.optOutListArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.optOutListName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptedOutNumbers() ? this.optedOutNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOptedOutNumbersResponse)) {
            return false;
        }
        DescribeOptedOutNumbersResponse other = (DescribeOptedOutNumbersResponse)((Object)obj);
        return Objects.equals(this.optOutListArn(), other.optOutListArn()) && Objects.equals(this.optOutListName(), other.optOutListName()) && this.hasOptedOutNumbers() == other.hasOptedOutNumbers() && Objects.equals(this.optedOutNumbers(), other.optedOutNumbers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeOptedOutNumbersResponse").add("OptOutListArn", (Object)this.optOutListArn()).add("OptOutListName", (Object)this.optOutListName()).add("OptedOutNumbers", this.hasOptedOutNumbers() ? this.optedOutNumbers() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OptOutListArn": {
                return Optional.ofNullable(clazz.cast(this.optOutListArn()));
            }
            case "OptOutListName": {
                return Optional.ofNullable(clazz.cast(this.optOutListName()));
            }
            case "OptedOutNumbers": {
                return Optional.ofNullable(clazz.cast(this.optedOutNumbers()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OptOutListArn", OPT_OUT_LIST_ARN_FIELD);
        map.put("OptOutListName", OPT_OUT_LIST_NAME_FIELD);
        map.put("OptedOutNumbers", OPTED_OUT_NUMBERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeOptedOutNumbersResponse, T> g) {
        return obj -> g.apply((DescribeOptedOutNumbersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Response.BuilderImpl
    implements Builder {
        private String optOutListArn;
        private String optOutListName;
        private List<OptedOutNumberInformation> optedOutNumbers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOptedOutNumbersResponse model) {
            super(model);
            this.optOutListArn(model.optOutListArn);
            this.optOutListName(model.optOutListName);
            this.optedOutNumbers(model.optedOutNumbers);
            this.nextToken(model.nextToken);
        }

        public final String getOptOutListArn() {
            return this.optOutListArn;
        }

        public final void setOptOutListArn(String optOutListArn) {
            this.optOutListArn = optOutListArn;
        }

        @Override
        public final Builder optOutListArn(String optOutListArn) {
            this.optOutListArn = optOutListArn;
            return this;
        }

        public final String getOptOutListName() {
            return this.optOutListName;
        }

        public final void setOptOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
        }

        @Override
        public final Builder optOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
            return this;
        }

        public final List<OptedOutNumberInformation.Builder> getOptedOutNumbers() {
            List<OptedOutNumberInformation.Builder> result = OptedOutNumberInformationListCopier.copyToBuilder(this.optedOutNumbers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptedOutNumbers(Collection<OptedOutNumberInformation.BuilderImpl> optedOutNumbers) {
            this.optedOutNumbers = OptedOutNumberInformationListCopier.copyFromBuilder(optedOutNumbers);
        }

        @Override
        public final Builder optedOutNumbers(Collection<OptedOutNumberInformation> optedOutNumbers) {
            this.optedOutNumbers = OptedOutNumberInformationListCopier.copy(optedOutNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optedOutNumbers(OptedOutNumberInformation ... optedOutNumbers) {
            this.optedOutNumbers(Arrays.asList(optedOutNumbers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optedOutNumbers(Consumer<OptedOutNumberInformation.Builder> ... optedOutNumbers) {
            this.optedOutNumbers(Stream.of(optedOutNumbers).map(c -> (OptedOutNumberInformation)((OptedOutNumberInformation.Builder)OptedOutNumberInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeOptedOutNumbersResponse build() {
            return new DescribeOptedOutNumbersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PinpointSmsVoiceV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeOptedOutNumbersResponse> {
        public Builder optOutListArn(String var1);

        public Builder optOutListName(String var1);

        public Builder optedOutNumbers(Collection<OptedOutNumberInformation> var1);

        public Builder optedOutNumbers(OptedOutNumberInformation ... var1);

        public Builder optedOutNumbers(Consumer<OptedOutNumberInformation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

