/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationTypeDisplayHints;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SupportedAssociation;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SupportedAssociationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegistrationTypeDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RegistrationTypeDefinition> {
    private static final SdkField<String> REGISTRATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistrationType").getter(RegistrationTypeDefinition.getter(RegistrationTypeDefinition::registrationType)).setter(RegistrationTypeDefinition.setter(Builder::registrationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationType").build()}).build();
    private static final SdkField<List<SupportedAssociation>> SUPPORTED_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedAssociations").getter(RegistrationTypeDefinition.getter(RegistrationTypeDefinition::supportedAssociations)).setter(RegistrationTypeDefinition.setter(Builder::supportedAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SupportedAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RegistrationTypeDisplayHints> DISPLAY_HINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DisplayHints").getter(RegistrationTypeDefinition.getter(RegistrationTypeDefinition::displayHints)).setter(RegistrationTypeDefinition.setter(Builder::displayHints)).constructor(RegistrationTypeDisplayHints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayHints").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRATION_TYPE_FIELD, SUPPORTED_ASSOCIATIONS_FIELD, DISPLAY_HINTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RegistrationTypeDefinition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String registrationType;
    private final List<SupportedAssociation> supportedAssociations;
    private final RegistrationTypeDisplayHints displayHints;

    private RegistrationTypeDefinition(BuilderImpl builder) {
        this.registrationType = builder.registrationType;
        this.supportedAssociations = builder.supportedAssociations;
        this.displayHints = builder.displayHints;
    }

    public final String registrationType() {
        return this.registrationType;
    }

    public final boolean hasSupportedAssociations() {
        return this.supportedAssociations != null && !(this.supportedAssociations instanceof SdkAutoConstructList);
    }

    public final List<SupportedAssociation> supportedAssociations() {
        return this.supportedAssociations;
    }

    public final RegistrationTypeDisplayHints displayHints() {
        return this.displayHints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedAssociations() ? this.supportedAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.displayHints());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegistrationTypeDefinition)) {
            return false;
        }
        RegistrationTypeDefinition other = (RegistrationTypeDefinition)obj;
        return Objects.equals(this.registrationType(), other.registrationType()) && this.hasSupportedAssociations() == other.hasSupportedAssociations() && Objects.equals(this.supportedAssociations(), other.supportedAssociations()) && Objects.equals(this.displayHints(), other.displayHints());
    }

    public final String toString() {
        return ToString.builder((String)"RegistrationTypeDefinition").add("RegistrationType", (Object)this.registrationType()).add("SupportedAssociations", this.hasSupportedAssociations() ? this.supportedAssociations() : null).add("DisplayHints", (Object)this.displayHints()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegistrationType": {
                return Optional.ofNullable(clazz.cast(this.registrationType()));
            }
            case "SupportedAssociations": {
                return Optional.ofNullable(clazz.cast(this.supportedAssociations()));
            }
            case "DisplayHints": {
                return Optional.ofNullable(clazz.cast(this.displayHints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RegistrationType", REGISTRATION_TYPE_FIELD);
        map.put("SupportedAssociations", SUPPORTED_ASSOCIATIONS_FIELD);
        map.put("DisplayHints", DISPLAY_HINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegistrationTypeDefinition, T> g) {
        return obj -> g.apply((RegistrationTypeDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String registrationType;
        private List<SupportedAssociation> supportedAssociations = DefaultSdkAutoConstructList.getInstance();
        private RegistrationTypeDisplayHints displayHints;

        private BuilderImpl() {
        }

        private BuilderImpl(RegistrationTypeDefinition model) {
            this.registrationType(model.registrationType);
            this.supportedAssociations(model.supportedAssociations);
            this.displayHints(model.displayHints);
        }

        public final String getRegistrationType() {
            return this.registrationType;
        }

        public final void setRegistrationType(String registrationType) {
            this.registrationType = registrationType;
        }

        @Override
        public final Builder registrationType(String registrationType) {
            this.registrationType = registrationType;
            return this;
        }

        public final List<SupportedAssociation.Builder> getSupportedAssociations() {
            List<SupportedAssociation.Builder> result = SupportedAssociationListCopier.copyToBuilder(this.supportedAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportedAssociations(Collection<SupportedAssociation.BuilderImpl> supportedAssociations) {
            this.supportedAssociations = SupportedAssociationListCopier.copyFromBuilder(supportedAssociations);
        }

        @Override
        public final Builder supportedAssociations(Collection<SupportedAssociation> supportedAssociations) {
            this.supportedAssociations = SupportedAssociationListCopier.copy(supportedAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedAssociations(SupportedAssociation ... supportedAssociations) {
            this.supportedAssociations(Arrays.asList(supportedAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedAssociations(Consumer<SupportedAssociation.Builder> ... supportedAssociations) {
            this.supportedAssociations(Stream.of(supportedAssociations).map(c -> (SupportedAssociation)((SupportedAssociation.Builder)SupportedAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final RegistrationTypeDisplayHints.Builder getDisplayHints() {
            return this.displayHints != null ? this.displayHints.toBuilder() : null;
        }

        public final void setDisplayHints(RegistrationTypeDisplayHints.BuilderImpl displayHints) {
            this.displayHints = displayHints != null ? displayHints.build() : null;
        }

        @Override
        public final Builder displayHints(RegistrationTypeDisplayHints displayHints) {
            this.displayHints = displayHints;
            return this;
        }

        public RegistrationTypeDefinition build() {
            return new RegistrationTypeDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RegistrationTypeDefinition> {
        public Builder registrationType(String var1);

        public Builder supportedAssociations(Collection<SupportedAssociation> var1);

        public Builder supportedAssociations(SupportedAssociation ... var1);

        public Builder supportedAssociations(Consumer<SupportedAssociation.Builder> ... var1);

        public Builder displayHints(RegistrationTypeDisplayHints var1);

        default public Builder displayHints(Consumer<RegistrationTypeDisplayHints.Builder> displayHints) {
            return this.displayHints((RegistrationTypeDisplayHints)((RegistrationTypeDisplayHints.Builder)RegistrationTypeDisplayHints.builder().applyMutation(displayHints)).build());
        }
    }
}

