/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Response;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProtectConfigurationResponse
extends PinpointSmsVoiceV2Response
implements ToCopyableBuilder<Builder, CreateProtectConfigurationResponse> {
    private static final SdkField<String> PROTECT_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProtectConfigurationArn").getter(CreateProtectConfigurationResponse.getter(CreateProtectConfigurationResponse::protectConfigurationArn)).setter(CreateProtectConfigurationResponse.setter(Builder::protectConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationArn").build()}).build();
    private static final SdkField<String> PROTECT_CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProtectConfigurationId").getter(CreateProtectConfigurationResponse.getter(CreateProtectConfigurationResponse::protectConfigurationId)).setter(CreateProtectConfigurationResponse.setter(Builder::protectConfigurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationId").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(CreateProtectConfigurationResponse.getter(CreateProtectConfigurationResponse::createdTimestamp)).setter(CreateProtectConfigurationResponse.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final SdkField<Boolean> ACCOUNT_DEFAULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AccountDefault").getter(CreateProtectConfigurationResponse.getter(CreateProtectConfigurationResponse::accountDefault)).setter(CreateProtectConfigurationResponse.setter(Builder::accountDefault)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountDefault").build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeletionProtectionEnabled").getter(CreateProtectConfigurationResponse.getter(CreateProtectConfigurationResponse::deletionProtectionEnabled)).setter(CreateProtectConfigurationResponse.setter(Builder::deletionProtectionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtectionEnabled").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateProtectConfigurationResponse.getter(CreateProtectConfigurationResponse::tags)).setter(CreateProtectConfigurationResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTECT_CONFIGURATION_ARN_FIELD, PROTECT_CONFIGURATION_ID_FIELD, CREATED_TIMESTAMP_FIELD, ACCOUNT_DEFAULT_FIELD, DELETION_PROTECTION_ENABLED_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateProtectConfigurationResponse.memberNameToFieldInitializer();
    private final String protectConfigurationArn;
    private final String protectConfigurationId;
    private final Instant createdTimestamp;
    private final Boolean accountDefault;
    private final Boolean deletionProtectionEnabled;
    private final List<Tag> tags;

    private CreateProtectConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.protectConfigurationArn = builder.protectConfigurationArn;
        this.protectConfigurationId = builder.protectConfigurationId;
        this.createdTimestamp = builder.createdTimestamp;
        this.accountDefault = builder.accountDefault;
        this.deletionProtectionEnabled = builder.deletionProtectionEnabled;
        this.tags = builder.tags;
    }

    public final String protectConfigurationArn() {
        return this.protectConfigurationArn;
    }

    public final String protectConfigurationId() {
        return this.protectConfigurationId;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Boolean accountDefault() {
        return this.accountDefault;
    }

    public final Boolean deletionProtectionEnabled() {
        return this.deletionProtectionEnabled;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.protectConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.protectConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountDefault());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtectionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProtectConfigurationResponse)) {
            return false;
        }
        CreateProtectConfigurationResponse other = (CreateProtectConfigurationResponse)((Object)obj);
        return Objects.equals(this.protectConfigurationArn(), other.protectConfigurationArn()) && Objects.equals(this.protectConfigurationId(), other.protectConfigurationId()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.accountDefault(), other.accountDefault()) && Objects.equals(this.deletionProtectionEnabled(), other.deletionProtectionEnabled()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateProtectConfigurationResponse").add("ProtectConfigurationArn", (Object)this.protectConfigurationArn()).add("ProtectConfigurationId", (Object)this.protectConfigurationId()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("AccountDefault", (Object)this.accountDefault()).add("DeletionProtectionEnabled", (Object)this.deletionProtectionEnabled()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProtectConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.protectConfigurationArn()));
            }
            case "ProtectConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.protectConfigurationId()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "AccountDefault": {
                return Optional.ofNullable(clazz.cast(this.accountDefault()));
            }
            case "DeletionProtectionEnabled": {
                return Optional.ofNullable(clazz.cast(this.deletionProtectionEnabled()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProtectConfigurationArn", PROTECT_CONFIGURATION_ARN_FIELD);
        map.put("ProtectConfigurationId", PROTECT_CONFIGURATION_ID_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("AccountDefault", ACCOUNT_DEFAULT_FIELD);
        map.put("DeletionProtectionEnabled", DELETION_PROTECTION_ENABLED_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProtectConfigurationResponse, T> g) {
        return obj -> g.apply((CreateProtectConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Response.BuilderImpl
    implements Builder {
        private String protectConfigurationArn;
        private String protectConfigurationId;
        private Instant createdTimestamp;
        private Boolean accountDefault;
        private Boolean deletionProtectionEnabled;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProtectConfigurationResponse model) {
            super(model);
            this.protectConfigurationArn(model.protectConfigurationArn);
            this.protectConfigurationId(model.protectConfigurationId);
            this.createdTimestamp(model.createdTimestamp);
            this.accountDefault(model.accountDefault);
            this.deletionProtectionEnabled(model.deletionProtectionEnabled);
            this.tags(model.tags);
        }

        public final String getProtectConfigurationArn() {
            return this.protectConfigurationArn;
        }

        public final void setProtectConfigurationArn(String protectConfigurationArn) {
            this.protectConfigurationArn = protectConfigurationArn;
        }

        @Override
        public final Builder protectConfigurationArn(String protectConfigurationArn) {
            this.protectConfigurationArn = protectConfigurationArn;
            return this;
        }

        public final String getProtectConfigurationId() {
            return this.protectConfigurationId;
        }

        public final void setProtectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
        }

        @Override
        public final Builder protectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Boolean getAccountDefault() {
            return this.accountDefault;
        }

        public final void setAccountDefault(Boolean accountDefault) {
            this.accountDefault = accountDefault;
        }

        @Override
        public final Builder accountDefault(Boolean accountDefault) {
            this.accountDefault = accountDefault;
            return this;
        }

        public final Boolean getDeletionProtectionEnabled() {
            return this.deletionProtectionEnabled;
        }

        public final void setDeletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
        }

        @Override
        public final Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateProtectConfigurationResponse build() {
            return new CreateProtectConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProtectConfigurationResponse> {
        public Builder protectConfigurationArn(String var1);

        public Builder protectConfigurationId(String var1);

        public Builder createdTimestamp(Instant var1);

        public Builder accountDefault(Boolean var1);

        public Builder deletionProtectionEnabled(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

