/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Response;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.VerificationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerifyDestinationNumberResponse
extends PinpointSmsVoiceV2Response
implements ToCopyableBuilder<Builder, VerifyDestinationNumberResponse> {
    private static final SdkField<String> VERIFIED_DESTINATION_NUMBER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerifiedDestinationNumberArn").getter(VerifyDestinationNumberResponse.getter(VerifyDestinationNumberResponse::verifiedDestinationNumberArn)).setter(VerifyDestinationNumberResponse.setter(Builder::verifiedDestinationNumberArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedDestinationNumberArn").build()}).build();
    private static final SdkField<String> VERIFIED_DESTINATION_NUMBER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerifiedDestinationNumberId").getter(VerifyDestinationNumberResponse.getter(VerifyDestinationNumberResponse::verifiedDestinationNumberId)).setter(VerifyDestinationNumberResponse.setter(Builder::verifiedDestinationNumberId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedDestinationNumberId").build()}).build();
    private static final SdkField<String> DESTINATION_PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationPhoneNumber").getter(VerifyDestinationNumberResponse.getter(VerifyDestinationNumberResponse::destinationPhoneNumber)).setter(VerifyDestinationNumberResponse.setter(Builder::destinationPhoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPhoneNumber").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(VerifyDestinationNumberResponse.getter(VerifyDestinationNumberResponse::statusAsString)).setter(VerifyDestinationNumberResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(VerifyDestinationNumberResponse.getter(VerifyDestinationNumberResponse::createdTimestamp)).setter(VerifyDestinationNumberResponse.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERIFIED_DESTINATION_NUMBER_ARN_FIELD, VERIFIED_DESTINATION_NUMBER_ID_FIELD, DESTINATION_PHONE_NUMBER_FIELD, STATUS_FIELD, CREATED_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VerifyDestinationNumberResponse.memberNameToFieldInitializer();
    private final String verifiedDestinationNumberArn;
    private final String verifiedDestinationNumberId;
    private final String destinationPhoneNumber;
    private final String status;
    private final Instant createdTimestamp;

    private VerifyDestinationNumberResponse(BuilderImpl builder) {
        super(builder);
        this.verifiedDestinationNumberArn = builder.verifiedDestinationNumberArn;
        this.verifiedDestinationNumberId = builder.verifiedDestinationNumberId;
        this.destinationPhoneNumber = builder.destinationPhoneNumber;
        this.status = builder.status;
        this.createdTimestamp = builder.createdTimestamp;
    }

    public final String verifiedDestinationNumberArn() {
        return this.verifiedDestinationNumberArn;
    }

    public final String verifiedDestinationNumberId() {
        return this.verifiedDestinationNumberId;
    }

    public final String destinationPhoneNumber() {
        return this.destinationPhoneNumber;
    }

    public final VerificationStatus status() {
        return VerificationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.verifiedDestinationNumberArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.verifiedDestinationNumberId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyDestinationNumberResponse)) {
            return false;
        }
        VerifyDestinationNumberResponse other = (VerifyDestinationNumberResponse)((Object)obj);
        return Objects.equals(this.verifiedDestinationNumberArn(), other.verifiedDestinationNumberArn()) && Objects.equals(this.verifiedDestinationNumberId(), other.verifiedDestinationNumberId()) && Objects.equals(this.destinationPhoneNumber(), other.destinationPhoneNumber()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"VerifyDestinationNumberResponse").add("VerifiedDestinationNumberArn", (Object)this.verifiedDestinationNumberArn()).add("VerifiedDestinationNumberId", (Object)this.verifiedDestinationNumberId()).add("DestinationPhoneNumber", (Object)this.destinationPhoneNumber()).add("Status", (Object)this.statusAsString()).add("CreatedTimestamp", (Object)this.createdTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VerifiedDestinationNumberArn": {
                return Optional.ofNullable(clazz.cast(this.verifiedDestinationNumberArn()));
            }
            case "VerifiedDestinationNumberId": {
                return Optional.ofNullable(clazz.cast(this.verifiedDestinationNumberId()));
            }
            case "DestinationPhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.destinationPhoneNumber()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VerifiedDestinationNumberArn", VERIFIED_DESTINATION_NUMBER_ARN_FIELD);
        map.put("VerifiedDestinationNumberId", VERIFIED_DESTINATION_NUMBER_ID_FIELD);
        map.put("DestinationPhoneNumber", DESTINATION_PHONE_NUMBER_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VerifyDestinationNumberResponse, T> g) {
        return obj -> g.apply((VerifyDestinationNumberResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Response.BuilderImpl
    implements Builder {
        private String verifiedDestinationNumberArn;
        private String verifiedDestinationNumberId;
        private String destinationPhoneNumber;
        private String status;
        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyDestinationNumberResponse model) {
            super(model);
            this.verifiedDestinationNumberArn(model.verifiedDestinationNumberArn);
            this.verifiedDestinationNumberId(model.verifiedDestinationNumberId);
            this.destinationPhoneNumber(model.destinationPhoneNumber);
            this.status(model.status);
            this.createdTimestamp(model.createdTimestamp);
        }

        public final String getVerifiedDestinationNumberArn() {
            return this.verifiedDestinationNumberArn;
        }

        public final void setVerifiedDestinationNumberArn(String verifiedDestinationNumberArn) {
            this.verifiedDestinationNumberArn = verifiedDestinationNumberArn;
        }

        @Override
        public final Builder verifiedDestinationNumberArn(String verifiedDestinationNumberArn) {
            this.verifiedDestinationNumberArn = verifiedDestinationNumberArn;
            return this;
        }

        public final String getVerifiedDestinationNumberId() {
            return this.verifiedDestinationNumberId;
        }

        public final void setVerifiedDestinationNumberId(String verifiedDestinationNumberId) {
            this.verifiedDestinationNumberId = verifiedDestinationNumberId;
        }

        @Override
        public final Builder verifiedDestinationNumberId(String verifiedDestinationNumberId) {
            this.verifiedDestinationNumberId = verifiedDestinationNumberId;
            return this;
        }

        public final String getDestinationPhoneNumber() {
            return this.destinationPhoneNumber;
        }

        public final void setDestinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
        }

        @Override
        public final Builder destinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VerificationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        @Override
        public VerifyDestinationNumberResponse build() {
            return new VerifyDestinationNumberResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, VerifyDestinationNumberResponse> {
        public Builder verifiedDestinationNumberArn(String var1);

        public Builder verifiedDestinationNumberId(String var1);

        public Builder destinationPhoneNumber(String var1);

        public Builder status(String var1);

        public Builder status(VerificationStatus var1);

        public Builder createdTimestamp(Instant var1);
    }
}

