/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DestinationPhoneNumberListCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Request;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.VerifiedDestinationNumberFilter;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.VerifiedDestinationNumberFilterListCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.VerifiedDestinationNumberIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVerifiedDestinationNumbersRequest
extends PinpointSmsVoiceV2Request
implements ToCopyableBuilder<Builder, DescribeVerifiedDestinationNumbersRequest> {
    private static final SdkField<List<String>> VERIFIED_DESTINATION_NUMBER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VerifiedDestinationNumberIds").getter(DescribeVerifiedDestinationNumbersRequest.getter(DescribeVerifiedDestinationNumbersRequest::verifiedDestinationNumberIds)).setter(DescribeVerifiedDestinationNumbersRequest.setter(Builder::verifiedDestinationNumberIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedDestinationNumberIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DESTINATION_PHONE_NUMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DestinationPhoneNumbers").getter(DescribeVerifiedDestinationNumbersRequest.getter(DescribeVerifiedDestinationNumbersRequest::destinationPhoneNumbers)).setter(DescribeVerifiedDestinationNumbersRequest.setter(Builder::destinationPhoneNumbers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPhoneNumbers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<VerifiedDestinationNumberFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeVerifiedDestinationNumbersRequest.getter(DescribeVerifiedDestinationNumbersRequest::filters)).setter(DescribeVerifiedDestinationNumbersRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VerifiedDestinationNumberFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeVerifiedDestinationNumbersRequest.getter(DescribeVerifiedDestinationNumbersRequest::nextToken)).setter(DescribeVerifiedDestinationNumbersRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeVerifiedDestinationNumbersRequest.getter(DescribeVerifiedDestinationNumbersRequest::maxResults)).setter(DescribeVerifiedDestinationNumbersRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERIFIED_DESTINATION_NUMBER_IDS_FIELD, DESTINATION_PHONE_NUMBERS_FIELD, FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeVerifiedDestinationNumbersRequest.memberNameToFieldInitializer();
    private final List<String> verifiedDestinationNumberIds;
    private final List<String> destinationPhoneNumbers;
    private final List<VerifiedDestinationNumberFilter> filters;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeVerifiedDestinationNumbersRequest(BuilderImpl builder) {
        super(builder);
        this.verifiedDestinationNumberIds = builder.verifiedDestinationNumberIds;
        this.destinationPhoneNumbers = builder.destinationPhoneNumbers;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final boolean hasVerifiedDestinationNumberIds() {
        return this.verifiedDestinationNumberIds != null && !(this.verifiedDestinationNumberIds instanceof SdkAutoConstructList);
    }

    public final List<String> verifiedDestinationNumberIds() {
        return this.verifiedDestinationNumberIds;
    }

    public final boolean hasDestinationPhoneNumbers() {
        return this.destinationPhoneNumbers != null && !(this.destinationPhoneNumbers instanceof SdkAutoConstructList);
    }

    public final List<String> destinationPhoneNumbers() {
        return this.destinationPhoneNumbers;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<VerifiedDestinationNumberFilter> filters() {
        return this.filters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVerifiedDestinationNumberIds() ? this.verifiedDestinationNumberIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinationPhoneNumbers() ? this.destinationPhoneNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVerifiedDestinationNumbersRequest)) {
            return false;
        }
        DescribeVerifiedDestinationNumbersRequest other = (DescribeVerifiedDestinationNumbersRequest)((Object)obj);
        return this.hasVerifiedDestinationNumberIds() == other.hasVerifiedDestinationNumberIds() && Objects.equals(this.verifiedDestinationNumberIds(), other.verifiedDestinationNumberIds()) && this.hasDestinationPhoneNumbers() == other.hasDestinationPhoneNumbers() && Objects.equals(this.destinationPhoneNumbers(), other.destinationPhoneNumbers()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeVerifiedDestinationNumbersRequest").add("VerifiedDestinationNumberIds", this.hasVerifiedDestinationNumberIds() ? this.verifiedDestinationNumberIds() : null).add("DestinationPhoneNumbers", this.hasDestinationPhoneNumbers() ? this.destinationPhoneNumbers() : null).add("Filters", this.hasFilters() ? this.filters() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VerifiedDestinationNumberIds": {
                return Optional.ofNullable(clazz.cast(this.verifiedDestinationNumberIds()));
            }
            case "DestinationPhoneNumbers": {
                return Optional.ofNullable(clazz.cast(this.destinationPhoneNumbers()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VerifiedDestinationNumberIds", VERIFIED_DESTINATION_NUMBER_IDS_FIELD);
        map.put("DestinationPhoneNumbers", DESTINATION_PHONE_NUMBERS_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeVerifiedDestinationNumbersRequest, T> g) {
        return obj -> g.apply((DescribeVerifiedDestinationNumbersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Request.BuilderImpl
    implements Builder {
        private List<String> verifiedDestinationNumberIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> destinationPhoneNumbers = DefaultSdkAutoConstructList.getInstance();
        private List<VerifiedDestinationNumberFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVerifiedDestinationNumbersRequest model) {
            super(model);
            this.verifiedDestinationNumberIds(model.verifiedDestinationNumberIds);
            this.destinationPhoneNumbers(model.destinationPhoneNumbers);
            this.filters(model.filters);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Collection<String> getVerifiedDestinationNumberIds() {
            if (this.verifiedDestinationNumberIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.verifiedDestinationNumberIds;
        }

        public final void setVerifiedDestinationNumberIds(Collection<String> verifiedDestinationNumberIds) {
            this.verifiedDestinationNumberIds = VerifiedDestinationNumberIdListCopier.copy(verifiedDestinationNumberIds);
        }

        @Override
        public final Builder verifiedDestinationNumberIds(Collection<String> verifiedDestinationNumberIds) {
            this.verifiedDestinationNumberIds = VerifiedDestinationNumberIdListCopier.copy(verifiedDestinationNumberIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder verifiedDestinationNumberIds(String ... verifiedDestinationNumberIds) {
            this.verifiedDestinationNumberIds(Arrays.asList(verifiedDestinationNumberIds));
            return this;
        }

        public final Collection<String> getDestinationPhoneNumbers() {
            if (this.destinationPhoneNumbers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.destinationPhoneNumbers;
        }

        public final void setDestinationPhoneNumbers(Collection<String> destinationPhoneNumbers) {
            this.destinationPhoneNumbers = DestinationPhoneNumberListCopier.copy(destinationPhoneNumbers);
        }

        @Override
        public final Builder destinationPhoneNumbers(Collection<String> destinationPhoneNumbers) {
            this.destinationPhoneNumbers = DestinationPhoneNumberListCopier.copy(destinationPhoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationPhoneNumbers(String ... destinationPhoneNumbers) {
            this.destinationPhoneNumbers(Arrays.asList(destinationPhoneNumbers));
            return this;
        }

        public final List<VerifiedDestinationNumberFilter.Builder> getFilters() {
            List<VerifiedDestinationNumberFilter.Builder> result = VerifiedDestinationNumberFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<VerifiedDestinationNumberFilter.BuilderImpl> filters) {
            this.filters = VerifiedDestinationNumberFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<VerifiedDestinationNumberFilter> filters) {
            this.filters = VerifiedDestinationNumberFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(VerifiedDestinationNumberFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<VerifiedDestinationNumberFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (VerifiedDestinationNumberFilter)((VerifiedDestinationNumberFilter.Builder)VerifiedDestinationNumberFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeVerifiedDestinationNumbersRequest build() {
            return new DescribeVerifiedDestinationNumbersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVerifiedDestinationNumbersRequest> {
        public Builder verifiedDestinationNumberIds(Collection<String> var1);

        public Builder verifiedDestinationNumberIds(String ... var1);

        public Builder destinationPhoneNumbers(Collection<String> var1);

        public Builder destinationPhoneNumbers(String ... var1);

        public Builder filters(Collection<VerifiedDestinationNumberFilter> var1);

        public Builder filters(VerifiedDestinationNumberFilter ... var1);

        public Builder filters(Consumer<VerifiedDestinationNumberFilter.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

