/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.pinpointemail.PinpointEmailAsyncClient;
import software.amazon.awssdk.services.pinpointemail.PinpointEmailServiceClientConfiguration;
import software.amazon.awssdk.services.pinpointemail.internal.PinpointEmailServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.pinpointemail.model.AccountSuspendedException;
import software.amazon.awssdk.services.pinpointemail.model.AlreadyExistsException;
import software.amazon.awssdk.services.pinpointemail.model.BadRequestException;
import software.amazon.awssdk.services.pinpointemail.model.ConcurrentModificationException;
import software.amazon.awssdk.services.pinpointemail.model.CreateConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.pinpointemail.model.CreateConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.pinpointemail.model.CreateConfigurationSetRequest;
import software.amazon.awssdk.services.pinpointemail.model.CreateConfigurationSetResponse;
import software.amazon.awssdk.services.pinpointemail.model.CreateDedicatedIpPoolRequest;
import software.amazon.awssdk.services.pinpointemail.model.CreateDedicatedIpPoolResponse;
import software.amazon.awssdk.services.pinpointemail.model.CreateDeliverabilityTestReportRequest;
import software.amazon.awssdk.services.pinpointemail.model.CreateDeliverabilityTestReportResponse;
import software.amazon.awssdk.services.pinpointemail.model.CreateEmailIdentityRequest;
import software.amazon.awssdk.services.pinpointemail.model.CreateEmailIdentityResponse;
import software.amazon.awssdk.services.pinpointemail.model.DeleteConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.pinpointemail.model.DeleteConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.pinpointemail.model.DeleteConfigurationSetRequest;
import software.amazon.awssdk.services.pinpointemail.model.DeleteConfigurationSetResponse;
import software.amazon.awssdk.services.pinpointemail.model.DeleteDedicatedIpPoolRequest;
import software.amazon.awssdk.services.pinpointemail.model.DeleteDedicatedIpPoolResponse;
import software.amazon.awssdk.services.pinpointemail.model.DeleteEmailIdentityRequest;
import software.amazon.awssdk.services.pinpointemail.model.DeleteEmailIdentityResponse;
import software.amazon.awssdk.services.pinpointemail.model.GetAccountRequest;
import software.amazon.awssdk.services.pinpointemail.model.GetAccountResponse;
import software.amazon.awssdk.services.pinpointemail.model.GetBlacklistReportsRequest;
import software.amazon.awssdk.services.pinpointemail.model.GetBlacklistReportsResponse;
import software.amazon.awssdk.services.pinpointemail.model.GetConfigurationSetEventDestinationsRequest;
import software.amazon.awssdk.services.pinpointemail.model.GetConfigurationSetEventDestinationsResponse;
import software.amazon.awssdk.services.pinpointemail.model.GetConfigurationSetRequest;
import software.amazon.awssdk.services.pinpointemail.model.GetConfigurationSetResponse;
import software.amazon.awssdk.services.pinpointemail.model.GetDedicatedIpRequest;
import software.amazon.awssdk.services.pinpointemail.model.GetDedicatedIpResponse;
import software.amazon.awssdk.services.pinpointemail.model.GetDedicatedIpsRequest;
import software.amazon.awssdk.services.pinpointemail.model.GetDedicatedIpsResponse;
import software.amazon.awssdk.services.pinpointemail.model.GetDeliverabilityDashboardOptionsRequest;
import software.amazon.awssdk.services.pinpointemail.model.GetDeliverabilityDashboardOptionsResponse;
import software.amazon.awssdk.services.pinpointemail.model.GetDeliverabilityTestReportRequest;
import software.amazon.awssdk.services.pinpointemail.model.GetDeliverabilityTestReportResponse;
import software.amazon.awssdk.services.pinpointemail.model.GetDomainDeliverabilityCampaignRequest;
import software.amazon.awssdk.services.pinpointemail.model.GetDomainDeliverabilityCampaignResponse;
import software.amazon.awssdk.services.pinpointemail.model.GetDomainStatisticsReportRequest;
import software.amazon.awssdk.services.pinpointemail.model.GetDomainStatisticsReportResponse;
import software.amazon.awssdk.services.pinpointemail.model.GetEmailIdentityRequest;
import software.amazon.awssdk.services.pinpointemail.model.GetEmailIdentityResponse;
import software.amazon.awssdk.services.pinpointemail.model.LimitExceededException;
import software.amazon.awssdk.services.pinpointemail.model.ListConfigurationSetsRequest;
import software.amazon.awssdk.services.pinpointemail.model.ListConfigurationSetsResponse;
import software.amazon.awssdk.services.pinpointemail.model.ListDedicatedIpPoolsRequest;
import software.amazon.awssdk.services.pinpointemail.model.ListDedicatedIpPoolsResponse;
import software.amazon.awssdk.services.pinpointemail.model.ListDeliverabilityTestReportsRequest;
import software.amazon.awssdk.services.pinpointemail.model.ListDeliverabilityTestReportsResponse;
import software.amazon.awssdk.services.pinpointemail.model.ListDomainDeliverabilityCampaignsRequest;
import software.amazon.awssdk.services.pinpointemail.model.ListDomainDeliverabilityCampaignsResponse;
import software.amazon.awssdk.services.pinpointemail.model.ListEmailIdentitiesRequest;
import software.amazon.awssdk.services.pinpointemail.model.ListEmailIdentitiesResponse;
import software.amazon.awssdk.services.pinpointemail.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.pinpointemail.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.pinpointemail.model.MailFromDomainNotVerifiedException;
import software.amazon.awssdk.services.pinpointemail.model.MessageRejectedException;
import software.amazon.awssdk.services.pinpointemail.model.NotFoundException;
import software.amazon.awssdk.services.pinpointemail.model.PinpointEmailException;
import software.amazon.awssdk.services.pinpointemail.model.PutAccountDedicatedIpWarmupAttributesRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutAccountDedicatedIpWarmupAttributesResponse;
import software.amazon.awssdk.services.pinpointemail.model.PutAccountSendingAttributesRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutAccountSendingAttributesResponse;
import software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetDeliveryOptionsRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetDeliveryOptionsResponse;
import software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetReputationOptionsRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetReputationOptionsResponse;
import software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetSendingOptionsRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetSendingOptionsResponse;
import software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetTrackingOptionsRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetTrackingOptionsResponse;
import software.amazon.awssdk.services.pinpointemail.model.PutDedicatedIpInPoolRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutDedicatedIpInPoolResponse;
import software.amazon.awssdk.services.pinpointemail.model.PutDedicatedIpWarmupAttributesRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutDedicatedIpWarmupAttributesResponse;
import software.amazon.awssdk.services.pinpointemail.model.PutDeliverabilityDashboardOptionRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutDeliverabilityDashboardOptionResponse;
import software.amazon.awssdk.services.pinpointemail.model.PutEmailIdentityDkimAttributesRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutEmailIdentityDkimAttributesResponse;
import software.amazon.awssdk.services.pinpointemail.model.PutEmailIdentityFeedbackAttributesRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutEmailIdentityFeedbackAttributesResponse;
import software.amazon.awssdk.services.pinpointemail.model.PutEmailIdentityMailFromAttributesRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutEmailIdentityMailFromAttributesResponse;
import software.amazon.awssdk.services.pinpointemail.model.SendEmailRequest;
import software.amazon.awssdk.services.pinpointemail.model.SendEmailResponse;
import software.amazon.awssdk.services.pinpointemail.model.SendingPausedException;
import software.amazon.awssdk.services.pinpointemail.model.TagResourceRequest;
import software.amazon.awssdk.services.pinpointemail.model.TagResourceResponse;
import software.amazon.awssdk.services.pinpointemail.model.TooManyRequestsException;
import software.amazon.awssdk.services.pinpointemail.model.UntagResourceRequest;
import software.amazon.awssdk.services.pinpointemail.model.UntagResourceResponse;
import software.amazon.awssdk.services.pinpointemail.model.UpdateConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.pinpointemail.model.UpdateConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.pinpointemail.transform.CreateConfigurationSetEventDestinationRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.CreateConfigurationSetRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.CreateDedicatedIpPoolRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.CreateDeliverabilityTestReportRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.CreateEmailIdentityRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.DeleteConfigurationSetEventDestinationRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.DeleteConfigurationSetRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.DeleteDedicatedIpPoolRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.DeleteEmailIdentityRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.GetAccountRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.GetBlacklistReportsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.GetConfigurationSetEventDestinationsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.GetConfigurationSetRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.GetDedicatedIpRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.GetDedicatedIpsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.GetDeliverabilityDashboardOptionsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.GetDeliverabilityTestReportRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.GetDomainDeliverabilityCampaignRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.GetDomainStatisticsReportRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.GetEmailIdentityRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.ListConfigurationSetsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.ListDedicatedIpPoolsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.ListDeliverabilityTestReportsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.ListDomainDeliverabilityCampaignsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.ListEmailIdentitiesRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutAccountDedicatedIpWarmupAttributesRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutAccountSendingAttributesRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutConfigurationSetDeliveryOptionsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutConfigurationSetReputationOptionsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutConfigurationSetSendingOptionsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutConfigurationSetTrackingOptionsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutDedicatedIpInPoolRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutDedicatedIpWarmupAttributesRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutDeliverabilityDashboardOptionRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutEmailIdentityDkimAttributesRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutEmailIdentityFeedbackAttributesRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutEmailIdentityMailFromAttributesRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.SendEmailRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.UpdateConfigurationSetEventDestinationRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultPinpointEmailAsyncClient
implements PinpointEmailAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultPinpointEmailAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultPinpointEmailAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Pinpoint_Email#2.41.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<CreateConfigurationSetResponse> createConfigurationSet(CreateConfigurationSetRequest createConfigurationSetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createConfigurationSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, createConfigurationSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateConfigurationSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateConfigurationSetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConfigurationSet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateConfigurationSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createConfigurationSetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$createConfigurationSet$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$createConfigurationSet$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateConfigurationSetEventDestinationResponse> createConfigurationSetEventDestination(CreateConfigurationSetEventDestinationRequest createConfigurationSetEventDestinationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createConfigurationSetEventDestinationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, createConfigurationSetEventDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateConfigurationSetEventDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateConfigurationSetEventDestinationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConfigurationSetEventDestination").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateConfigurationSetEventDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createConfigurationSetEventDestinationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$createConfigurationSetEventDestination$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$createConfigurationSetEventDestination$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDedicatedIpPoolResponse> createDedicatedIpPool(CreateDedicatedIpPoolRequest createDedicatedIpPoolRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDedicatedIpPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, createDedicatedIpPoolRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDedicatedIpPool");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDedicatedIpPoolResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDedicatedIpPool").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateDedicatedIpPoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDedicatedIpPoolRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$createDedicatedIpPool$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$createDedicatedIpPool$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDeliverabilityTestReportResponse> createDeliverabilityTestReport(CreateDeliverabilityTestReportRequest createDeliverabilityTestReportRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDeliverabilityTestReportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, createDeliverabilityTestReportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDeliverabilityTestReport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDeliverabilityTestReportResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDeliverabilityTestReport").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateDeliverabilityTestReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDeliverabilityTestReportRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$createDeliverabilityTestReport$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$createDeliverabilityTestReport$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateEmailIdentityResponse> createEmailIdentity(CreateEmailIdentityRequest createEmailIdentityRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createEmailIdentityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, createEmailIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEmailIdentity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEmailIdentityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEmailIdentity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateEmailIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createEmailIdentityRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$createEmailIdentity$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$createEmailIdentity$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteConfigurationSetResponse> deleteConfigurationSet(DeleteConfigurationSetRequest deleteConfigurationSetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteConfigurationSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, deleteConfigurationSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConfigurationSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConfigurationSetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConfigurationSet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteConfigurationSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteConfigurationSetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$deleteConfigurationSet$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$deleteConfigurationSet$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteConfigurationSetEventDestinationResponse> deleteConfigurationSetEventDestination(DeleteConfigurationSetEventDestinationRequest deleteConfigurationSetEventDestinationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteConfigurationSetEventDestinationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, deleteConfigurationSetEventDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConfigurationSetEventDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConfigurationSetEventDestinationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConfigurationSetEventDestination").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteConfigurationSetEventDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteConfigurationSetEventDestinationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$deleteConfigurationSetEventDestination$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$deleteConfigurationSetEventDestination$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDedicatedIpPoolResponse> deleteDedicatedIpPool(DeleteDedicatedIpPoolRequest deleteDedicatedIpPoolRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDedicatedIpPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, deleteDedicatedIpPoolRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDedicatedIpPool");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDedicatedIpPoolResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDedicatedIpPool").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteDedicatedIpPoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDedicatedIpPoolRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$deleteDedicatedIpPool$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$deleteDedicatedIpPool$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteEmailIdentityResponse> deleteEmailIdentity(DeleteEmailIdentityRequest deleteEmailIdentityRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteEmailIdentityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, deleteEmailIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEmailIdentity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEmailIdentityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEmailIdentity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteEmailIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteEmailIdentityRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$deleteEmailIdentity$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$deleteEmailIdentity$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAccountResponse> getAccount(GetAccountRequest getAccountRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAccountRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, getAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAccountResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccount").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAccountRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$getAccount$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$getAccount$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBlacklistReportsResponse> getBlacklistReports(GetBlacklistReportsRequest getBlacklistReportsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBlacklistReportsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, getBlacklistReportsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBlacklistReports");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBlacklistReportsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBlacklistReports").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetBlacklistReportsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getBlacklistReportsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$getBlacklistReports$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$getBlacklistReports$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetConfigurationSetResponse> getConfigurationSet(GetConfigurationSetRequest getConfigurationSetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getConfigurationSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, getConfigurationSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetConfigurationSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetConfigurationSetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetConfigurationSet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetConfigurationSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getConfigurationSetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$getConfigurationSet$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$getConfigurationSet$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetConfigurationSetEventDestinationsResponse> getConfigurationSetEventDestinations(GetConfigurationSetEventDestinationsRequest getConfigurationSetEventDestinationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getConfigurationSetEventDestinationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, getConfigurationSetEventDestinationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetConfigurationSetEventDestinations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetConfigurationSetEventDestinationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetConfigurationSetEventDestinations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetConfigurationSetEventDestinationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getConfigurationSetEventDestinationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$getConfigurationSetEventDestinations$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$getConfigurationSetEventDestinations$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDedicatedIpResponse> getDedicatedIp(GetDedicatedIpRequest getDedicatedIpRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDedicatedIpRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, getDedicatedIpRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDedicatedIp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDedicatedIpResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDedicatedIp").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDedicatedIpRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDedicatedIpRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$getDedicatedIp$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$getDedicatedIp$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDedicatedIpsResponse> getDedicatedIps(GetDedicatedIpsRequest getDedicatedIpsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDedicatedIpsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, getDedicatedIpsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDedicatedIps");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDedicatedIpsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDedicatedIps").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDedicatedIpsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDedicatedIpsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$getDedicatedIps$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$getDedicatedIps$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDeliverabilityDashboardOptionsResponse> getDeliverabilityDashboardOptions(GetDeliverabilityDashboardOptionsRequest getDeliverabilityDashboardOptionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDeliverabilityDashboardOptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, getDeliverabilityDashboardOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDeliverabilityDashboardOptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDeliverabilityDashboardOptionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDeliverabilityDashboardOptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDeliverabilityDashboardOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDeliverabilityDashboardOptionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$getDeliverabilityDashboardOptions$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$getDeliverabilityDashboardOptions$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDeliverabilityTestReportResponse> getDeliverabilityTestReport(GetDeliverabilityTestReportRequest getDeliverabilityTestReportRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDeliverabilityTestReportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, getDeliverabilityTestReportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDeliverabilityTestReport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDeliverabilityTestReportResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDeliverabilityTestReport").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDeliverabilityTestReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDeliverabilityTestReportRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$getDeliverabilityTestReport$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$getDeliverabilityTestReport$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDomainDeliverabilityCampaignResponse> getDomainDeliverabilityCampaign(GetDomainDeliverabilityCampaignRequest getDomainDeliverabilityCampaignRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDomainDeliverabilityCampaignRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, getDomainDeliverabilityCampaignRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDomainDeliverabilityCampaign");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDomainDeliverabilityCampaignResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDomainDeliverabilityCampaign").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDomainDeliverabilityCampaignRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDomainDeliverabilityCampaignRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$getDomainDeliverabilityCampaign$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$getDomainDeliverabilityCampaign$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDomainStatisticsReportResponse> getDomainStatisticsReport(GetDomainStatisticsReportRequest getDomainStatisticsReportRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDomainStatisticsReportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, getDomainStatisticsReportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDomainStatisticsReport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDomainStatisticsReportResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDomainStatisticsReport").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDomainStatisticsReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDomainStatisticsReportRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$getDomainStatisticsReport$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$getDomainStatisticsReport$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetEmailIdentityResponse> getEmailIdentity(GetEmailIdentityRequest getEmailIdentityRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getEmailIdentityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, getEmailIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEmailIdentity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEmailIdentityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEmailIdentity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetEmailIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getEmailIdentityRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$getEmailIdentity$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$getEmailIdentity$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListConfigurationSetsResponse> listConfigurationSets(ListConfigurationSetsRequest listConfigurationSetsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listConfigurationSetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, listConfigurationSetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListConfigurationSets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListConfigurationSetsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListConfigurationSets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListConfigurationSetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listConfigurationSetsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$listConfigurationSets$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$listConfigurationSets$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDedicatedIpPoolsResponse> listDedicatedIpPools(ListDedicatedIpPoolsRequest listDedicatedIpPoolsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDedicatedIpPoolsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, listDedicatedIpPoolsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDedicatedIpPools");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDedicatedIpPoolsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDedicatedIpPools").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListDedicatedIpPoolsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDedicatedIpPoolsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$listDedicatedIpPools$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$listDedicatedIpPools$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDeliverabilityTestReportsResponse> listDeliverabilityTestReports(ListDeliverabilityTestReportsRequest listDeliverabilityTestReportsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDeliverabilityTestReportsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, listDeliverabilityTestReportsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDeliverabilityTestReports");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDeliverabilityTestReportsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDeliverabilityTestReports").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListDeliverabilityTestReportsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDeliverabilityTestReportsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$listDeliverabilityTestReports$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$listDeliverabilityTestReports$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDomainDeliverabilityCampaignsResponse> listDomainDeliverabilityCampaigns(ListDomainDeliverabilityCampaignsRequest listDomainDeliverabilityCampaignsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDomainDeliverabilityCampaignsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, listDomainDeliverabilityCampaignsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDomainDeliverabilityCampaigns");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDomainDeliverabilityCampaignsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDomainDeliverabilityCampaigns").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListDomainDeliverabilityCampaignsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDomainDeliverabilityCampaignsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$listDomainDeliverabilityCampaigns$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$listDomainDeliverabilityCampaigns$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListEmailIdentitiesResponse> listEmailIdentities(ListEmailIdentitiesRequest listEmailIdentitiesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listEmailIdentitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, listEmailIdentitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEmailIdentities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEmailIdentitiesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEmailIdentities").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListEmailIdentitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listEmailIdentitiesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$listEmailIdentities$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$listEmailIdentities$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$listTagsForResource$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$listTagsForResource$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutAccountDedicatedIpWarmupAttributesResponse> putAccountDedicatedIpWarmupAttributes(PutAccountDedicatedIpWarmupAttributesRequest putAccountDedicatedIpWarmupAttributesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putAccountDedicatedIpWarmupAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, putAccountDedicatedIpWarmupAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAccountDedicatedIpWarmupAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAccountDedicatedIpWarmupAttributesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccountDedicatedIpWarmupAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutAccountDedicatedIpWarmupAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putAccountDedicatedIpWarmupAttributesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$putAccountDedicatedIpWarmupAttributes$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$putAccountDedicatedIpWarmupAttributes$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutAccountSendingAttributesResponse> putAccountSendingAttributes(PutAccountSendingAttributesRequest putAccountSendingAttributesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putAccountSendingAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, putAccountSendingAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAccountSendingAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAccountSendingAttributesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccountSendingAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutAccountSendingAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putAccountSendingAttributesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$putAccountSendingAttributes$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$putAccountSendingAttributes$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutConfigurationSetDeliveryOptionsResponse> putConfigurationSetDeliveryOptions(PutConfigurationSetDeliveryOptionsRequest putConfigurationSetDeliveryOptionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putConfigurationSetDeliveryOptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, putConfigurationSetDeliveryOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutConfigurationSetDeliveryOptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutConfigurationSetDeliveryOptionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutConfigurationSetDeliveryOptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutConfigurationSetDeliveryOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putConfigurationSetDeliveryOptionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$putConfigurationSetDeliveryOptions$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$putConfigurationSetDeliveryOptions$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutConfigurationSetReputationOptionsResponse> putConfigurationSetReputationOptions(PutConfigurationSetReputationOptionsRequest putConfigurationSetReputationOptionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putConfigurationSetReputationOptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, putConfigurationSetReputationOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutConfigurationSetReputationOptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutConfigurationSetReputationOptionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutConfigurationSetReputationOptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutConfigurationSetReputationOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putConfigurationSetReputationOptionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$putConfigurationSetReputationOptions$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$putConfigurationSetReputationOptions$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutConfigurationSetSendingOptionsResponse> putConfigurationSetSendingOptions(PutConfigurationSetSendingOptionsRequest putConfigurationSetSendingOptionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putConfigurationSetSendingOptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, putConfigurationSetSendingOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutConfigurationSetSendingOptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutConfigurationSetSendingOptionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutConfigurationSetSendingOptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutConfigurationSetSendingOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putConfigurationSetSendingOptionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$putConfigurationSetSendingOptions$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$putConfigurationSetSendingOptions$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutConfigurationSetTrackingOptionsResponse> putConfigurationSetTrackingOptions(PutConfigurationSetTrackingOptionsRequest putConfigurationSetTrackingOptionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putConfigurationSetTrackingOptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, putConfigurationSetTrackingOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutConfigurationSetTrackingOptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutConfigurationSetTrackingOptionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutConfigurationSetTrackingOptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutConfigurationSetTrackingOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putConfigurationSetTrackingOptionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$putConfigurationSetTrackingOptions$126(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$putConfigurationSetTrackingOptions$127((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutDedicatedIpInPoolResponse> putDedicatedIpInPool(PutDedicatedIpInPoolRequest putDedicatedIpInPoolRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putDedicatedIpInPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, putDedicatedIpInPoolRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutDedicatedIpInPool");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDedicatedIpInPoolResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDedicatedIpInPool").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutDedicatedIpInPoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putDedicatedIpInPoolRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$putDedicatedIpInPool$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$putDedicatedIpInPool$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutDedicatedIpWarmupAttributesResponse> putDedicatedIpWarmupAttributes(PutDedicatedIpWarmupAttributesRequest putDedicatedIpWarmupAttributesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putDedicatedIpWarmupAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, putDedicatedIpWarmupAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutDedicatedIpWarmupAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDedicatedIpWarmupAttributesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDedicatedIpWarmupAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutDedicatedIpWarmupAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putDedicatedIpWarmupAttributesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$putDedicatedIpWarmupAttributes$134(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$putDedicatedIpWarmupAttributes$135((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutDeliverabilityDashboardOptionResponse> putDeliverabilityDashboardOption(PutDeliverabilityDashboardOptionRequest putDeliverabilityDashboardOptionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putDeliverabilityDashboardOptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, putDeliverabilityDashboardOptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutDeliverabilityDashboardOption");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDeliverabilityDashboardOptionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDeliverabilityDashboardOption").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutDeliverabilityDashboardOptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putDeliverabilityDashboardOptionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$putDeliverabilityDashboardOption$138(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$putDeliverabilityDashboardOption$139((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutEmailIdentityDkimAttributesResponse> putEmailIdentityDkimAttributes(PutEmailIdentityDkimAttributesRequest putEmailIdentityDkimAttributesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putEmailIdentityDkimAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, putEmailIdentityDkimAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutEmailIdentityDkimAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutEmailIdentityDkimAttributesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutEmailIdentityDkimAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutEmailIdentityDkimAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putEmailIdentityDkimAttributesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$putEmailIdentityDkimAttributes$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$putEmailIdentityDkimAttributes$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutEmailIdentityFeedbackAttributesResponse> putEmailIdentityFeedbackAttributes(PutEmailIdentityFeedbackAttributesRequest putEmailIdentityFeedbackAttributesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putEmailIdentityFeedbackAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, putEmailIdentityFeedbackAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutEmailIdentityFeedbackAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutEmailIdentityFeedbackAttributesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutEmailIdentityFeedbackAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutEmailIdentityFeedbackAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putEmailIdentityFeedbackAttributesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$putEmailIdentityFeedbackAttributes$146(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$putEmailIdentityFeedbackAttributes$147((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutEmailIdentityMailFromAttributesResponse> putEmailIdentityMailFromAttributes(PutEmailIdentityMailFromAttributesRequest putEmailIdentityMailFromAttributesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putEmailIdentityMailFromAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, putEmailIdentityMailFromAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutEmailIdentityMailFromAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutEmailIdentityMailFromAttributesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutEmailIdentityMailFromAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutEmailIdentityMailFromAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putEmailIdentityMailFromAttributesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$putEmailIdentityMailFromAttributes$150(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$putEmailIdentityMailFromAttributes$151((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SendEmailResponse> sendEmail(SendEmailRequest sendEmailRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)sendEmailRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, sendEmailRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendEmail");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendEmailResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendEmail").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SendEmailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)sendEmailRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$sendEmail$154(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$sendEmail$155((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$tagResource$158(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$tagResource$159((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$untagResource$162(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$untagResource$163((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateConfigurationSetEventDestinationResponse> updateConfigurationSetEventDestination(UpdateConfigurationSetEventDestinationRequest updateConfigurationSetEventDestinationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateConfigurationSetEventDestinationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointEmailAsyncClient.resolveMetricPublishers(clientConfiguration, updateConfigurationSetEventDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateConfigurationSetEventDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateConfigurationSetEventDestinationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MessageRejected": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "SendingPausedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AccountSuspendedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "MailFromDomainNotVerifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateConfigurationSetEventDestination").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateConfigurationSetEventDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateConfigurationSetEventDestinationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointEmailAsyncClient.lambda$updateConfigurationSetEventDestination$166(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointEmailAsyncClient.lambda$updateConfigurationSetEventDestination$167((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final PinpointEmailServiceClientConfiguration serviceClientConfiguration() {
        return new PinpointEmailServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "ses";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(PinpointEmailException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        PinpointEmailServiceClientConfigurationBuilder serviceConfigBuilder = new PinpointEmailServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateConfigurationSetEventDestination$167(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateConfigurationSetEventDestination$166(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateConfigurationSetEventDestinationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$163(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$162(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$159(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$158(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$sendEmail$155(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$sendEmail$154(List metricPublishers, MetricCollector apiCallMetricCollector, SendEmailResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putEmailIdentityMailFromAttributes$151(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putEmailIdentityMailFromAttributes$150(List metricPublishers, MetricCollector apiCallMetricCollector, PutEmailIdentityMailFromAttributesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putEmailIdentityFeedbackAttributes$147(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putEmailIdentityFeedbackAttributes$146(List metricPublishers, MetricCollector apiCallMetricCollector, PutEmailIdentityFeedbackAttributesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putEmailIdentityDkimAttributes$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putEmailIdentityDkimAttributes$142(List metricPublishers, MetricCollector apiCallMetricCollector, PutEmailIdentityDkimAttributesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putDeliverabilityDashboardOption$139(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putDeliverabilityDashboardOption$138(List metricPublishers, MetricCollector apiCallMetricCollector, PutDeliverabilityDashboardOptionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putDedicatedIpWarmupAttributes$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putDedicatedIpWarmupAttributes$134(List metricPublishers, MetricCollector apiCallMetricCollector, PutDedicatedIpWarmupAttributesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putDedicatedIpInPool$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putDedicatedIpInPool$130(List metricPublishers, MetricCollector apiCallMetricCollector, PutDedicatedIpInPoolResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putConfigurationSetTrackingOptions$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putConfigurationSetTrackingOptions$126(List metricPublishers, MetricCollector apiCallMetricCollector, PutConfigurationSetTrackingOptionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putConfigurationSetSendingOptions$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putConfigurationSetSendingOptions$122(List metricPublishers, MetricCollector apiCallMetricCollector, PutConfigurationSetSendingOptionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putConfigurationSetReputationOptions$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putConfigurationSetReputationOptions$118(List metricPublishers, MetricCollector apiCallMetricCollector, PutConfigurationSetReputationOptionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putConfigurationSetDeliveryOptions$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putConfigurationSetDeliveryOptions$114(List metricPublishers, MetricCollector apiCallMetricCollector, PutConfigurationSetDeliveryOptionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putAccountSendingAttributes$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAccountSendingAttributes$110(List metricPublishers, MetricCollector apiCallMetricCollector, PutAccountSendingAttributesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putAccountDedicatedIpWarmupAttributes$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAccountDedicatedIpWarmupAttributes$106(List metricPublishers, MetricCollector apiCallMetricCollector, PutAccountDedicatedIpWarmupAttributesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$102(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listEmailIdentities$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEmailIdentities$98(List metricPublishers, MetricCollector apiCallMetricCollector, ListEmailIdentitiesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listDomainDeliverabilityCampaigns$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDomainDeliverabilityCampaigns$94(List metricPublishers, MetricCollector apiCallMetricCollector, ListDomainDeliverabilityCampaignsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listDeliverabilityTestReports$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDeliverabilityTestReports$90(List metricPublishers, MetricCollector apiCallMetricCollector, ListDeliverabilityTestReportsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listDedicatedIpPools$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDedicatedIpPools$86(List metricPublishers, MetricCollector apiCallMetricCollector, ListDedicatedIpPoolsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listConfigurationSets$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listConfigurationSets$82(List metricPublishers, MetricCollector apiCallMetricCollector, ListConfigurationSetsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getEmailIdentity$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEmailIdentity$78(List metricPublishers, MetricCollector apiCallMetricCollector, GetEmailIdentityResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDomainStatisticsReport$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDomainStatisticsReport$74(List metricPublishers, MetricCollector apiCallMetricCollector, GetDomainStatisticsReportResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDomainDeliverabilityCampaign$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDomainDeliverabilityCampaign$70(List metricPublishers, MetricCollector apiCallMetricCollector, GetDomainDeliverabilityCampaignResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDeliverabilityTestReport$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDeliverabilityTestReport$66(List metricPublishers, MetricCollector apiCallMetricCollector, GetDeliverabilityTestReportResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDeliverabilityDashboardOptions$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDeliverabilityDashboardOptions$62(List metricPublishers, MetricCollector apiCallMetricCollector, GetDeliverabilityDashboardOptionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDedicatedIps$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDedicatedIps$58(List metricPublishers, MetricCollector apiCallMetricCollector, GetDedicatedIpsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDedicatedIp$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDedicatedIp$54(List metricPublishers, MetricCollector apiCallMetricCollector, GetDedicatedIpResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getConfigurationSetEventDestinations$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getConfigurationSetEventDestinations$50(List metricPublishers, MetricCollector apiCallMetricCollector, GetConfigurationSetEventDestinationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getConfigurationSet$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getConfigurationSet$46(List metricPublishers, MetricCollector apiCallMetricCollector, GetConfigurationSetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getBlacklistReports$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBlacklistReports$42(List metricPublishers, MetricCollector apiCallMetricCollector, GetBlacklistReportsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAccount$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccount$38(List metricPublishers, MetricCollector apiCallMetricCollector, GetAccountResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteEmailIdentity$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEmailIdentity$34(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteEmailIdentityResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteDedicatedIpPool$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDedicatedIpPool$30(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteDedicatedIpPoolResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteConfigurationSetEventDestination$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteConfigurationSetEventDestination$26(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteConfigurationSetEventDestinationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteConfigurationSet$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteConfigurationSet$22(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteConfigurationSetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createEmailIdentity$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createEmailIdentity$18(List metricPublishers, MetricCollector apiCallMetricCollector, CreateEmailIdentityResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createDeliverabilityTestReport$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDeliverabilityTestReport$14(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDeliverabilityTestReportResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createDedicatedIpPool$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDedicatedIpPool$10(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDedicatedIpPoolResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createConfigurationSetEventDestination$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createConfigurationSetEventDestination$6(List metricPublishers, MetricCollector apiCallMetricCollector, CreateConfigurationSetEventDestinationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createConfigurationSet$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createConfigurationSet$2(List metricPublishers, MetricCollector apiCallMetricCollector, CreateConfigurationSetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

