/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpointemail.model.BlacklistEntry;
import software.amazon.awssdk.services.pinpointemail.model.BlacklistReportCopier;
import software.amazon.awssdk.services.pinpointemail.model.PinpointEmailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBlacklistReportsResponse
extends PinpointEmailResponse
implements ToCopyableBuilder<Builder, GetBlacklistReportsResponse> {
    private static final SdkField<Map<String, List<BlacklistEntry>>> BLACKLIST_REPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("BlacklistReport").getter(GetBlacklistReportsResponse.getter(GetBlacklistReportsResponse::blacklistReport)).setter(GetBlacklistReportsResponse.setter(Builder::blacklistReport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlacklistReport").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BlacklistEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLACKLIST_REPORT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetBlacklistReportsResponse.memberNameToFieldInitializer();
    private final Map<String, List<BlacklistEntry>> blacklistReport;

    private GetBlacklistReportsResponse(BuilderImpl builder) {
        super(builder);
        this.blacklistReport = builder.blacklistReport;
    }

    public final boolean hasBlacklistReport() {
        return this.blacklistReport != null && !(this.blacklistReport instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<BlacklistEntry>> blacklistReport() {
        return this.blacklistReport;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlacklistReport() ? this.blacklistReport() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBlacklistReportsResponse)) {
            return false;
        }
        GetBlacklistReportsResponse other = (GetBlacklistReportsResponse)((Object)obj);
        return this.hasBlacklistReport() == other.hasBlacklistReport() && Objects.equals(this.blacklistReport(), other.blacklistReport());
    }

    public final String toString() {
        return ToString.builder((String)"GetBlacklistReportsResponse").add("BlacklistReport", this.hasBlacklistReport() ? this.blacklistReport() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlacklistReport": {
                return Optional.ofNullable(clazz.cast(this.blacklistReport()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Map<String, List<BlacklistEntry>>>> map = new HashMap<String, SdkField<Map<String, List<BlacklistEntry>>>>();
        map.put("BlacklistReport", BLACKLIST_REPORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBlacklistReportsResponse, T> g) {
        return obj -> g.apply((GetBlacklistReportsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointEmailResponse.BuilderImpl
    implements Builder {
        private Map<String, List<BlacklistEntry>> blacklistReport = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetBlacklistReportsResponse model) {
            super(model);
            this.blacklistReport(model.blacklistReport);
        }

        public final Map<String, List<BlacklistEntry.Builder>> getBlacklistReport() {
            Map<String, List<BlacklistEntry.Builder>> result = BlacklistReportCopier.copyToBuilder(this.blacklistReport);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setBlacklistReport(Map<String, ? extends Collection<BlacklistEntry.BuilderImpl>> blacklistReport) {
            this.blacklistReport = BlacklistReportCopier.copyFromBuilder(blacklistReport);
        }

        @Override
        public final Builder blacklistReport(Map<String, ? extends Collection<BlacklistEntry>> blacklistReport) {
            this.blacklistReport = BlacklistReportCopier.copy(blacklistReport);
            return this;
        }

        @Override
        public GetBlacklistReportsResponse build() {
            return new GetBlacklistReportsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PinpointEmailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBlacklistReportsResponse> {
        public Builder blacklistReport(Map<String, ? extends Collection<BlacklistEntry>> var1);
    }
}

