/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpointemail.model.DeliverabilityTestStatus;
import software.amazon.awssdk.services.pinpointemail.model.PinpointEmailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDeliverabilityTestReportResponse
extends PinpointEmailResponse
implements ToCopyableBuilder<Builder, CreateDeliverabilityTestReportResponse> {
    private static final SdkField<String> REPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReportId").getter(CreateDeliverabilityTestReportResponse.getter(CreateDeliverabilityTestReportResponse::reportId)).setter(CreateDeliverabilityTestReportResponse.setter(Builder::reportId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportId").build()}).build();
    private static final SdkField<String> DELIVERABILITY_TEST_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeliverabilityTestStatus").getter(CreateDeliverabilityTestReportResponse.getter(CreateDeliverabilityTestReportResponse::deliverabilityTestStatusAsString)).setter(CreateDeliverabilityTestReportResponse.setter(Builder::deliverabilityTestStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliverabilityTestStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_ID_FIELD, DELIVERABILITY_TEST_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDeliverabilityTestReportResponse.memberNameToFieldInitializer();
    private final String reportId;
    private final String deliverabilityTestStatus;

    private CreateDeliverabilityTestReportResponse(BuilderImpl builder) {
        super(builder);
        this.reportId = builder.reportId;
        this.deliverabilityTestStatus = builder.deliverabilityTestStatus;
    }

    public final String reportId() {
        return this.reportId;
    }

    public final DeliverabilityTestStatus deliverabilityTestStatus() {
        return DeliverabilityTestStatus.fromValue(this.deliverabilityTestStatus);
    }

    public final String deliverabilityTestStatusAsString() {
        return this.deliverabilityTestStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.reportId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliverabilityTestStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeliverabilityTestReportResponse)) {
            return false;
        }
        CreateDeliverabilityTestReportResponse other = (CreateDeliverabilityTestReportResponse)((Object)obj);
        return Objects.equals(this.reportId(), other.reportId()) && Objects.equals(this.deliverabilityTestStatusAsString(), other.deliverabilityTestStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDeliverabilityTestReportResponse").add("ReportId", (Object)this.reportId()).add("DeliverabilityTestStatus", (Object)this.deliverabilityTestStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReportId": {
                return Optional.ofNullable(clazz.cast(this.reportId()));
            }
            case "DeliverabilityTestStatus": {
                return Optional.ofNullable(clazz.cast(this.deliverabilityTestStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ReportId", REPORT_ID_FIELD);
        map.put("DeliverabilityTestStatus", DELIVERABILITY_TEST_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDeliverabilityTestReportResponse, T> g) {
        return obj -> g.apply((CreateDeliverabilityTestReportResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointEmailResponse.BuilderImpl
    implements Builder {
        private String reportId;
        private String deliverabilityTestStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeliverabilityTestReportResponse model) {
            super(model);
            this.reportId(model.reportId);
            this.deliverabilityTestStatus(model.deliverabilityTestStatus);
        }

        public final String getReportId() {
            return this.reportId;
        }

        public final void setReportId(String reportId) {
            this.reportId = reportId;
        }

        @Override
        public final Builder reportId(String reportId) {
            this.reportId = reportId;
            return this;
        }

        public final String getDeliverabilityTestStatus() {
            return this.deliverabilityTestStatus;
        }

        public final void setDeliverabilityTestStatus(String deliverabilityTestStatus) {
            this.deliverabilityTestStatus = deliverabilityTestStatus;
        }

        @Override
        public final Builder deliverabilityTestStatus(String deliverabilityTestStatus) {
            this.deliverabilityTestStatus = deliverabilityTestStatus;
            return this;
        }

        @Override
        public final Builder deliverabilityTestStatus(DeliverabilityTestStatus deliverabilityTestStatus) {
            this.deliverabilityTestStatus(deliverabilityTestStatus == null ? null : deliverabilityTestStatus.toString());
            return this;
        }

        @Override
        public CreateDeliverabilityTestReportResponse build() {
            return new CreateDeliverabilityTestReportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PinpointEmailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDeliverabilityTestReportResponse> {
        public Builder reportId(String var1);

        public Builder deliverabilityTestStatus(String var1);

        public Builder deliverabilityTestStatus(DeliverabilityTestStatus var1);
    }
}

