/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.EndpointMessageResult;
import software.amazon.awssdk.services.pinpoint.model.MapOfEndpointMessageResultCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOfMessageResultCopier;
import software.amazon.awssdk.services.pinpoint.model.MessageResult;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MessageResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MessageResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(MessageResponse.getter(MessageResponse::applicationId)).setter(MessageResponse.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<Map<String, EndpointMessageResult>> ENDPOINT_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("EndpointResult").getter(MessageResponse.getter(MessageResponse::endpointResult)).setter(MessageResponse.setter(Builder::endpointResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointResult").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EndpointMessageResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(MessageResponse.getter(MessageResponse::requestId)).setter(MessageResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Map<String, MessageResult>> RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Result").getter(MessageResponse.getter(MessageResponse::result)).setter(MessageResponse.setter(Builder::result)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Result").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, ENDPOINT_RESULT_FIELD, REQUEST_ID_FIELD, RESULT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MessageResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String applicationId;
    private final Map<String, EndpointMessageResult> endpointResult;
    private final String requestId;
    private final Map<String, MessageResult> result;

    private MessageResponse(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.endpointResult = builder.endpointResult;
        this.requestId = builder.requestId;
        this.result = builder.result;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final boolean hasEndpointResult() {
        return this.endpointResult != null && !(this.endpointResult instanceof SdkAutoConstructMap);
    }

    public final Map<String, EndpointMessageResult> endpointResult() {
        return this.endpointResult;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final boolean hasResult() {
        return this.result != null && !(this.result instanceof SdkAutoConstructMap);
    }

    public final Map<String, MessageResult> result() {
        return this.result;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpointResult() ? this.endpointResult() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResult() ? this.result() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageResponse)) {
            return false;
        }
        MessageResponse other = (MessageResponse)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && this.hasEndpointResult() == other.hasEndpointResult() && Objects.equals(this.endpointResult(), other.endpointResult()) && Objects.equals(this.requestId(), other.requestId()) && this.hasResult() == other.hasResult() && Objects.equals(this.result(), other.result());
    }

    public final String toString() {
        return ToString.builder((String)"MessageResponse").add("ApplicationId", (Object)this.applicationId()).add("EndpointResult", this.hasEndpointResult() ? this.endpointResult() : null).add("RequestId", (Object)this.requestId()).add("Result", this.hasResult() ? this.result() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "EndpointResult": {
                return Optional.ofNullable(clazz.cast(this.endpointResult()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Result": {
                return Optional.ofNullable(clazz.cast(this.result()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationId", APPLICATION_ID_FIELD);
        map.put("EndpointResult", ENDPOINT_RESULT_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("Result", RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MessageResponse, T> g) {
        return obj -> g.apply((MessageResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private Map<String, EndpointMessageResult> endpointResult = DefaultSdkAutoConstructMap.getInstance();
        private String requestId;
        private Map<String, MessageResult> result = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MessageResponse model) {
            this.applicationId(model.applicationId);
            this.endpointResult(model.endpointResult);
            this.requestId(model.requestId);
            this.result(model.result);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Map<String, EndpointMessageResult.Builder> getEndpointResult() {
            Map<String, EndpointMessageResult.Builder> result = MapOfEndpointMessageResultCopier.copyToBuilder(this.endpointResult);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setEndpointResult(Map<String, EndpointMessageResult.BuilderImpl> endpointResult) {
            this.endpointResult = MapOfEndpointMessageResultCopier.copyFromBuilder(endpointResult);
        }

        @Override
        public final Builder endpointResult(Map<String, EndpointMessageResult> endpointResult) {
            this.endpointResult = MapOfEndpointMessageResultCopier.copy(endpointResult);
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Map<String, MessageResult.Builder> getResult() {
            Map<String, MessageResult.Builder> result = MapOfMessageResultCopier.copyToBuilder(this.result);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setResult(Map<String, MessageResult.BuilderImpl> result) {
            this.result = MapOfMessageResultCopier.copyFromBuilder(result);
        }

        @Override
        public final Builder result(Map<String, MessageResult> result) {
            this.result = MapOfMessageResultCopier.copy(result);
            return this;
        }

        public MessageResponse build() {
            return new MessageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MessageResponse> {
        public Builder applicationId(String var1);

        public Builder endpointResult(Map<String, EndpointMessageResult> var1);

        public Builder requestId(String var1);

        public Builder result(Map<String, MessageResult> var1);
    }
}

