/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpoint.model.ActivityResponse;
import software.amazon.awssdk.services.pinpoint.model.ListOfActivityResponseCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActivitiesResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActivitiesResponse> {
    private static final SdkField<List<ActivityResponse>> ITEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Item").getter(ActivitiesResponse.getter(ActivitiesResponse::item)).setter(ActivitiesResponse.setter(Builder::item)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActivityResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ActivitiesResponse.getter(ActivitiesResponse::nextToken)).setter(ActivitiesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_FIELD, NEXT_TOKEN_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ActivityResponse> item;
    private final String nextToken;

    private ActivitiesResponse(BuilderImpl builder) {
        this.item = builder.item;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasItem() {
        return this.item != null && !(this.item instanceof SdkAutoConstructList);
    }

    public final List<ActivityResponse> item() {
        return this.item;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItem() ? this.item() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivitiesResponse)) {
            return false;
        }
        ActivitiesResponse other = (ActivitiesResponse)obj;
        return this.hasItem() == other.hasItem() && Objects.equals(this.item(), other.item()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ActivitiesResponse").add("Item", this.hasItem() ? this.item() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Item": {
                return Optional.ofNullable(clazz.cast(this.item()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActivitiesResponse, T> g) {
        return obj -> g.apply((ActivitiesResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ActivityResponse> item = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivitiesResponse model) {
            this.item(model.item);
            this.nextToken(model.nextToken);
        }

        public final List<ActivityResponse.Builder> getItem() {
            List<ActivityResponse.Builder> result = ListOfActivityResponseCopier.copyToBuilder(this.item);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItem(Collection<ActivityResponse.BuilderImpl> item) {
            this.item = ListOfActivityResponseCopier.copyFromBuilder(item);
        }

        @Override
        @Transient
        public final Builder item(Collection<ActivityResponse> item) {
            this.item = ListOfActivityResponseCopier.copy(item);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder item(ActivityResponse ... item) {
            this.item(Arrays.asList(item));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder item(Consumer<ActivityResponse.Builder> ... item) {
            this.item(Stream.of(item).map(c -> (ActivityResponse)((ActivityResponse.Builder)ActivityResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public ActivitiesResponse build() {
            return new ActivitiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActivitiesResponse> {
        public Builder item(Collection<ActivityResponse> var1);

        public Builder item(ActivityResponse ... var1);

        public Builder item(Consumer<ActivityResponse.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

