/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Override button configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OverrideButtonConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<OverrideButtonConfiguration.Builder, OverrideButtonConfiguration> {
    private static final SdkField<String> BUTTON_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ButtonAction").getter(getter(OverrideButtonConfiguration::buttonActionAsString))
            .setter(setter(Builder::buttonAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ButtonAction").build()).build();

    private static final SdkField<String> LINK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Link")
            .getter(getter(OverrideButtonConfiguration::link)).setter(setter(Builder::link))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Link").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUTTON_ACTION_FIELD,
            LINK_FIELD));

    private static final long serialVersionUID = 1L;

    private final String buttonAction;

    private final String link;

    private OverrideButtonConfiguration(BuilderImpl builder) {
        this.buttonAction = builder.buttonAction;
        this.link = builder.link;
    }

    /**
     * <p>
     * Action triggered by the button.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #buttonAction} will
     * return {@link ButtonAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #buttonActionAsString}.
     * </p>
     * 
     * @return Action triggered by the button.
     * @see ButtonAction
     */
    public final ButtonAction buttonAction() {
        return ButtonAction.fromValue(buttonAction);
    }

    /**
     * <p>
     * Action triggered by the button.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #buttonAction} will
     * return {@link ButtonAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #buttonActionAsString}.
     * </p>
     * 
     * @return Action triggered by the button.
     * @see ButtonAction
     */
    public final String buttonActionAsString() {
        return buttonAction;
    }

    /**
     * <p>
     * Button destination.
     * </p>
     * 
     * @return Button destination.
     */
    public final String link() {
        return link;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(buttonActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(link());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OverrideButtonConfiguration)) {
            return false;
        }
        OverrideButtonConfiguration other = (OverrideButtonConfiguration) obj;
        return Objects.equals(buttonActionAsString(), other.buttonActionAsString()) && Objects.equals(link(), other.link());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OverrideButtonConfiguration").add("ButtonAction", buttonActionAsString()).add("Link", link())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ButtonAction":
            return Optional.ofNullable(clazz.cast(buttonActionAsString()));
        case "Link":
            return Optional.ofNullable(clazz.cast(link()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OverrideButtonConfiguration, T> g) {
        return obj -> g.apply((OverrideButtonConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OverrideButtonConfiguration> {
        /**
         * <p>
         * Action triggered by the button.
         * </p>
         * 
         * @param buttonAction
         *        Action triggered by the button.
         * @see ButtonAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ButtonAction
         */
        Builder buttonAction(String buttonAction);

        /**
         * <p>
         * Action triggered by the button.
         * </p>
         * 
         * @param buttonAction
         *        Action triggered by the button.
         * @see ButtonAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ButtonAction
         */
        Builder buttonAction(ButtonAction buttonAction);

        /**
         * <p>
         * Button destination.
         * </p>
         * 
         * @param link
         *        Button destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder link(String link);
    }

    static final class BuilderImpl implements Builder {
        private String buttonAction;

        private String link;

        private BuilderImpl() {
        }

        private BuilderImpl(OverrideButtonConfiguration model) {
            buttonAction(model.buttonAction);
            link(model.link);
        }

        public final String getButtonAction() {
            return buttonAction;
        }

        public final void setButtonAction(String buttonAction) {
            this.buttonAction = buttonAction;
        }

        @Override
        @Transient
        public final Builder buttonAction(String buttonAction) {
            this.buttonAction = buttonAction;
            return this;
        }

        @Override
        @Transient
        public final Builder buttonAction(ButtonAction buttonAction) {
            this.buttonAction(buttonAction == null ? null : buttonAction.toString());
            return this;
        }

        public final String getLink() {
            return link;
        }

        public final void setLink(String link) {
            this.link = link;
        }

        @Override
        @Transient
        public final Builder link(String link) {
            this.link = link;
            return this;
        }

        @Override
        public OverrideButtonConfiguration build() {
            return new OverrideButtonConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
