/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the results of a query that retrieved the data for a standard execution metric that applies to a journey
 * activity, and provides information about that query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JourneyExecutionActivityMetricsResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<JourneyExecutionActivityMetricsResponse.Builder, JourneyExecutionActivityMetricsResponse> {
    private static final SdkField<String> ACTIVITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActivityType").getter(getter(JourneyExecutionActivityMetricsResponse::activityType))
            .setter(setter(Builder::activityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivityType").build()).build();

    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(JourneyExecutionActivityMetricsResponse::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<String> JOURNEY_ACTIVITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JourneyActivityId").getter(getter(JourneyExecutionActivityMetricsResponse::journeyActivityId))
            .setter(setter(Builder::journeyActivityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JourneyActivityId").build()).build();

    private static final SdkField<String> JOURNEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JourneyId").getter(getter(JourneyExecutionActivityMetricsResponse::journeyId))
            .setter(setter(Builder::journeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JourneyId").build()).build();

    private static final SdkField<String> LAST_EVALUATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastEvaluatedTime").getter(getter(JourneyExecutionActivityMetricsResponse::lastEvaluatedTime))
            .setter(setter(Builder::lastEvaluatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastEvaluatedTime").build()).build();

    private static final SdkField<Map<String, String>> METRICS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Metrics")
            .getter(getter(JourneyExecutionActivityMetricsResponse::metrics))
            .setter(setter(Builder::metrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_TYPE_FIELD,
            APPLICATION_ID_FIELD, JOURNEY_ACTIVITY_ID_FIELD, JOURNEY_ID_FIELD, LAST_EVALUATED_TIME_FIELD, METRICS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String activityType;

    private final String applicationId;

    private final String journeyActivityId;

    private final String journeyId;

    private final String lastEvaluatedTime;

    private final Map<String, String> metrics;

    private JourneyExecutionActivityMetricsResponse(BuilderImpl builder) {
        this.activityType = builder.activityType;
        this.applicationId = builder.applicationId;
        this.journeyActivityId = builder.journeyActivityId;
        this.journeyId = builder.journeyId;
        this.lastEvaluatedTime = builder.lastEvaluatedTime;
        this.metrics = builder.metrics;
    }

    /**
     * <p>
     * The type of activity that the metric applies to. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CONDITIONAL_SPLIT - For a yes/no split activity, which is an activity that sends participants down one of two
     * paths in a journey.
     * </p>
     * </li>
     * <li>
     * <p>
     * HOLDOUT - For a holdout activity, which is an activity that stops a journey for a specified percentage of
     * participants.
     * </p>
     * </li>
     * <li>
     * <p>
     * MESSAGE - For an email activity, which is an activity that sends an email message to participants.
     * </p>
     * </li>
     * <li>
     * <p>
     * MULTI_CONDITIONAL_SPLIT - For a multivariate split activity, which is an activity that sends participants down
     * one of as many as five paths in a journey.
     * </p>
     * </li>
     * <li>
     * <p>
     * RANDOM_SPLIT - For a random split activity, which is an activity that sends specified percentages of participants
     * down one of as many as five paths in a journey.
     * </p>
     * </li>
     * <li>
     * <p>
     * WAIT - For a wait activity, which is an activity that waits for a certain amount of time or until a specific date
     * and time before moving participants to the next activity in a journey.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The type of activity that the metric applies to. Possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         CONDITIONAL_SPLIT - For a yes/no split activity, which is an activity that sends participants down one of
     *         two paths in a journey.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HOLDOUT - For a holdout activity, which is an activity that stops a journey for a specified percentage of
     *         participants.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MESSAGE - For an email activity, which is an activity that sends an email message to participants.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MULTI_CONDITIONAL_SPLIT - For a multivariate split activity, which is an activity that sends participants
     *         down one of as many as five paths in a journey.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RANDOM_SPLIT - For a random split activity, which is an activity that sends specified percentages of
     *         participants down one of as many as five paths in a journey.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WAIT - For a wait activity, which is an activity that waits for a certain amount of time or until a
     *         specific date and time before moving participants to the next activity in a journey.
     *         </p>
     *         </li>
     */
    public final String activityType() {
        return activityType;
    }

    /**
     * <p>
     * The unique identifier for the application that the metric applies to.
     * </p>
     * 
     * @return The unique identifier for the application that the metric applies to.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The unique identifier for the activity that the metric applies to.
     * </p>
     * 
     * @return The unique identifier for the activity that the metric applies to.
     */
    public final String journeyActivityId() {
        return journeyActivityId;
    }

    /**
     * <p>
     * The unique identifier for the journey that the metric applies to.
     * </p>
     * 
     * @return The unique identifier for the journey that the metric applies to.
     */
    public final String journeyId() {
        return journeyId;
    }

    /**
     * <p>
     * The date and time, in ISO 8601 format, when Amazon Pinpoint last evaluated the execution status of the activity
     * and updated the data for the metric.
     * </p>
     * 
     * @return The date and time, in ISO 8601 format, when Amazon Pinpoint last evaluated the execution status of the
     *         activity and updated the data for the metric.
     */
    public final String lastEvaluatedTime() {
        return lastEvaluatedTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metrics property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetrics() {
        return metrics != null && !(metrics instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A JSON object that contains the results of the query. The results vary depending on the type of activity
     * (ActivityType). For information about the structure and contents of the results, see the <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon Pinpoint
     * Developer Guide</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetrics} method.
     * </p>
     * 
     * @return A JSON object that contains the results of the query. The results vary depending on the type of activity
     *         (ActivityType). For information about the structure and contents of the results, see the <a
     *         href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon
     *         Pinpoint Developer Guide</a>.
     */
    public final Map<String, String> metrics() {
        return metrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activityType());
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(journeyActivityId());
        hashCode = 31 * hashCode + Objects.hashCode(journeyId());
        hashCode = 31 * hashCode + Objects.hashCode(lastEvaluatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetrics() ? metrics() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JourneyExecutionActivityMetricsResponse)) {
            return false;
        }
        JourneyExecutionActivityMetricsResponse other = (JourneyExecutionActivityMetricsResponse) obj;
        return Objects.equals(activityType(), other.activityType()) && Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(journeyActivityId(), other.journeyActivityId())
                && Objects.equals(journeyId(), other.journeyId())
                && Objects.equals(lastEvaluatedTime(), other.lastEvaluatedTime()) && hasMetrics() == other.hasMetrics()
                && Objects.equals(metrics(), other.metrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JourneyExecutionActivityMetricsResponse").add("ActivityType", activityType())
                .add("ApplicationId", applicationId()).add("JourneyActivityId", journeyActivityId())
                .add("JourneyId", journeyId()).add("LastEvaluatedTime", lastEvaluatedTime())
                .add("Metrics", hasMetrics() ? metrics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActivityType":
            return Optional.ofNullable(clazz.cast(activityType()));
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "JourneyActivityId":
            return Optional.ofNullable(clazz.cast(journeyActivityId()));
        case "JourneyId":
            return Optional.ofNullable(clazz.cast(journeyId()));
        case "LastEvaluatedTime":
            return Optional.ofNullable(clazz.cast(lastEvaluatedTime()));
        case "Metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JourneyExecutionActivityMetricsResponse, T> g) {
        return obj -> g.apply((JourneyExecutionActivityMetricsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JourneyExecutionActivityMetricsResponse> {
        /**
         * <p>
         * The type of activity that the metric applies to. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CONDITIONAL_SPLIT - For a yes/no split activity, which is an activity that sends participants down one of two
         * paths in a journey.
         * </p>
         * </li>
         * <li>
         * <p>
         * HOLDOUT - For a holdout activity, which is an activity that stops a journey for a specified percentage of
         * participants.
         * </p>
         * </li>
         * <li>
         * <p>
         * MESSAGE - For an email activity, which is an activity that sends an email message to participants.
         * </p>
         * </li>
         * <li>
         * <p>
         * MULTI_CONDITIONAL_SPLIT - For a multivariate split activity, which is an activity that sends participants
         * down one of as many as five paths in a journey.
         * </p>
         * </li>
         * <li>
         * <p>
         * RANDOM_SPLIT - For a random split activity, which is an activity that sends specified percentages of
         * participants down one of as many as five paths in a journey.
         * </p>
         * </li>
         * <li>
         * <p>
         * WAIT - For a wait activity, which is an activity that waits for a certain amount of time or until a specific
         * date and time before moving participants to the next activity in a journey.
         * </p>
         * </li>
         * </ul>
         * 
         * @param activityType
         *        The type of activity that the metric applies to. Possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        CONDITIONAL_SPLIT - For a yes/no split activity, which is an activity that sends participants down one
         *        of two paths in a journey.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        HOLDOUT - For a holdout activity, which is an activity that stops a journey for a specified percentage
         *        of participants.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MESSAGE - For an email activity, which is an activity that sends an email message to participants.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MULTI_CONDITIONAL_SPLIT - For a multivariate split activity, which is an activity that sends
         *        participants down one of as many as five paths in a journey.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RANDOM_SPLIT - For a random split activity, which is an activity that sends specified percentages of
         *        participants down one of as many as five paths in a journey.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WAIT - For a wait activity, which is an activity that waits for a certain amount of time or until a
         *        specific date and time before moving participants to the next activity in a journey.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityType(String activityType);

        /**
         * <p>
         * The unique identifier for the application that the metric applies to.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier for the application that the metric applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The unique identifier for the activity that the metric applies to.
         * </p>
         * 
         * @param journeyActivityId
         *        The unique identifier for the activity that the metric applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder journeyActivityId(String journeyActivityId);

        /**
         * <p>
         * The unique identifier for the journey that the metric applies to.
         * </p>
         * 
         * @param journeyId
         *        The unique identifier for the journey that the metric applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder journeyId(String journeyId);

        /**
         * <p>
         * The date and time, in ISO 8601 format, when Amazon Pinpoint last evaluated the execution status of the
         * activity and updated the data for the metric.
         * </p>
         * 
         * @param lastEvaluatedTime
         *        The date and time, in ISO 8601 format, when Amazon Pinpoint last evaluated the execution status of the
         *        activity and updated the data for the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastEvaluatedTime(String lastEvaluatedTime);

        /**
         * <p>
         * A JSON object that contains the results of the query. The results vary depending on the type of activity
         * (ActivityType). For information about the structure and contents of the results, see the <a
         * href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon
         * Pinpoint Developer Guide</a>.
         * </p>
         * 
         * @param metrics
         *        A JSON object that contains the results of the query. The results vary depending on the type of
         *        activity (ActivityType). For information about the structure and contents of the results, see the <a
         *        href
         *        ="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon
         *        Pinpoint Developer Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Map<String, String> metrics);
    }

    static final class BuilderImpl implements Builder {
        private String activityType;

        private String applicationId;

        private String journeyActivityId;

        private String journeyId;

        private String lastEvaluatedTime;

        private Map<String, String> metrics = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JourneyExecutionActivityMetricsResponse model) {
            activityType(model.activityType);
            applicationId(model.applicationId);
            journeyActivityId(model.journeyActivityId);
            journeyId(model.journeyId);
            lastEvaluatedTime(model.lastEvaluatedTime);
            metrics(model.metrics);
        }

        public final String getActivityType() {
            return activityType;
        }

        public final void setActivityType(String activityType) {
            this.activityType = activityType;
        }

        @Override
        @Transient
        public final Builder activityType(String activityType) {
            this.activityType = activityType;
            return this;
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        @Transient
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getJourneyActivityId() {
            return journeyActivityId;
        }

        public final void setJourneyActivityId(String journeyActivityId) {
            this.journeyActivityId = journeyActivityId;
        }

        @Override
        @Transient
        public final Builder journeyActivityId(String journeyActivityId) {
            this.journeyActivityId = journeyActivityId;
            return this;
        }

        public final String getJourneyId() {
            return journeyId;
        }

        public final void setJourneyId(String journeyId) {
            this.journeyId = journeyId;
        }

        @Override
        @Transient
        public final Builder journeyId(String journeyId) {
            this.journeyId = journeyId;
            return this;
        }

        public final String getLastEvaluatedTime() {
            return lastEvaluatedTime;
        }

        public final void setLastEvaluatedTime(String lastEvaluatedTime) {
            this.lastEvaluatedTime = lastEvaluatedTime;
        }

        @Override
        @Transient
        public final Builder lastEvaluatedTime(String lastEvaluatedTime) {
            this.lastEvaluatedTime = lastEvaluatedTime;
            return this;
        }

        public final Map<String, String> getMetrics() {
            if (metrics instanceof SdkAutoConstructMap) {
                return null;
            }
            return metrics;
        }

        public final void setMetrics(Map<String, String> metrics) {
            this.metrics = MapOf__stringCopier.copy(metrics);
        }

        @Override
        @Transient
        public final Builder metrics(Map<String, String> metrics) {
            this.metrics = MapOf__stringCopier.copy(metrics);
            return this;
        }

        @Override
        public JourneyExecutionActivityMetricsResponse build() {
            return new JourneyExecutionActivityMetricsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
