/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The channel-specific configurations for the journey.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JourneyChannelSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<JourneyChannelSettings.Builder, JourneyChannelSettings> {
    private static final SdkField<String> CONNECT_CAMPAIGN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectCampaignArn").getter(getter(JourneyChannelSettings::connectCampaignArn))
            .setter(setter(Builder::connectCampaignArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectCampaignArn").build())
            .build();

    private static final SdkField<String> CONNECT_CAMPAIGN_EXECUTION_ROLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConnectCampaignExecutionRoleArn")
            .getter(getter(JourneyChannelSettings::connectCampaignExecutionRoleArn))
            .setter(setter(Builder::connectCampaignExecutionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectCampaignExecutionRoleArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECT_CAMPAIGN_ARN_FIELD,
            CONNECT_CAMPAIGN_EXECUTION_ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String connectCampaignArn;

    private final String connectCampaignExecutionRoleArn;

    private JourneyChannelSettings(BuilderImpl builder) {
        this.connectCampaignArn = builder.connectCampaignArn;
        this.connectCampaignExecutionRoleArn = builder.connectCampaignExecutionRoleArn;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the Connect Campaign.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the Connect Campaign.
     */
    public final String connectCampaignArn() {
        return connectCampaignArn;
    }

    /**
     * <p>
     * IAM role ARN to be assumed when invoking Connect campaign execution APIs for dialing.
     * </p>
     * 
     * @return IAM role ARN to be assumed when invoking Connect campaign execution APIs for dialing.
     */
    public final String connectCampaignExecutionRoleArn() {
        return connectCampaignExecutionRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectCampaignArn());
        hashCode = 31 * hashCode + Objects.hashCode(connectCampaignExecutionRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JourneyChannelSettings)) {
            return false;
        }
        JourneyChannelSettings other = (JourneyChannelSettings) obj;
        return Objects.equals(connectCampaignArn(), other.connectCampaignArn())
                && Objects.equals(connectCampaignExecutionRoleArn(), other.connectCampaignExecutionRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JourneyChannelSettings").add("ConnectCampaignArn", connectCampaignArn())
                .add("ConnectCampaignExecutionRoleArn", connectCampaignExecutionRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectCampaignArn":
            return Optional.ofNullable(clazz.cast(connectCampaignArn()));
        case "ConnectCampaignExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(connectCampaignExecutionRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JourneyChannelSettings, T> g) {
        return obj -> g.apply((JourneyChannelSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JourneyChannelSettings> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the Connect Campaign.
         * </p>
         * 
         * @param connectCampaignArn
         *        Amazon Resource Name (ARN) of the Connect Campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectCampaignArn(String connectCampaignArn);

        /**
         * <p>
         * IAM role ARN to be assumed when invoking Connect campaign execution APIs for dialing.
         * </p>
         * 
         * @param connectCampaignExecutionRoleArn
         *        IAM role ARN to be assumed when invoking Connect campaign execution APIs for dialing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectCampaignExecutionRoleArn(String connectCampaignExecutionRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String connectCampaignArn;

        private String connectCampaignExecutionRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(JourneyChannelSettings model) {
            connectCampaignArn(model.connectCampaignArn);
            connectCampaignExecutionRoleArn(model.connectCampaignExecutionRoleArn);
        }

        public final String getConnectCampaignArn() {
            return connectCampaignArn;
        }

        public final void setConnectCampaignArn(String connectCampaignArn) {
            this.connectCampaignArn = connectCampaignArn;
        }

        @Override
        @Transient
        public final Builder connectCampaignArn(String connectCampaignArn) {
            this.connectCampaignArn = connectCampaignArn;
            return this;
        }

        public final String getConnectCampaignExecutionRoleArn() {
            return connectCampaignExecutionRoleArn;
        }

        public final void setConnectCampaignExecutionRoleArn(String connectCampaignExecutionRoleArn) {
            this.connectCampaignExecutionRoleArn = connectCampaignExecutionRoleArn;
        }

        @Override
        @Transient
        public final Builder connectCampaignExecutionRoleArn(String connectCampaignExecutionRoleArn) {
            this.connectCampaignExecutionRoleArn = connectCampaignExecutionRoleArn;
            return this;
        }

        @Override
        public JourneyChannelSettings build() {
            return new JourneyChannelSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
