/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.GPSPointDimension;
import software.amazon.awssdk.services.pinpoint.model.SetDimension;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SegmentLocation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SegmentLocation> {
    private static final SdkField<SetDimension> COUNTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Country").getter(SegmentLocation.getter(SegmentLocation::country)).setter(SegmentLocation.setter(Builder::country)).constructor(SetDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()}).build();
    private static final SdkField<GPSPointDimension> GPS_POINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GPSPoint").getter(SegmentLocation.getter(SegmentLocation::gpsPoint)).setter(SegmentLocation.setter(Builder::gpsPoint)).constructor(GPSPointDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GPSPoint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTRY_FIELD, GPS_POINT_FIELD));
    private static final long serialVersionUID = 1L;
    private final SetDimension country;
    private final GPSPointDimension gpsPoint;

    private SegmentLocation(BuilderImpl builder) {
        this.country = builder.country;
        this.gpsPoint = builder.gpsPoint;
    }

    public final SetDimension country() {
        return this.country;
    }

    public final GPSPointDimension gpsPoint() {
        return this.gpsPoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.country());
        hashCode = 31 * hashCode + Objects.hashCode(this.gpsPoint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentLocation)) {
            return false;
        }
        SegmentLocation other = (SegmentLocation)obj;
        return Objects.equals(this.country(), other.country()) && Objects.equals(this.gpsPoint(), other.gpsPoint());
    }

    public final String toString() {
        return ToString.builder((String)"SegmentLocation").add("Country", (Object)this.country()).add("GPSPoint", (Object)this.gpsPoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Country": {
                return Optional.ofNullable(clazz.cast(this.country()));
            }
            case "GPSPoint": {
                return Optional.ofNullable(clazz.cast(this.gpsPoint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SegmentLocation, T> g) {
        return obj -> g.apply((SegmentLocation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SetDimension country;
        private GPSPointDimension gpsPoint;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentLocation model) {
            this.country(model.country);
            this.gpsPoint(model.gpsPoint);
        }

        public final SetDimension.Builder getCountry() {
            return this.country != null ? this.country.toBuilder() : null;
        }

        @Override
        public final Builder country(SetDimension country) {
            this.country = country;
            return this;
        }

        public final void setCountry(SetDimension.BuilderImpl country) {
            this.country = country != null ? country.build() : null;
        }

        public final GPSPointDimension.Builder getGpsPoint() {
            return this.gpsPoint != null ? this.gpsPoint.toBuilder() : null;
        }

        @Override
        public final Builder gpsPoint(GPSPointDimension gpsPoint) {
            this.gpsPoint = gpsPoint;
            return this;
        }

        public final void setGpsPoint(GPSPointDimension.BuilderImpl gpsPoint) {
            this.gpsPoint = gpsPoint != null ? gpsPoint.build() : null;
        }

        public SegmentLocation build() {
            return new SegmentLocation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SegmentLocation> {
        public Builder country(SetDimension var1);

        default public Builder country(Consumer<SetDimension.Builder> country) {
            return this.country((SetDimension)((SetDimension.Builder)SetDimension.builder().applyMutation(country)).build());
        }

        public Builder gpsPoint(GPSPointDimension var1);

        default public Builder gpsPoint(Consumer<GPSPointDimension.Builder> gpsPoint) {
            return this.gpsPoint((GPSPointDimension)((GPSPointDimension.Builder)GPSPointDimension.builder().applyMutation(gpsPoint)).build());
        }
    }
}

