/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.JourneyPushMessage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PushMessageActivity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PushMessageActivity> {
    private static final SdkField<JourneyPushMessage> MESSAGE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MessageConfig").getter(PushMessageActivity.getter(PushMessageActivity::messageConfig)).setter(PushMessageActivity.setter(Builder::messageConfig)).constructor(JourneyPushMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageConfig").build()}).build();
    private static final SdkField<String> NEXT_ACTIVITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextActivity").getter(PushMessageActivity.getter(PushMessageActivity::nextActivity)).setter(PushMessageActivity.setter(Builder::nextActivity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextActivity").build()}).build();
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateName").getter(PushMessageActivity.getter(PushMessageActivity::templateName)).setter(PushMessageActivity.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()}).build();
    private static final SdkField<String> TEMPLATE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateVersion").getter(PushMessageActivity.getter(PushMessageActivity::templateVersion)).setter(PushMessageActivity.setter(Builder::templateVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_CONFIG_FIELD, NEXT_ACTIVITY_FIELD, TEMPLATE_NAME_FIELD, TEMPLATE_VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final JourneyPushMessage messageConfig;
    private final String nextActivity;
    private final String templateName;
    private final String templateVersion;

    private PushMessageActivity(BuilderImpl builder) {
        this.messageConfig = builder.messageConfig;
        this.nextActivity = builder.nextActivity;
        this.templateName = builder.templateName;
        this.templateVersion = builder.templateVersion;
    }

    public final JourneyPushMessage messageConfig() {
        return this.messageConfig;
    }

    public final String nextActivity() {
        return this.nextActivity;
    }

    public final String templateName() {
        return this.templateName;
    }

    public final String templateVersion() {
        return this.templateVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.messageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextActivity());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PushMessageActivity)) {
            return false;
        }
        PushMessageActivity other = (PushMessageActivity)obj;
        return Objects.equals(this.messageConfig(), other.messageConfig()) && Objects.equals(this.nextActivity(), other.nextActivity()) && Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.templateVersion(), other.templateVersion());
    }

    public final String toString() {
        return ToString.builder((String)"PushMessageActivity").add("MessageConfig", (Object)this.messageConfig()).add("NextActivity", (Object)this.nextActivity()).add("TemplateName", (Object)this.templateName()).add("TemplateVersion", (Object)this.templateVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MessageConfig": {
                return Optional.ofNullable(clazz.cast(this.messageConfig()));
            }
            case "NextActivity": {
                return Optional.ofNullable(clazz.cast(this.nextActivity()));
            }
            case "TemplateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "TemplateVersion": {
                return Optional.ofNullable(clazz.cast(this.templateVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PushMessageActivity, T> g) {
        return obj -> g.apply((PushMessageActivity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private JourneyPushMessage messageConfig;
        private String nextActivity;
        private String templateName;
        private String templateVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(PushMessageActivity model) {
            this.messageConfig(model.messageConfig);
            this.nextActivity(model.nextActivity);
            this.templateName(model.templateName);
            this.templateVersion(model.templateVersion);
        }

        public final JourneyPushMessage.Builder getMessageConfig() {
            return this.messageConfig != null ? this.messageConfig.toBuilder() : null;
        }

        @Override
        public final Builder messageConfig(JourneyPushMessage messageConfig) {
            this.messageConfig = messageConfig;
            return this;
        }

        public final void setMessageConfig(JourneyPushMessage.BuilderImpl messageConfig) {
            this.messageConfig = messageConfig != null ? messageConfig.build() : null;
        }

        public final String getNextActivity() {
            return this.nextActivity;
        }

        @Override
        public final Builder nextActivity(String nextActivity) {
            this.nextActivity = nextActivity;
            return this;
        }

        public final void setNextActivity(String nextActivity) {
            this.nextActivity = nextActivity;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getTemplateVersion() {
            return this.templateVersion;
        }

        @Override
        public final Builder templateVersion(String templateVersion) {
            this.templateVersion = templateVersion;
            return this;
        }

        public final void setTemplateVersion(String templateVersion) {
            this.templateVersion = templateVersion;
        }

        public PushMessageActivity build() {
            return new PushMessageActivity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PushMessageActivity> {
        public Builder messageConfig(JourneyPushMessage var1);

        default public Builder messageConfig(Consumer<JourneyPushMessage.Builder> messageConfig) {
            return this.messageConfig((JourneyPushMessage)((JourneyPushMessage.Builder)JourneyPushMessage.builder().applyMutation(messageConfig)).build());
        }

        public Builder nextActivity(String var1);

        public Builder templateName(String var1);

        public Builder templateVersion(String var1);
    }
}

