/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pi.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pi.PiClient;
import software.amazon.awssdk.services.pi.internal.UserAgentUtils;
import software.amazon.awssdk.services.pi.model.DescribeDimensionKeysRequest;
import software.amazon.awssdk.services.pi.model.DescribeDimensionKeysResponse;

public class DescribeDimensionKeysIterable
implements SdkIterable<DescribeDimensionKeysResponse> {
    private final PiClient client;
    private final DescribeDimensionKeysRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDimensionKeysIterable(PiClient client, DescribeDimensionKeysRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeDimensionKeysResponseFetcher();
    }

    public Iterator<DescribeDimensionKeysResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeDimensionKeysResponseFetcher
    implements SyncPageFetcher<DescribeDimensionKeysResponse> {
        private DescribeDimensionKeysResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDimensionKeysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeDimensionKeysResponse nextPage(DescribeDimensionKeysResponse previousPage) {
            if (previousPage == null) {
                return DescribeDimensionKeysIterable.this.client.describeDimensionKeys(DescribeDimensionKeysIterable.this.firstRequest);
            }
            return DescribeDimensionKeysIterable.this.client.describeDimensionKeys((DescribeDimensionKeysRequest)((Object)DescribeDimensionKeysIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

