/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalizeevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Action
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Action> {
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionId").getter(Action.getter(Action::actionId)).setter(Action.setter(Builder::actionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionId").build()}).build();
    private static final SdkField<String> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("properties").getter(Action.getter(Action::properties)).setter(Action.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(), JsonValueTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_ID_FIELD, PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Action.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String actionId;
    private final String properties;

    private Action(BuilderImpl builder) {
        this.actionId = builder.actionId;
        this.properties = builder.properties;
    }

    public final String actionId() {
        return this.actionId;
    }

    public final String properties() {
        return this.properties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.properties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action)obj;
        return Objects.equals(this.actionId(), other.actionId()) && Objects.equals(this.properties(), other.properties());
    }

    public final String toString() {
        return ToString.builder((String)"Action").add("ActionId", (Object)this.actionId()).add("Properties", (Object)(this.properties() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionId": {
                return Optional.ofNullable(clazz.cast(this.actionId()));
            }
            case "properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("actionId", ACTION_ID_FIELD);
        map.put("properties", PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Action, T> g) {
        return obj -> g.apply((Action)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionId;
        private String properties;

        private BuilderImpl() {
        }

        private BuilderImpl(Action model) {
            this.actionId(model.actionId);
            this.properties(model.properties);
        }

        public final String getActionId() {
            return this.actionId;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final String getProperties() {
            return this.properties;
        }

        public final void setProperties(String properties) {
            this.properties = properties;
        }

        @Override
        public final Builder properties(String properties) {
            this.properties = properties;
            return this;
        }

        public Action build() {
            return new Action(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Action> {
        public Builder actionId(String var1);

        public Builder properties(String var1);
    }
}

