/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorscep.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pcaconnectorscep.model.IntuneConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MobileDeviceManagement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MobileDeviceManagement> {
    private static final SdkField<IntuneConfiguration> INTUNE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Intune").getter(MobileDeviceManagement.getter(MobileDeviceManagement::intune)).setter(MobileDeviceManagement.setter(Builder::intune)).constructor(IntuneConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Intune").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTUNE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MobileDeviceManagement.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final IntuneConfiguration intune;
    private final Type type;

    private MobileDeviceManagement(BuilderImpl builder) {
        this.intune = builder.intune;
        this.type = builder.type;
    }

    public final IntuneConfiguration intune() {
        return this.intune;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.intune());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MobileDeviceManagement)) {
            return false;
        }
        MobileDeviceManagement other = (MobileDeviceManagement)obj;
        return Objects.equals(this.intune(), other.intune());
    }

    public final String toString() {
        return ToString.builder((String)"MobileDeviceManagement").add("Intune", (Object)this.intune()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Intune": {
                return Optional.ofNullable(clazz.cast(this.intune()));
            }
        }
        return Optional.empty();
    }

    public static MobileDeviceManagement fromIntune(IntuneConfiguration intune) {
        return (MobileDeviceManagement)MobileDeviceManagement.builder().intune(intune).build();
    }

    public static MobileDeviceManagement fromIntune(Consumer<IntuneConfiguration.Builder> intune) {
        IntuneConfiguration.Builder builder = IntuneConfiguration.builder();
        intune.accept(builder);
        return MobileDeviceManagement.fromIntune((IntuneConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<IntuneConfiguration>> map = new HashMap<String, SdkField<IntuneConfiguration>>();
        map.put("Intune", INTUNE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MobileDeviceManagement, T> g) {
        return obj -> g.apply((MobileDeviceManagement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        INTUNE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private IntuneConfiguration intune;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(MobileDeviceManagement model) {
            this.intune(model.intune);
        }

        public final IntuneConfiguration.Builder getIntune() {
            return this.intune != null ? this.intune.toBuilder() : null;
        }

        public final void setIntune(IntuneConfiguration.BuilderImpl intune) {
            IntuneConfiguration oldValue = this.intune;
            this.intune = intune != null ? intune.build() : null;
            this.handleUnionValueChange(Type.INTUNE, oldValue, this.intune);
        }

        @Override
        public final Builder intune(IntuneConfiguration intune) {
            IntuneConfiguration oldValue = this.intune;
            this.intune = intune;
            this.handleUnionValueChange(Type.INTUNE, oldValue, this.intune);
            return this;
        }

        public MobileDeviceManagement build() {
            return new MobileDeviceManagement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MobileDeviceManagement> {
        public Builder intune(IntuneConfiguration var1);

        default public Builder intune(Consumer<IntuneConfiguration.Builder> intune) {
            return this.intune((IntuneConfiguration)((IntuneConfiguration.Builder)IntuneConfiguration.builder().applyMutation(intune)).build());
        }
    }
}

