/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorscep.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConnectorStatusReason {
    INTERNAL_FAILURE("INTERNAL_FAILURE"),
    PRIVATECA_ACCESS_DENIED("PRIVATECA_ACCESS_DENIED"),
    PRIVATECA_INVALID_STATE("PRIVATECA_INVALID_STATE"),
    PRIVATECA_RESOURCE_NOT_FOUND("PRIVATECA_RESOURCE_NOT_FOUND"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConnectorStatusReason> VALUE_MAP;
    private final String value;

    private ConnectorStatusReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConnectorStatusReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConnectorStatusReason> knownValues() {
        EnumSet<ConnectorStatusReason> knownValues = EnumSet.allOf(ConnectorStatusReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConnectorStatusReason.class, ConnectorStatusReason::toString);
    }
}

