/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KeyUsageFlags
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KeyUsageFlags> {
    private static final SdkField<Boolean> DATA_ENCIPHERMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DataEncipherment").getter(KeyUsageFlags.getter(KeyUsageFlags::dataEncipherment)).setter(KeyUsageFlags.setter(Builder::dataEncipherment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataEncipherment").build()}).build();
    private static final SdkField<Boolean> DIGITAL_SIGNATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DigitalSignature").getter(KeyUsageFlags.getter(KeyUsageFlags::digitalSignature)).setter(KeyUsageFlags.setter(Builder::digitalSignature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DigitalSignature").build()}).build();
    private static final SdkField<Boolean> KEY_AGREEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("KeyAgreement").getter(KeyUsageFlags.getter(KeyUsageFlags::keyAgreement)).setter(KeyUsageFlags.setter(Builder::keyAgreement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAgreement").build()}).build();
    private static final SdkField<Boolean> KEY_ENCIPHERMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("KeyEncipherment").getter(KeyUsageFlags.getter(KeyUsageFlags::keyEncipherment)).setter(KeyUsageFlags.setter(Builder::keyEncipherment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyEncipherment").build()}).build();
    private static final SdkField<Boolean> NON_REPUDIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("NonRepudiation").getter(KeyUsageFlags.getter(KeyUsageFlags::nonRepudiation)).setter(KeyUsageFlags.setter(Builder::nonRepudiation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonRepudiation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_ENCIPHERMENT_FIELD, DIGITAL_SIGNATURE_FIELD, KEY_AGREEMENT_FIELD, KEY_ENCIPHERMENT_FIELD, NON_REPUDIATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KeyUsageFlags.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean dataEncipherment;
    private final Boolean digitalSignature;
    private final Boolean keyAgreement;
    private final Boolean keyEncipherment;
    private final Boolean nonRepudiation;

    private KeyUsageFlags(BuilderImpl builder) {
        this.dataEncipherment = builder.dataEncipherment;
        this.digitalSignature = builder.digitalSignature;
        this.keyAgreement = builder.keyAgreement;
        this.keyEncipherment = builder.keyEncipherment;
        this.nonRepudiation = builder.nonRepudiation;
    }

    public final Boolean dataEncipherment() {
        return this.dataEncipherment;
    }

    public final Boolean digitalSignature() {
        return this.digitalSignature;
    }

    public final Boolean keyAgreement() {
        return this.keyAgreement;
    }

    public final Boolean keyEncipherment() {
        return this.keyEncipherment;
    }

    public final Boolean nonRepudiation() {
        return this.nonRepudiation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataEncipherment());
        hashCode = 31 * hashCode + Objects.hashCode(this.digitalSignature());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyAgreement());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyEncipherment());
        hashCode = 31 * hashCode + Objects.hashCode(this.nonRepudiation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyUsageFlags)) {
            return false;
        }
        KeyUsageFlags other = (KeyUsageFlags)obj;
        return Objects.equals(this.dataEncipherment(), other.dataEncipherment()) && Objects.equals(this.digitalSignature(), other.digitalSignature()) && Objects.equals(this.keyAgreement(), other.keyAgreement()) && Objects.equals(this.keyEncipherment(), other.keyEncipherment()) && Objects.equals(this.nonRepudiation(), other.nonRepudiation());
    }

    public final String toString() {
        return ToString.builder((String)"KeyUsageFlags").add("DataEncipherment", (Object)this.dataEncipherment()).add("DigitalSignature", (Object)this.digitalSignature()).add("KeyAgreement", (Object)this.keyAgreement()).add("KeyEncipherment", (Object)this.keyEncipherment()).add("NonRepudiation", (Object)this.nonRepudiation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataEncipherment": {
                return Optional.ofNullable(clazz.cast(this.dataEncipherment()));
            }
            case "DigitalSignature": {
                return Optional.ofNullable(clazz.cast(this.digitalSignature()));
            }
            case "KeyAgreement": {
                return Optional.ofNullable(clazz.cast(this.keyAgreement()));
            }
            case "KeyEncipherment": {
                return Optional.ofNullable(clazz.cast(this.keyEncipherment()));
            }
            case "NonRepudiation": {
                return Optional.ofNullable(clazz.cast(this.nonRepudiation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Boolean>> map = new HashMap<String, SdkField<Boolean>>();
        map.put("DataEncipherment", DATA_ENCIPHERMENT_FIELD);
        map.put("DigitalSignature", DIGITAL_SIGNATURE_FIELD);
        map.put("KeyAgreement", KEY_AGREEMENT_FIELD);
        map.put("KeyEncipherment", KEY_ENCIPHERMENT_FIELD);
        map.put("NonRepudiation", NON_REPUDIATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KeyUsageFlags, T> g) {
        return obj -> g.apply((KeyUsageFlags)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean dataEncipherment;
        private Boolean digitalSignature;
        private Boolean keyAgreement;
        private Boolean keyEncipherment;
        private Boolean nonRepudiation;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyUsageFlags model) {
            this.dataEncipherment(model.dataEncipherment);
            this.digitalSignature(model.digitalSignature);
            this.keyAgreement(model.keyAgreement);
            this.keyEncipherment(model.keyEncipherment);
            this.nonRepudiation(model.nonRepudiation);
        }

        public final Boolean getDataEncipherment() {
            return this.dataEncipherment;
        }

        public final void setDataEncipherment(Boolean dataEncipherment) {
            this.dataEncipherment = dataEncipherment;
        }

        @Override
        public final Builder dataEncipherment(Boolean dataEncipherment) {
            this.dataEncipherment = dataEncipherment;
            return this;
        }

        public final Boolean getDigitalSignature() {
            return this.digitalSignature;
        }

        public final void setDigitalSignature(Boolean digitalSignature) {
            this.digitalSignature = digitalSignature;
        }

        @Override
        public final Builder digitalSignature(Boolean digitalSignature) {
            this.digitalSignature = digitalSignature;
            return this;
        }

        public final Boolean getKeyAgreement() {
            return this.keyAgreement;
        }

        public final void setKeyAgreement(Boolean keyAgreement) {
            this.keyAgreement = keyAgreement;
        }

        @Override
        public final Builder keyAgreement(Boolean keyAgreement) {
            this.keyAgreement = keyAgreement;
            return this;
        }

        public final Boolean getKeyEncipherment() {
            return this.keyEncipherment;
        }

        public final void setKeyEncipherment(Boolean keyEncipherment) {
            this.keyEncipherment = keyEncipherment;
        }

        @Override
        public final Builder keyEncipherment(Boolean keyEncipherment) {
            this.keyEncipherment = keyEncipherment;
            return this;
        }

        public final Boolean getNonRepudiation() {
            return this.nonRepudiation;
        }

        public final void setNonRepudiation(Boolean nonRepudiation) {
            this.nonRepudiation = nonRepudiation;
        }

        @Override
        public final Builder nonRepudiation(Boolean nonRepudiation) {
            this.nonRepudiation = nonRepudiation;
            return this;
        }

        public KeyUsageFlags build() {
            return new KeyUsageFlags(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KeyUsageFlags> {
        public Builder dataEncipherment(Boolean var1);

        public Builder digitalSignature(Boolean var1);

        public Builder keyAgreement(Boolean var1);

        public Builder keyEncipherment(Boolean var1);

        public Builder nonRepudiation(Boolean var1);
    }
}

