/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pcaconnectorad.model.AccessRights;
import software.amazon.awssdk.services.pcaconnectorad.model.PcaConnectorAdRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTemplateGroupAccessControlEntryRequest
extends PcaConnectorAdRequest
implements ToCopyableBuilder<Builder, CreateTemplateGroupAccessControlEntryRequest> {
    private static final SdkField<AccessRights> ACCESS_RIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccessRights").getter(CreateTemplateGroupAccessControlEntryRequest.getter(CreateTemplateGroupAccessControlEntryRequest::accessRights)).setter(CreateTemplateGroupAccessControlEntryRequest.setter(Builder::accessRights)).constructor(AccessRights::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessRights").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateTemplateGroupAccessControlEntryRequest.getter(CreateTemplateGroupAccessControlEntryRequest::clientToken)).setter(CreateTemplateGroupAccessControlEntryRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> GROUP_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupDisplayName").getter(CreateTemplateGroupAccessControlEntryRequest.getter(CreateTemplateGroupAccessControlEntryRequest::groupDisplayName)).setter(CreateTemplateGroupAccessControlEntryRequest.setter(Builder::groupDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupDisplayName").build()}).build();
    private static final SdkField<String> GROUP_SECURITY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupSecurityIdentifier").getter(CreateTemplateGroupAccessControlEntryRequest.getter(CreateTemplateGroupAccessControlEntryRequest::groupSecurityIdentifier)).setter(CreateTemplateGroupAccessControlEntryRequest.setter(Builder::groupSecurityIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupSecurityIdentifier").build()}).build();
    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateArn").getter(CreateTemplateGroupAccessControlEntryRequest.getter(CreateTemplateGroupAccessControlEntryRequest::templateArn)).setter(CreateTemplateGroupAccessControlEntryRequest.setter(Builder::templateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("TemplateArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_RIGHTS_FIELD, CLIENT_TOKEN_FIELD, GROUP_DISPLAY_NAME_FIELD, GROUP_SECURITY_IDENTIFIER_FIELD, TEMPLATE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateTemplateGroupAccessControlEntryRequest.memberNameToFieldInitializer();
    private final AccessRights accessRights;
    private final String clientToken;
    private final String groupDisplayName;
    private final String groupSecurityIdentifier;
    private final String templateArn;

    private CreateTemplateGroupAccessControlEntryRequest(BuilderImpl builder) {
        super(builder);
        this.accessRights = builder.accessRights;
        this.clientToken = builder.clientToken;
        this.groupDisplayName = builder.groupDisplayName;
        this.groupSecurityIdentifier = builder.groupSecurityIdentifier;
        this.templateArn = builder.templateArn;
    }

    public final AccessRights accessRights() {
        return this.accessRights;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String groupDisplayName() {
        return this.groupDisplayName;
    }

    public final String groupSecurityIdentifier() {
        return this.groupSecurityIdentifier;
    }

    public final String templateArn() {
        return this.templateArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accessRights());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupSecurityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTemplateGroupAccessControlEntryRequest)) {
            return false;
        }
        CreateTemplateGroupAccessControlEntryRequest other = (CreateTemplateGroupAccessControlEntryRequest)((Object)obj);
        return Objects.equals(this.accessRights(), other.accessRights()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.groupDisplayName(), other.groupDisplayName()) && Objects.equals(this.groupSecurityIdentifier(), other.groupSecurityIdentifier()) && Objects.equals(this.templateArn(), other.templateArn());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTemplateGroupAccessControlEntryRequest").add("AccessRights", (Object)this.accessRights()).add("ClientToken", (Object)this.clientToken()).add("GroupDisplayName", (Object)this.groupDisplayName()).add("GroupSecurityIdentifier", (Object)this.groupSecurityIdentifier()).add("TemplateArn", (Object)this.templateArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessRights": {
                return Optional.ofNullable(clazz.cast(this.accessRights()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "GroupDisplayName": {
                return Optional.ofNullable(clazz.cast(this.groupDisplayName()));
            }
            case "GroupSecurityIdentifier": {
                return Optional.ofNullable(clazz.cast(this.groupSecurityIdentifier()));
            }
            case "TemplateArn": {
                return Optional.ofNullable(clazz.cast(this.templateArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccessRights", ACCESS_RIGHTS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("GroupDisplayName", GROUP_DISPLAY_NAME_FIELD);
        map.put("GroupSecurityIdentifier", GROUP_SECURITY_IDENTIFIER_FIELD);
        map.put("TemplateArn", TEMPLATE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTemplateGroupAccessControlEntryRequest, T> g) {
        return obj -> g.apply((CreateTemplateGroupAccessControlEntryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PcaConnectorAdRequest.BuilderImpl
    implements Builder {
        private AccessRights accessRights;
        private String clientToken;
        private String groupDisplayName;
        private String groupSecurityIdentifier;
        private String templateArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTemplateGroupAccessControlEntryRequest model) {
            super(model);
            this.accessRights(model.accessRights);
            this.clientToken(model.clientToken);
            this.groupDisplayName(model.groupDisplayName);
            this.groupSecurityIdentifier(model.groupSecurityIdentifier);
            this.templateArn(model.templateArn);
        }

        public final AccessRights.Builder getAccessRights() {
            return this.accessRights != null ? this.accessRights.toBuilder() : null;
        }

        public final void setAccessRights(AccessRights.BuilderImpl accessRights) {
            this.accessRights = accessRights != null ? accessRights.build() : null;
        }

        @Override
        public final Builder accessRights(AccessRights accessRights) {
            this.accessRights = accessRights;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getGroupDisplayName() {
            return this.groupDisplayName;
        }

        public final void setGroupDisplayName(String groupDisplayName) {
            this.groupDisplayName = groupDisplayName;
        }

        @Override
        public final Builder groupDisplayName(String groupDisplayName) {
            this.groupDisplayName = groupDisplayName;
            return this;
        }

        public final String getGroupSecurityIdentifier() {
            return this.groupSecurityIdentifier;
        }

        public final void setGroupSecurityIdentifier(String groupSecurityIdentifier) {
            this.groupSecurityIdentifier = groupSecurityIdentifier;
        }

        @Override
        public final Builder groupSecurityIdentifier(String groupSecurityIdentifier) {
            this.groupSecurityIdentifier = groupSecurityIdentifier;
            return this;
        }

        public final String getTemplateArn() {
            return this.templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTemplateGroupAccessControlEntryRequest build() {
            return new CreateTemplateGroupAccessControlEntryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PcaConnectorAdRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTemplateGroupAccessControlEntryRequest> {
        public Builder accessRights(AccessRights var1);

        default public Builder accessRights(Consumer<AccessRights.Builder> accessRights) {
            return this.accessRights((AccessRights)((AccessRights.Builder)AccessRights.builder().applyMutation(accessRights)).build());
        }

        public Builder clientToken(String var1);

        public Builder groupDisplayName(String var1);

        public Builder groupSecurityIdentifier(String var1);

        public Builder templateArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

