/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EncryptionMode {
    ECB("ECB"),
    CBC("CBC"),
    CFB("CFB"),
    CFB1("CFB1"),
    CFB8("CFB8"),
    CFB64("CFB64"),
    CFB128("CFB128"),
    OFB("OFB"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EncryptionMode> VALUE_MAP;
    private final String value;

    private EncryptionMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EncryptionMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EncryptionMode> knownValues() {
        EnumSet<EncryptionMode> knownValues = EnumSet.allOf(EncryptionMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EncryptionMode.class, EncryptionMode::toString);
    }
}

