/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptographydata.model.IncomingKeyMaterial;
import software.amazon.awssdk.services.paymentcryptographydata.model.KeyCheckValueAlgorithm;
import software.amazon.awssdk.services.paymentcryptographydata.model.OutgoingKeyMaterial;
import software.amazon.awssdk.services.paymentcryptographydata.model.PaymentCryptographyDataRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TranslateKeyMaterialRequest
extends PaymentCryptographyDataRequest
implements ToCopyableBuilder<Builder, TranslateKeyMaterialRequest> {
    private static final SdkField<IncomingKeyMaterial> INCOMING_KEY_MATERIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IncomingKeyMaterial").getter(TranslateKeyMaterialRequest.getter(TranslateKeyMaterialRequest::incomingKeyMaterial)).setter(TranslateKeyMaterialRequest.setter(Builder::incomingKeyMaterial)).constructor(IncomingKeyMaterial::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncomingKeyMaterial").build()}).build();
    private static final SdkField<OutgoingKeyMaterial> OUTGOING_KEY_MATERIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutgoingKeyMaterial").getter(TranslateKeyMaterialRequest.getter(TranslateKeyMaterialRequest::outgoingKeyMaterial)).setter(TranslateKeyMaterialRequest.setter(Builder::outgoingKeyMaterial)).constructor(OutgoingKeyMaterial::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutgoingKeyMaterial").build()}).build();
    private static final SdkField<String> KEY_CHECK_VALUE_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyCheckValueAlgorithm").getter(TranslateKeyMaterialRequest.getter(TranslateKeyMaterialRequest::keyCheckValueAlgorithmAsString)).setter(TranslateKeyMaterialRequest.setter(Builder::keyCheckValueAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyCheckValueAlgorithm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCOMING_KEY_MATERIAL_FIELD, OUTGOING_KEY_MATERIAL_FIELD, KEY_CHECK_VALUE_ALGORITHM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TranslateKeyMaterialRequest.memberNameToFieldInitializer();
    private final IncomingKeyMaterial incomingKeyMaterial;
    private final OutgoingKeyMaterial outgoingKeyMaterial;
    private final String keyCheckValueAlgorithm;

    private TranslateKeyMaterialRequest(BuilderImpl builder) {
        super(builder);
        this.incomingKeyMaterial = builder.incomingKeyMaterial;
        this.outgoingKeyMaterial = builder.outgoingKeyMaterial;
        this.keyCheckValueAlgorithm = builder.keyCheckValueAlgorithm;
    }

    public final IncomingKeyMaterial incomingKeyMaterial() {
        return this.incomingKeyMaterial;
    }

    public final OutgoingKeyMaterial outgoingKeyMaterial() {
        return this.outgoingKeyMaterial;
    }

    public final KeyCheckValueAlgorithm keyCheckValueAlgorithm() {
        return KeyCheckValueAlgorithm.fromValue(this.keyCheckValueAlgorithm);
    }

    public final String keyCheckValueAlgorithmAsString() {
        return this.keyCheckValueAlgorithm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.incomingKeyMaterial());
        hashCode = 31 * hashCode + Objects.hashCode(this.outgoingKeyMaterial());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyCheckValueAlgorithmAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranslateKeyMaterialRequest)) {
            return false;
        }
        TranslateKeyMaterialRequest other = (TranslateKeyMaterialRequest)((Object)obj);
        return Objects.equals(this.incomingKeyMaterial(), other.incomingKeyMaterial()) && Objects.equals(this.outgoingKeyMaterial(), other.outgoingKeyMaterial()) && Objects.equals(this.keyCheckValueAlgorithmAsString(), other.keyCheckValueAlgorithmAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TranslateKeyMaterialRequest").add("IncomingKeyMaterial", (Object)this.incomingKeyMaterial()).add("OutgoingKeyMaterial", (Object)this.outgoingKeyMaterial()).add("KeyCheckValueAlgorithm", (Object)this.keyCheckValueAlgorithmAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IncomingKeyMaterial": {
                return Optional.ofNullable(clazz.cast(this.incomingKeyMaterial()));
            }
            case "OutgoingKeyMaterial": {
                return Optional.ofNullable(clazz.cast(this.outgoingKeyMaterial()));
            }
            case "KeyCheckValueAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.keyCheckValueAlgorithmAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IncomingKeyMaterial", INCOMING_KEY_MATERIAL_FIELD);
        map.put("OutgoingKeyMaterial", OUTGOING_KEY_MATERIAL_FIELD);
        map.put("KeyCheckValueAlgorithm", KEY_CHECK_VALUE_ALGORITHM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TranslateKeyMaterialRequest, T> g) {
        return obj -> g.apply((TranslateKeyMaterialRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PaymentCryptographyDataRequest.BuilderImpl
    implements Builder {
        private IncomingKeyMaterial incomingKeyMaterial;
        private OutgoingKeyMaterial outgoingKeyMaterial;
        private String keyCheckValueAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(TranslateKeyMaterialRequest model) {
            super(model);
            this.incomingKeyMaterial(model.incomingKeyMaterial);
            this.outgoingKeyMaterial(model.outgoingKeyMaterial);
            this.keyCheckValueAlgorithm(model.keyCheckValueAlgorithm);
        }

        public final IncomingKeyMaterial.Builder getIncomingKeyMaterial() {
            return this.incomingKeyMaterial != null ? this.incomingKeyMaterial.toBuilder() : null;
        }

        public final void setIncomingKeyMaterial(IncomingKeyMaterial.BuilderImpl incomingKeyMaterial) {
            this.incomingKeyMaterial = incomingKeyMaterial != null ? incomingKeyMaterial.build() : null;
        }

        @Override
        public final Builder incomingKeyMaterial(IncomingKeyMaterial incomingKeyMaterial) {
            this.incomingKeyMaterial = incomingKeyMaterial;
            return this;
        }

        public final OutgoingKeyMaterial.Builder getOutgoingKeyMaterial() {
            return this.outgoingKeyMaterial != null ? this.outgoingKeyMaterial.toBuilder() : null;
        }

        public final void setOutgoingKeyMaterial(OutgoingKeyMaterial.BuilderImpl outgoingKeyMaterial) {
            this.outgoingKeyMaterial = outgoingKeyMaterial != null ? outgoingKeyMaterial.build() : null;
        }

        @Override
        public final Builder outgoingKeyMaterial(OutgoingKeyMaterial outgoingKeyMaterial) {
            this.outgoingKeyMaterial = outgoingKeyMaterial;
            return this;
        }

        public final String getKeyCheckValueAlgorithm() {
            return this.keyCheckValueAlgorithm;
        }

        public final void setKeyCheckValueAlgorithm(String keyCheckValueAlgorithm) {
            this.keyCheckValueAlgorithm = keyCheckValueAlgorithm;
        }

        @Override
        public final Builder keyCheckValueAlgorithm(String keyCheckValueAlgorithm) {
            this.keyCheckValueAlgorithm = keyCheckValueAlgorithm;
            return this;
        }

        @Override
        public final Builder keyCheckValueAlgorithm(KeyCheckValueAlgorithm keyCheckValueAlgorithm) {
            this.keyCheckValueAlgorithm(keyCheckValueAlgorithm == null ? null : keyCheckValueAlgorithm.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TranslateKeyMaterialRequest build() {
            return new TranslateKeyMaterialRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PaymentCryptographyDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TranslateKeyMaterialRequest> {
        public Builder incomingKeyMaterial(IncomingKeyMaterial var1);

        default public Builder incomingKeyMaterial(Consumer<IncomingKeyMaterial.Builder> incomingKeyMaterial) {
            return this.incomingKeyMaterial((IncomingKeyMaterial)((IncomingKeyMaterial.Builder)IncomingKeyMaterial.builder().applyMutation(incomingKeyMaterial)).build());
        }

        public Builder outgoingKeyMaterial(OutgoingKeyMaterial var1);

        default public Builder outgoingKeyMaterial(Consumer<OutgoingKeyMaterial.Builder> outgoingKeyMaterial) {
            return this.outgoingKeyMaterial((OutgoingKeyMaterial)((OutgoingKeyMaterial.Builder)OutgoingKeyMaterial.builder().applyMutation(outgoingKeyMaterial)).build());
        }

        public Builder keyCheckValueAlgorithm(String var1);

        public Builder keyCheckValueAlgorithm(KeyCheckValueAlgorithm var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

