/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.paymentcryptographydata.model.Ibm3624NaturalPin;
import software.amazon.awssdk.services.paymentcryptographydata.model.Ibm3624PinFromOffset;
import software.amazon.awssdk.services.paymentcryptographydata.model.Ibm3624PinOffset;
import software.amazon.awssdk.services.paymentcryptographydata.model.Ibm3624RandomPin;
import software.amazon.awssdk.services.paymentcryptographydata.model.VisaPin;
import software.amazon.awssdk.services.paymentcryptographydata.model.VisaPinVerificationValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PinGenerationAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PinGenerationAttributes> {
    private static final SdkField<VisaPin> VISA_PIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VisaPin").getter(PinGenerationAttributes.getter(PinGenerationAttributes::visaPin)).setter(PinGenerationAttributes.setter(Builder::visaPin)).constructor(VisaPin::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisaPin").build()}).build();
    private static final SdkField<VisaPinVerificationValue> VISA_PIN_VERIFICATION_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VisaPinVerificationValue").getter(PinGenerationAttributes.getter(PinGenerationAttributes::visaPinVerificationValue)).setter(PinGenerationAttributes.setter(Builder::visaPinVerificationValue)).constructor(VisaPinVerificationValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisaPinVerificationValue").build()}).build();
    private static final SdkField<Ibm3624PinOffset> IBM3624_PIN_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Ibm3624PinOffset").getter(PinGenerationAttributes.getter(PinGenerationAttributes::ibm3624PinOffset)).setter(PinGenerationAttributes.setter(Builder::ibm3624PinOffset)).constructor(Ibm3624PinOffset::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ibm3624PinOffset").build()}).build();
    private static final SdkField<Ibm3624NaturalPin> IBM3624_NATURAL_PIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Ibm3624NaturalPin").getter(PinGenerationAttributes.getter(PinGenerationAttributes::ibm3624NaturalPin)).setter(PinGenerationAttributes.setter(Builder::ibm3624NaturalPin)).constructor(Ibm3624NaturalPin::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ibm3624NaturalPin").build()}).build();
    private static final SdkField<Ibm3624RandomPin> IBM3624_RANDOM_PIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Ibm3624RandomPin").getter(PinGenerationAttributes.getter(PinGenerationAttributes::ibm3624RandomPin)).setter(PinGenerationAttributes.setter(Builder::ibm3624RandomPin)).constructor(Ibm3624RandomPin::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ibm3624RandomPin").build()}).build();
    private static final SdkField<Ibm3624PinFromOffset> IBM3624_PIN_FROM_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Ibm3624PinFromOffset").getter(PinGenerationAttributes.getter(PinGenerationAttributes::ibm3624PinFromOffset)).setter(PinGenerationAttributes.setter(Builder::ibm3624PinFromOffset)).constructor(Ibm3624PinFromOffset::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ibm3624PinFromOffset").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISA_PIN_FIELD, VISA_PIN_VERIFICATION_VALUE_FIELD, IBM3624_PIN_OFFSET_FIELD, IBM3624_NATURAL_PIN_FIELD, IBM3624_RANDOM_PIN_FIELD, IBM3624_PIN_FROM_OFFSET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PinGenerationAttributes.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final VisaPin visaPin;
    private final VisaPinVerificationValue visaPinVerificationValue;
    private final Ibm3624PinOffset ibm3624PinOffset;
    private final Ibm3624NaturalPin ibm3624NaturalPin;
    private final Ibm3624RandomPin ibm3624RandomPin;
    private final Ibm3624PinFromOffset ibm3624PinFromOffset;
    private final Type type;

    private PinGenerationAttributes(BuilderImpl builder) {
        this.visaPin = builder.visaPin;
        this.visaPinVerificationValue = builder.visaPinVerificationValue;
        this.ibm3624PinOffset = builder.ibm3624PinOffset;
        this.ibm3624NaturalPin = builder.ibm3624NaturalPin;
        this.ibm3624RandomPin = builder.ibm3624RandomPin;
        this.ibm3624PinFromOffset = builder.ibm3624PinFromOffset;
        this.type = builder.type;
    }

    public final VisaPin visaPin() {
        return this.visaPin;
    }

    public final VisaPinVerificationValue visaPinVerificationValue() {
        return this.visaPinVerificationValue;
    }

    public final Ibm3624PinOffset ibm3624PinOffset() {
        return this.ibm3624PinOffset;
    }

    public final Ibm3624NaturalPin ibm3624NaturalPin() {
        return this.ibm3624NaturalPin;
    }

    public final Ibm3624RandomPin ibm3624RandomPin() {
        return this.ibm3624RandomPin;
    }

    public final Ibm3624PinFromOffset ibm3624PinFromOffset() {
        return this.ibm3624PinFromOffset;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.visaPin());
        hashCode = 31 * hashCode + Objects.hashCode(this.visaPinVerificationValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.ibm3624PinOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.ibm3624NaturalPin());
        hashCode = 31 * hashCode + Objects.hashCode(this.ibm3624RandomPin());
        hashCode = 31 * hashCode + Objects.hashCode(this.ibm3624PinFromOffset());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PinGenerationAttributes)) {
            return false;
        }
        PinGenerationAttributes other = (PinGenerationAttributes)obj;
        return Objects.equals(this.visaPin(), other.visaPin()) && Objects.equals(this.visaPinVerificationValue(), other.visaPinVerificationValue()) && Objects.equals(this.ibm3624PinOffset(), other.ibm3624PinOffset()) && Objects.equals(this.ibm3624NaturalPin(), other.ibm3624NaturalPin()) && Objects.equals(this.ibm3624RandomPin(), other.ibm3624RandomPin()) && Objects.equals(this.ibm3624PinFromOffset(), other.ibm3624PinFromOffset());
    }

    public final String toString() {
        return ToString.builder((String)"PinGenerationAttributes").add("VisaPin", (Object)this.visaPin()).add("VisaPinVerificationValue", (Object)this.visaPinVerificationValue()).add("Ibm3624PinOffset", (Object)this.ibm3624PinOffset()).add("Ibm3624NaturalPin", (Object)this.ibm3624NaturalPin()).add("Ibm3624RandomPin", (Object)this.ibm3624RandomPin()).add("Ibm3624PinFromOffset", (Object)this.ibm3624PinFromOffset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VisaPin": {
                return Optional.ofNullable(clazz.cast(this.visaPin()));
            }
            case "VisaPinVerificationValue": {
                return Optional.ofNullable(clazz.cast(this.visaPinVerificationValue()));
            }
            case "Ibm3624PinOffset": {
                return Optional.ofNullable(clazz.cast(this.ibm3624PinOffset()));
            }
            case "Ibm3624NaturalPin": {
                return Optional.ofNullable(clazz.cast(this.ibm3624NaturalPin()));
            }
            case "Ibm3624RandomPin": {
                return Optional.ofNullable(clazz.cast(this.ibm3624RandomPin()));
            }
            case "Ibm3624PinFromOffset": {
                return Optional.ofNullable(clazz.cast(this.ibm3624PinFromOffset()));
            }
        }
        return Optional.empty();
    }

    public static PinGenerationAttributes fromVisaPin(VisaPin visaPin) {
        return (PinGenerationAttributes)PinGenerationAttributes.builder().visaPin(visaPin).build();
    }

    public static PinGenerationAttributes fromVisaPin(Consumer<VisaPin.Builder> visaPin) {
        VisaPin.Builder builder = VisaPin.builder();
        visaPin.accept(builder);
        return PinGenerationAttributes.fromVisaPin((VisaPin)builder.build());
    }

    public static PinGenerationAttributes fromVisaPinVerificationValue(VisaPinVerificationValue visaPinVerificationValue) {
        return (PinGenerationAttributes)PinGenerationAttributes.builder().visaPinVerificationValue(visaPinVerificationValue).build();
    }

    public static PinGenerationAttributes fromVisaPinVerificationValue(Consumer<VisaPinVerificationValue.Builder> visaPinVerificationValue) {
        VisaPinVerificationValue.Builder builder = VisaPinVerificationValue.builder();
        visaPinVerificationValue.accept(builder);
        return PinGenerationAttributes.fromVisaPinVerificationValue((VisaPinVerificationValue)builder.build());
    }

    public static PinGenerationAttributes fromIbm3624PinOffset(Ibm3624PinOffset ibm3624PinOffset) {
        return (PinGenerationAttributes)PinGenerationAttributes.builder().ibm3624PinOffset(ibm3624PinOffset).build();
    }

    public static PinGenerationAttributes fromIbm3624PinOffset(Consumer<Ibm3624PinOffset.Builder> ibm3624PinOffset) {
        Ibm3624PinOffset.Builder builder = Ibm3624PinOffset.builder();
        ibm3624PinOffset.accept(builder);
        return PinGenerationAttributes.fromIbm3624PinOffset((Ibm3624PinOffset)builder.build());
    }

    public static PinGenerationAttributes fromIbm3624NaturalPin(Ibm3624NaturalPin ibm3624NaturalPin) {
        return (PinGenerationAttributes)PinGenerationAttributes.builder().ibm3624NaturalPin(ibm3624NaturalPin).build();
    }

    public static PinGenerationAttributes fromIbm3624NaturalPin(Consumer<Ibm3624NaturalPin.Builder> ibm3624NaturalPin) {
        Ibm3624NaturalPin.Builder builder = Ibm3624NaturalPin.builder();
        ibm3624NaturalPin.accept(builder);
        return PinGenerationAttributes.fromIbm3624NaturalPin((Ibm3624NaturalPin)builder.build());
    }

    public static PinGenerationAttributes fromIbm3624RandomPin(Ibm3624RandomPin ibm3624RandomPin) {
        return (PinGenerationAttributes)PinGenerationAttributes.builder().ibm3624RandomPin(ibm3624RandomPin).build();
    }

    public static PinGenerationAttributes fromIbm3624RandomPin(Consumer<Ibm3624RandomPin.Builder> ibm3624RandomPin) {
        Ibm3624RandomPin.Builder builder = Ibm3624RandomPin.builder();
        ibm3624RandomPin.accept(builder);
        return PinGenerationAttributes.fromIbm3624RandomPin((Ibm3624RandomPin)builder.build());
    }

    public static PinGenerationAttributes fromIbm3624PinFromOffset(Ibm3624PinFromOffset ibm3624PinFromOffset) {
        return (PinGenerationAttributes)PinGenerationAttributes.builder().ibm3624PinFromOffset(ibm3624PinFromOffset).build();
    }

    public static PinGenerationAttributes fromIbm3624PinFromOffset(Consumer<Ibm3624PinFromOffset.Builder> ibm3624PinFromOffset) {
        Ibm3624PinFromOffset.Builder builder = Ibm3624PinFromOffset.builder();
        ibm3624PinFromOffset.accept(builder);
        return PinGenerationAttributes.fromIbm3624PinFromOffset((Ibm3624PinFromOffset)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VisaPin", VISA_PIN_FIELD);
        map.put("VisaPinVerificationValue", VISA_PIN_VERIFICATION_VALUE_FIELD);
        map.put("Ibm3624PinOffset", IBM3624_PIN_OFFSET_FIELD);
        map.put("Ibm3624NaturalPin", IBM3624_NATURAL_PIN_FIELD);
        map.put("Ibm3624RandomPin", IBM3624_RANDOM_PIN_FIELD);
        map.put("Ibm3624PinFromOffset", IBM3624_PIN_FROM_OFFSET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PinGenerationAttributes, T> g) {
        return obj -> g.apply((PinGenerationAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        VISA_PIN,
        VISA_PIN_VERIFICATION_VALUE,
        IBM3624_PIN_OFFSET,
        IBM3624_NATURAL_PIN,
        IBM3624_RANDOM_PIN,
        IBM3624_PIN_FROM_OFFSET,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private VisaPin visaPin;
        private VisaPinVerificationValue visaPinVerificationValue;
        private Ibm3624PinOffset ibm3624PinOffset;
        private Ibm3624NaturalPin ibm3624NaturalPin;
        private Ibm3624RandomPin ibm3624RandomPin;
        private Ibm3624PinFromOffset ibm3624PinFromOffset;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PinGenerationAttributes model) {
            this.visaPin(model.visaPin);
            this.visaPinVerificationValue(model.visaPinVerificationValue);
            this.ibm3624PinOffset(model.ibm3624PinOffset);
            this.ibm3624NaturalPin(model.ibm3624NaturalPin);
            this.ibm3624RandomPin(model.ibm3624RandomPin);
            this.ibm3624PinFromOffset(model.ibm3624PinFromOffset);
        }

        public final VisaPin.Builder getVisaPin() {
            return this.visaPin != null ? this.visaPin.toBuilder() : null;
        }

        public final void setVisaPin(VisaPin.BuilderImpl visaPin) {
            VisaPin oldValue = this.visaPin;
            this.visaPin = visaPin != null ? visaPin.build() : null;
            this.handleUnionValueChange(Type.VISA_PIN, oldValue, this.visaPin);
        }

        @Override
        public final Builder visaPin(VisaPin visaPin) {
            VisaPin oldValue = this.visaPin;
            this.visaPin = visaPin;
            this.handleUnionValueChange(Type.VISA_PIN, oldValue, this.visaPin);
            return this;
        }

        public final VisaPinVerificationValue.Builder getVisaPinVerificationValue() {
            return this.visaPinVerificationValue != null ? this.visaPinVerificationValue.toBuilder() : null;
        }

        public final void setVisaPinVerificationValue(VisaPinVerificationValue.BuilderImpl visaPinVerificationValue) {
            VisaPinVerificationValue oldValue = this.visaPinVerificationValue;
            this.visaPinVerificationValue = visaPinVerificationValue != null ? visaPinVerificationValue.build() : null;
            this.handleUnionValueChange(Type.VISA_PIN_VERIFICATION_VALUE, oldValue, this.visaPinVerificationValue);
        }

        @Override
        public final Builder visaPinVerificationValue(VisaPinVerificationValue visaPinVerificationValue) {
            VisaPinVerificationValue oldValue = this.visaPinVerificationValue;
            this.visaPinVerificationValue = visaPinVerificationValue;
            this.handleUnionValueChange(Type.VISA_PIN_VERIFICATION_VALUE, oldValue, this.visaPinVerificationValue);
            return this;
        }

        public final Ibm3624PinOffset.Builder getIbm3624PinOffset() {
            return this.ibm3624PinOffset != null ? this.ibm3624PinOffset.toBuilder() : null;
        }

        public final void setIbm3624PinOffset(Ibm3624PinOffset.BuilderImpl ibm3624PinOffset) {
            Ibm3624PinOffset oldValue = this.ibm3624PinOffset;
            this.ibm3624PinOffset = ibm3624PinOffset != null ? ibm3624PinOffset.build() : null;
            this.handleUnionValueChange(Type.IBM3624_PIN_OFFSET, oldValue, this.ibm3624PinOffset);
        }

        @Override
        public final Builder ibm3624PinOffset(Ibm3624PinOffset ibm3624PinOffset) {
            Ibm3624PinOffset oldValue = this.ibm3624PinOffset;
            this.ibm3624PinOffset = ibm3624PinOffset;
            this.handleUnionValueChange(Type.IBM3624_PIN_OFFSET, oldValue, this.ibm3624PinOffset);
            return this;
        }

        public final Ibm3624NaturalPin.Builder getIbm3624NaturalPin() {
            return this.ibm3624NaturalPin != null ? this.ibm3624NaturalPin.toBuilder() : null;
        }

        public final void setIbm3624NaturalPin(Ibm3624NaturalPin.BuilderImpl ibm3624NaturalPin) {
            Ibm3624NaturalPin oldValue = this.ibm3624NaturalPin;
            this.ibm3624NaturalPin = ibm3624NaturalPin != null ? ibm3624NaturalPin.build() : null;
            this.handleUnionValueChange(Type.IBM3624_NATURAL_PIN, oldValue, this.ibm3624NaturalPin);
        }

        @Override
        public final Builder ibm3624NaturalPin(Ibm3624NaturalPin ibm3624NaturalPin) {
            Ibm3624NaturalPin oldValue = this.ibm3624NaturalPin;
            this.ibm3624NaturalPin = ibm3624NaturalPin;
            this.handleUnionValueChange(Type.IBM3624_NATURAL_PIN, oldValue, this.ibm3624NaturalPin);
            return this;
        }

        public final Ibm3624RandomPin.Builder getIbm3624RandomPin() {
            return this.ibm3624RandomPin != null ? this.ibm3624RandomPin.toBuilder() : null;
        }

        public final void setIbm3624RandomPin(Ibm3624RandomPin.BuilderImpl ibm3624RandomPin) {
            Ibm3624RandomPin oldValue = this.ibm3624RandomPin;
            this.ibm3624RandomPin = ibm3624RandomPin != null ? ibm3624RandomPin.build() : null;
            this.handleUnionValueChange(Type.IBM3624_RANDOM_PIN, oldValue, this.ibm3624RandomPin);
        }

        @Override
        public final Builder ibm3624RandomPin(Ibm3624RandomPin ibm3624RandomPin) {
            Ibm3624RandomPin oldValue = this.ibm3624RandomPin;
            this.ibm3624RandomPin = ibm3624RandomPin;
            this.handleUnionValueChange(Type.IBM3624_RANDOM_PIN, oldValue, this.ibm3624RandomPin);
            return this;
        }

        public final Ibm3624PinFromOffset.Builder getIbm3624PinFromOffset() {
            return this.ibm3624PinFromOffset != null ? this.ibm3624PinFromOffset.toBuilder() : null;
        }

        public final void setIbm3624PinFromOffset(Ibm3624PinFromOffset.BuilderImpl ibm3624PinFromOffset) {
            Ibm3624PinFromOffset oldValue = this.ibm3624PinFromOffset;
            this.ibm3624PinFromOffset = ibm3624PinFromOffset != null ? ibm3624PinFromOffset.build() : null;
            this.handleUnionValueChange(Type.IBM3624_PIN_FROM_OFFSET, oldValue, this.ibm3624PinFromOffset);
        }

        @Override
        public final Builder ibm3624PinFromOffset(Ibm3624PinFromOffset ibm3624PinFromOffset) {
            Ibm3624PinFromOffset oldValue = this.ibm3624PinFromOffset;
            this.ibm3624PinFromOffset = ibm3624PinFromOffset;
            this.handleUnionValueChange(Type.IBM3624_PIN_FROM_OFFSET, oldValue, this.ibm3624PinFromOffset);
            return this;
        }

        public PinGenerationAttributes build() {
            return new PinGenerationAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PinGenerationAttributes> {
        public Builder visaPin(VisaPin var1);

        default public Builder visaPin(Consumer<VisaPin.Builder> visaPin) {
            return this.visaPin((VisaPin)((VisaPin.Builder)VisaPin.builder().applyMutation(visaPin)).build());
        }

        public Builder visaPinVerificationValue(VisaPinVerificationValue var1);

        default public Builder visaPinVerificationValue(Consumer<VisaPinVerificationValue.Builder> visaPinVerificationValue) {
            return this.visaPinVerificationValue((VisaPinVerificationValue)((VisaPinVerificationValue.Builder)VisaPinVerificationValue.builder().applyMutation(visaPinVerificationValue)).build());
        }

        public Builder ibm3624PinOffset(Ibm3624PinOffset var1);

        default public Builder ibm3624PinOffset(Consumer<Ibm3624PinOffset.Builder> ibm3624PinOffset) {
            return this.ibm3624PinOffset((Ibm3624PinOffset)((Ibm3624PinOffset.Builder)Ibm3624PinOffset.builder().applyMutation(ibm3624PinOffset)).build());
        }

        public Builder ibm3624NaturalPin(Ibm3624NaturalPin var1);

        default public Builder ibm3624NaturalPin(Consumer<Ibm3624NaturalPin.Builder> ibm3624NaturalPin) {
            return this.ibm3624NaturalPin((Ibm3624NaturalPin)((Ibm3624NaturalPin.Builder)Ibm3624NaturalPin.builder().applyMutation(ibm3624NaturalPin)).build());
        }

        public Builder ibm3624RandomPin(Ibm3624RandomPin var1);

        default public Builder ibm3624RandomPin(Consumer<Ibm3624RandomPin.Builder> ibm3624RandomPin) {
            return this.ibm3624RandomPin((Ibm3624RandomPin)((Ibm3624RandomPin.Builder)Ibm3624RandomPin.builder().applyMutation(ibm3624RandomPin)).build());
        }

        public Builder ibm3624PinFromOffset(Ibm3624PinFromOffset var1);

        default public Builder ibm3624PinFromOffset(Consumer<Ibm3624PinFromOffset.Builder> ibm3624PinFromOffset) {
            return this.ibm3624PinFromOffset((Ibm3624PinFromOffset)((Ibm3624PinFromOffset.Builder)Ibm3624PinFromOffset.builder().applyMutation(ibm3624PinFromOffset)).build());
        }
    }
}

