/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EmvEncryptionMode {
    ECB("ECB"),
    CBC("CBC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EmvEncryptionMode> VALUE_MAP;
    private final String value;

    private EmvEncryptionMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EmvEncryptionMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EmvEncryptionMode> knownValues() {
        EnumSet<EmvEncryptionMode> knownValues = EnumSet.allOf(EmvEncryptionMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EmvEncryptionMode.class, EmvEncryptionMode::toString);
    }
}

