/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.paymentcryptography.model.KeyExportability;
import software.amazon.awssdk.services.paymentcryptography.model.KeyModesOfUse;
import software.amazon.awssdk.services.paymentcryptography.model.OptionalBlocksCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KeyBlockHeaders
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KeyBlockHeaders> {
    private static final SdkField<KeyModesOfUse> KEY_MODES_OF_USE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KeyModesOfUse").getter(KeyBlockHeaders.getter(KeyBlockHeaders::keyModesOfUse)).setter(KeyBlockHeaders.setter(Builder::keyModesOfUse)).constructor(KeyModesOfUse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyModesOfUse").build()}).build();
    private static final SdkField<String> KEY_EXPORTABILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyExportability").getter(KeyBlockHeaders.getter(KeyBlockHeaders::keyExportabilityAsString)).setter(KeyBlockHeaders.setter(Builder::keyExportability)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyExportability").build()}).build();
    private static final SdkField<String> KEY_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyVersion").getter(KeyBlockHeaders.getter(KeyBlockHeaders::keyVersion)).setter(KeyBlockHeaders.setter(Builder::keyVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyVersion").build()}).build();
    private static final SdkField<Map<String, String>> OPTIONAL_BLOCKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("OptionalBlocks").getter(KeyBlockHeaders.getter(KeyBlockHeaders::optionalBlocks)).setter(KeyBlockHeaders.setter(Builder::optionalBlocks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionalBlocks").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_MODES_OF_USE_FIELD, KEY_EXPORTABILITY_FIELD, KEY_VERSION_FIELD, OPTIONAL_BLOCKS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KeyBlockHeaders.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final KeyModesOfUse keyModesOfUse;
    private final String keyExportability;
    private final String keyVersion;
    private final Map<String, String> optionalBlocks;

    private KeyBlockHeaders(BuilderImpl builder) {
        this.keyModesOfUse = builder.keyModesOfUse;
        this.keyExportability = builder.keyExportability;
        this.keyVersion = builder.keyVersion;
        this.optionalBlocks = builder.optionalBlocks;
    }

    public final KeyModesOfUse keyModesOfUse() {
        return this.keyModesOfUse;
    }

    public final KeyExportability keyExportability() {
        return KeyExportability.fromValue(this.keyExportability);
    }

    public final String keyExportabilityAsString() {
        return this.keyExportability;
    }

    public final String keyVersion() {
        return this.keyVersion;
    }

    public final boolean hasOptionalBlocks() {
        return this.optionalBlocks != null && !(this.optionalBlocks instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> optionalBlocks() {
        return this.optionalBlocks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyModesOfUse());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyExportabilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptionalBlocks() ? this.optionalBlocks() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyBlockHeaders)) {
            return false;
        }
        KeyBlockHeaders other = (KeyBlockHeaders)obj;
        return Objects.equals(this.keyModesOfUse(), other.keyModesOfUse()) && Objects.equals(this.keyExportabilityAsString(), other.keyExportabilityAsString()) && Objects.equals(this.keyVersion(), other.keyVersion()) && this.hasOptionalBlocks() == other.hasOptionalBlocks() && Objects.equals(this.optionalBlocks(), other.optionalBlocks());
    }

    public final String toString() {
        return ToString.builder((String)"KeyBlockHeaders").add("KeyModesOfUse", (Object)this.keyModesOfUse()).add("KeyExportability", (Object)this.keyExportabilityAsString()).add("KeyVersion", (Object)this.keyVersion()).add("OptionalBlocks", (Object)(this.optionalBlocks() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyModesOfUse": {
                return Optional.ofNullable(clazz.cast(this.keyModesOfUse()));
            }
            case "KeyExportability": {
                return Optional.ofNullable(clazz.cast(this.keyExportabilityAsString()));
            }
            case "KeyVersion": {
                return Optional.ofNullable(clazz.cast(this.keyVersion()));
            }
            case "OptionalBlocks": {
                return Optional.ofNullable(clazz.cast(this.optionalBlocks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KeyModesOfUse", KEY_MODES_OF_USE_FIELD);
        map.put("KeyExportability", KEY_EXPORTABILITY_FIELD);
        map.put("KeyVersion", KEY_VERSION_FIELD);
        map.put("OptionalBlocks", OPTIONAL_BLOCKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KeyBlockHeaders, T> g) {
        return obj -> g.apply((KeyBlockHeaders)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private KeyModesOfUse keyModesOfUse;
        private String keyExportability;
        private String keyVersion;
        private Map<String, String> optionalBlocks = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(KeyBlockHeaders model) {
            this.keyModesOfUse(model.keyModesOfUse);
            this.keyExportability(model.keyExportability);
            this.keyVersion(model.keyVersion);
            this.optionalBlocks(model.optionalBlocks);
        }

        public final KeyModesOfUse.Builder getKeyModesOfUse() {
            return this.keyModesOfUse != null ? this.keyModesOfUse.toBuilder() : null;
        }

        public final void setKeyModesOfUse(KeyModesOfUse.BuilderImpl keyModesOfUse) {
            this.keyModesOfUse = keyModesOfUse != null ? keyModesOfUse.build() : null;
        }

        @Override
        public final Builder keyModesOfUse(KeyModesOfUse keyModesOfUse) {
            this.keyModesOfUse = keyModesOfUse;
            return this;
        }

        public final String getKeyExportability() {
            return this.keyExportability;
        }

        public final void setKeyExportability(String keyExportability) {
            this.keyExportability = keyExportability;
        }

        @Override
        public final Builder keyExportability(String keyExportability) {
            this.keyExportability = keyExportability;
            return this;
        }

        @Override
        public final Builder keyExportability(KeyExportability keyExportability) {
            this.keyExportability(keyExportability == null ? null : keyExportability.toString());
            return this;
        }

        public final String getKeyVersion() {
            return this.keyVersion;
        }

        public final void setKeyVersion(String keyVersion) {
            this.keyVersion = keyVersion;
        }

        @Override
        public final Builder keyVersion(String keyVersion) {
            this.keyVersion = keyVersion;
            return this;
        }

        public final Map<String, String> getOptionalBlocks() {
            if (this.optionalBlocks instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.optionalBlocks;
        }

        public final void setOptionalBlocks(Map<String, String> optionalBlocks) {
            this.optionalBlocks = OptionalBlocksCopier.copy(optionalBlocks);
        }

        @Override
        public final Builder optionalBlocks(Map<String, String> optionalBlocks) {
            this.optionalBlocks = OptionalBlocksCopier.copy(optionalBlocks);
            return this;
        }

        public KeyBlockHeaders build() {
            return new KeyBlockHeaders(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KeyBlockHeaders> {
        public Builder keyModesOfUse(KeyModesOfUse var1);

        default public Builder keyModesOfUse(Consumer<KeyModesOfUse.Builder> keyModesOfUse) {
            return this.keyModesOfUse((KeyModesOfUse)((KeyModesOfUse.Builder)KeyModesOfUse.builder().applyMutation(keyModesOfUse)).build());
        }

        public Builder keyExportability(String var1);

        public Builder keyExportability(KeyExportability var1);

        public Builder keyVersion(String var1);

        public Builder optionalBlocks(Map<String, String> var1);
    }
}

