/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptography.model.KeyAttributes;
import software.amazon.awssdk.services.paymentcryptography.model.KeyState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KeySummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KeySummary> {
    private static final SdkField<String> KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyArn").getter(KeySummary.getter(KeySummary::keyArn)).setter(KeySummary.setter(Builder::keyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyArn").build()}).build();
    private static final SdkField<String> KEY_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyState").getter(KeySummary.getter(KeySummary::keyStateAsString)).setter(KeySummary.setter(Builder::keyState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyState").build()}).build();
    private static final SdkField<KeyAttributes> KEY_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KeyAttributes").getter(KeySummary.getter(KeySummary::keyAttributes)).setter(KeySummary.setter(Builder::keyAttributes)).constructor(KeyAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAttributes").build()}).build();
    private static final SdkField<String> KEY_CHECK_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyCheckValue").getter(KeySummary.getter(KeySummary::keyCheckValue)).setter(KeySummary.setter(Builder::keyCheckValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyCheckValue").build()}).build();
    private static final SdkField<Boolean> EXPORTABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Exportable").getter(KeySummary.getter(KeySummary::exportable)).setter(KeySummary.setter(Builder::exportable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exportable").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(KeySummary.getter(KeySummary::enabled)).setter(KeySummary.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ARN_FIELD, KEY_STATE_FIELD, KEY_ATTRIBUTES_FIELD, KEY_CHECK_VALUE_FIELD, EXPORTABLE_FIELD, ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KeySummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String keyArn;
    private final String keyState;
    private final KeyAttributes keyAttributes;
    private final String keyCheckValue;
    private final Boolean exportable;
    private final Boolean enabled;

    private KeySummary(BuilderImpl builder) {
        this.keyArn = builder.keyArn;
        this.keyState = builder.keyState;
        this.keyAttributes = builder.keyAttributes;
        this.keyCheckValue = builder.keyCheckValue;
        this.exportable = builder.exportable;
        this.enabled = builder.enabled;
    }

    public final String keyArn() {
        return this.keyArn;
    }

    public final KeyState keyState() {
        return KeyState.fromValue(this.keyState);
    }

    public final String keyStateAsString() {
        return this.keyState;
    }

    public final KeyAttributes keyAttributes() {
        return this.keyAttributes;
    }

    public final String keyCheckValue() {
        return this.keyCheckValue;
    }

    public final Boolean exportable() {
        return this.exportable;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyCheckValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportable());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeySummary)) {
            return false;
        }
        KeySummary other = (KeySummary)obj;
        return Objects.equals(this.keyArn(), other.keyArn()) && Objects.equals(this.keyStateAsString(), other.keyStateAsString()) && Objects.equals(this.keyAttributes(), other.keyAttributes()) && Objects.equals(this.keyCheckValue(), other.keyCheckValue()) && Objects.equals(this.exportable(), other.exportable()) && Objects.equals(this.enabled(), other.enabled());
    }

    public final String toString() {
        return ToString.builder((String)"KeySummary").add("KeyArn", (Object)this.keyArn()).add("KeyState", (Object)this.keyStateAsString()).add("KeyAttributes", (Object)this.keyAttributes()).add("KeyCheckValue", (Object)this.keyCheckValue()).add("Exportable", (Object)this.exportable()).add("Enabled", (Object)this.enabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyArn": {
                return Optional.ofNullable(clazz.cast(this.keyArn()));
            }
            case "KeyState": {
                return Optional.ofNullable(clazz.cast(this.keyStateAsString()));
            }
            case "KeyAttributes": {
                return Optional.ofNullable(clazz.cast(this.keyAttributes()));
            }
            case "KeyCheckValue": {
                return Optional.ofNullable(clazz.cast(this.keyCheckValue()));
            }
            case "Exportable": {
                return Optional.ofNullable(clazz.cast(this.exportable()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KeyArn", KEY_ARN_FIELD);
        map.put("KeyState", KEY_STATE_FIELD);
        map.put("KeyAttributes", KEY_ATTRIBUTES_FIELD);
        map.put("KeyCheckValue", KEY_CHECK_VALUE_FIELD);
        map.put("Exportable", EXPORTABLE_FIELD);
        map.put("Enabled", ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KeySummary, T> g) {
        return obj -> g.apply((KeySummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String keyArn;
        private String keyState;
        private KeyAttributes keyAttributes;
        private String keyCheckValue;
        private Boolean exportable;
        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(KeySummary model) {
            this.keyArn(model.keyArn);
            this.keyState(model.keyState);
            this.keyAttributes(model.keyAttributes);
            this.keyCheckValue(model.keyCheckValue);
            this.exportable(model.exportable);
            this.enabled(model.enabled);
        }

        public final String getKeyArn() {
            return this.keyArn;
        }

        public final void setKeyArn(String keyArn) {
            this.keyArn = keyArn;
        }

        @Override
        public final Builder keyArn(String keyArn) {
            this.keyArn = keyArn;
            return this;
        }

        public final String getKeyState() {
            return this.keyState;
        }

        public final void setKeyState(String keyState) {
            this.keyState = keyState;
        }

        @Override
        public final Builder keyState(String keyState) {
            this.keyState = keyState;
            return this;
        }

        @Override
        public final Builder keyState(KeyState keyState) {
            this.keyState(keyState == null ? null : keyState.toString());
            return this;
        }

        public final KeyAttributes.Builder getKeyAttributes() {
            return this.keyAttributes != null ? this.keyAttributes.toBuilder() : null;
        }

        public final void setKeyAttributes(KeyAttributes.BuilderImpl keyAttributes) {
            this.keyAttributes = keyAttributes != null ? keyAttributes.build() : null;
        }

        @Override
        public final Builder keyAttributes(KeyAttributes keyAttributes) {
            this.keyAttributes = keyAttributes;
            return this;
        }

        public final String getKeyCheckValue() {
            return this.keyCheckValue;
        }

        public final void setKeyCheckValue(String keyCheckValue) {
            this.keyCheckValue = keyCheckValue;
        }

        @Override
        public final Builder keyCheckValue(String keyCheckValue) {
            this.keyCheckValue = keyCheckValue;
            return this;
        }

        public final Boolean getExportable() {
            return this.exportable;
        }

        public final void setExportable(Boolean exportable) {
            this.exportable = exportable;
        }

        @Override
        public final Builder exportable(Boolean exportable) {
            this.exportable = exportable;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public KeySummary build() {
            return new KeySummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KeySummary> {
        public Builder keyArn(String var1);

        public Builder keyState(String var1);

        public Builder keyState(KeyState var1);

        public Builder keyAttributes(KeyAttributes var1);

        default public Builder keyAttributes(Consumer<KeyAttributes.Builder> keyAttributes) {
            return this.keyAttributes((KeyAttributes)((KeyAttributes.Builder)KeyAttributes.builder().applyMutation(keyAttributes)).build());
        }

        public Builder keyCheckValue(String var1);

        public Builder exportable(Boolean var1);

        public Builder enabled(Boolean var1);
    }
}

