/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm;
import software.amazon.awssdk.services.paymentcryptography.model.PaymentCryptographyResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetParametersForExportResponse
extends PaymentCryptographyResponse
implements ToCopyableBuilder<Builder, GetParametersForExportResponse> {
    private static final SdkField<String> SIGNING_KEY_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SigningKeyCertificate").getter(GetParametersForExportResponse.getter(GetParametersForExportResponse::signingKeyCertificate)).setter(GetParametersForExportResponse.setter(Builder::signingKeyCertificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningKeyCertificate").build()}).build();
    private static final SdkField<String> SIGNING_KEY_CERTIFICATE_CHAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SigningKeyCertificateChain").getter(GetParametersForExportResponse.getter(GetParametersForExportResponse::signingKeyCertificateChain)).setter(GetParametersForExportResponse.setter(Builder::signingKeyCertificateChain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningKeyCertificateChain").build()}).build();
    private static final SdkField<String> SIGNING_KEY_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SigningKeyAlgorithm").getter(GetParametersForExportResponse.getter(GetParametersForExportResponse::signingKeyAlgorithmAsString)).setter(GetParametersForExportResponse.setter(Builder::signingKeyAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningKeyAlgorithm").build()}).build();
    private static final SdkField<String> EXPORT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportToken").getter(GetParametersForExportResponse.getter(GetParametersForExportResponse::exportToken)).setter(GetParametersForExportResponse.setter(Builder::exportToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportToken").build()}).build();
    private static final SdkField<Instant> PARAMETERS_VALID_UNTIL_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ParametersValidUntilTimestamp").getter(GetParametersForExportResponse.getter(GetParametersForExportResponse::parametersValidUntilTimestamp)).setter(GetParametersForExportResponse.setter(Builder::parametersValidUntilTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParametersValidUntilTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNING_KEY_CERTIFICATE_FIELD, SIGNING_KEY_CERTIFICATE_CHAIN_FIELD, SIGNING_KEY_ALGORITHM_FIELD, EXPORT_TOKEN_FIELD, PARAMETERS_VALID_UNTIL_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetParametersForExportResponse.memberNameToFieldInitializer();
    private final String signingKeyCertificate;
    private final String signingKeyCertificateChain;
    private final String signingKeyAlgorithm;
    private final String exportToken;
    private final Instant parametersValidUntilTimestamp;

    private GetParametersForExportResponse(BuilderImpl builder) {
        super(builder);
        this.signingKeyCertificate = builder.signingKeyCertificate;
        this.signingKeyCertificateChain = builder.signingKeyCertificateChain;
        this.signingKeyAlgorithm = builder.signingKeyAlgorithm;
        this.exportToken = builder.exportToken;
        this.parametersValidUntilTimestamp = builder.parametersValidUntilTimestamp;
    }

    public final String signingKeyCertificate() {
        return this.signingKeyCertificate;
    }

    public final String signingKeyCertificateChain() {
        return this.signingKeyCertificateChain;
    }

    public final KeyAlgorithm signingKeyAlgorithm() {
        return KeyAlgorithm.fromValue(this.signingKeyAlgorithm);
    }

    public final String signingKeyAlgorithmAsString() {
        return this.signingKeyAlgorithm;
    }

    public final String exportToken() {
        return this.exportToken;
    }

    public final Instant parametersValidUntilTimestamp() {
        return this.parametersValidUntilTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.signingKeyCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingKeyCertificateChain());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingKeyAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.parametersValidUntilTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParametersForExportResponse)) {
            return false;
        }
        GetParametersForExportResponse other = (GetParametersForExportResponse)((Object)obj);
        return Objects.equals(this.signingKeyCertificate(), other.signingKeyCertificate()) && Objects.equals(this.signingKeyCertificateChain(), other.signingKeyCertificateChain()) && Objects.equals(this.signingKeyAlgorithmAsString(), other.signingKeyAlgorithmAsString()) && Objects.equals(this.exportToken(), other.exportToken()) && Objects.equals(this.parametersValidUntilTimestamp(), other.parametersValidUntilTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"GetParametersForExportResponse").add("SigningKeyCertificate", (Object)(this.signingKeyCertificate() == null ? null : "*** Sensitive Data Redacted ***")).add("SigningKeyCertificateChain", (Object)(this.signingKeyCertificateChain() == null ? null : "*** Sensitive Data Redacted ***")).add("SigningKeyAlgorithm", (Object)this.signingKeyAlgorithmAsString()).add("ExportToken", (Object)this.exportToken()).add("ParametersValidUntilTimestamp", (Object)this.parametersValidUntilTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SigningKeyCertificate": {
                return Optional.ofNullable(clazz.cast(this.signingKeyCertificate()));
            }
            case "SigningKeyCertificateChain": {
                return Optional.ofNullable(clazz.cast(this.signingKeyCertificateChain()));
            }
            case "SigningKeyAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.signingKeyAlgorithmAsString()));
            }
            case "ExportToken": {
                return Optional.ofNullable(clazz.cast(this.exportToken()));
            }
            case "ParametersValidUntilTimestamp": {
                return Optional.ofNullable(clazz.cast(this.parametersValidUntilTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SigningKeyCertificate", SIGNING_KEY_CERTIFICATE_FIELD);
        map.put("SigningKeyCertificateChain", SIGNING_KEY_CERTIFICATE_CHAIN_FIELD);
        map.put("SigningKeyAlgorithm", SIGNING_KEY_ALGORITHM_FIELD);
        map.put("ExportToken", EXPORT_TOKEN_FIELD);
        map.put("ParametersValidUntilTimestamp", PARAMETERS_VALID_UNTIL_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetParametersForExportResponse, T> g) {
        return obj -> g.apply((GetParametersForExportResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PaymentCryptographyResponse.BuilderImpl
    implements Builder {
        private String signingKeyCertificate;
        private String signingKeyCertificateChain;
        private String signingKeyAlgorithm;
        private String exportToken;
        private Instant parametersValidUntilTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParametersForExportResponse model) {
            super(model);
            this.signingKeyCertificate(model.signingKeyCertificate);
            this.signingKeyCertificateChain(model.signingKeyCertificateChain);
            this.signingKeyAlgorithm(model.signingKeyAlgorithm);
            this.exportToken(model.exportToken);
            this.parametersValidUntilTimestamp(model.parametersValidUntilTimestamp);
        }

        public final String getSigningKeyCertificate() {
            return this.signingKeyCertificate;
        }

        public final void setSigningKeyCertificate(String signingKeyCertificate) {
            this.signingKeyCertificate = signingKeyCertificate;
        }

        @Override
        public final Builder signingKeyCertificate(String signingKeyCertificate) {
            this.signingKeyCertificate = signingKeyCertificate;
            return this;
        }

        public final String getSigningKeyCertificateChain() {
            return this.signingKeyCertificateChain;
        }

        public final void setSigningKeyCertificateChain(String signingKeyCertificateChain) {
            this.signingKeyCertificateChain = signingKeyCertificateChain;
        }

        @Override
        public final Builder signingKeyCertificateChain(String signingKeyCertificateChain) {
            this.signingKeyCertificateChain = signingKeyCertificateChain;
            return this;
        }

        public final String getSigningKeyAlgorithm() {
            return this.signingKeyAlgorithm;
        }

        public final void setSigningKeyAlgorithm(String signingKeyAlgorithm) {
            this.signingKeyAlgorithm = signingKeyAlgorithm;
        }

        @Override
        public final Builder signingKeyAlgorithm(String signingKeyAlgorithm) {
            this.signingKeyAlgorithm = signingKeyAlgorithm;
            return this;
        }

        @Override
        public final Builder signingKeyAlgorithm(KeyAlgorithm signingKeyAlgorithm) {
            this.signingKeyAlgorithm(signingKeyAlgorithm == null ? null : signingKeyAlgorithm.toString());
            return this;
        }

        public final String getExportToken() {
            return this.exportToken;
        }

        public final void setExportToken(String exportToken) {
            this.exportToken = exportToken;
        }

        @Override
        public final Builder exportToken(String exportToken) {
            this.exportToken = exportToken;
            return this;
        }

        public final Instant getParametersValidUntilTimestamp() {
            return this.parametersValidUntilTimestamp;
        }

        public final void setParametersValidUntilTimestamp(Instant parametersValidUntilTimestamp) {
            this.parametersValidUntilTimestamp = parametersValidUntilTimestamp;
        }

        @Override
        public final Builder parametersValidUntilTimestamp(Instant parametersValidUntilTimestamp) {
            this.parametersValidUntilTimestamp = parametersValidUntilTimestamp;
            return this;
        }

        @Override
        public GetParametersForExportResponse build() {
            return new GetParametersForExportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PaymentCryptographyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetParametersForExportResponse> {
        public Builder signingKeyCertificate(String var1);

        public Builder signingKeyCertificateChain(String var1);

        public Builder signingKeyAlgorithm(String var1);

        public Builder signingKeyAlgorithm(KeyAlgorithm var1);

        public Builder exportToken(String var1);

        public Builder parametersValidUntilTimestamp(Instant var1);
    }
}

