/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptography.model.ExportAttributes;
import software.amazon.awssdk.services.paymentcryptography.model.ExportKeyMaterial;
import software.amazon.awssdk.services.paymentcryptography.model.PaymentCryptographyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportKeyRequest
extends PaymentCryptographyRequest
implements ToCopyableBuilder<Builder, ExportKeyRequest> {
    private static final SdkField<ExportKeyMaterial> KEY_MATERIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KeyMaterial").getter(ExportKeyRequest.getter(ExportKeyRequest::keyMaterial)).setter(ExportKeyRequest.setter(Builder::keyMaterial)).constructor(ExportKeyMaterial::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyMaterial").build()}).build();
    private static final SdkField<String> EXPORT_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportKeyIdentifier").getter(ExportKeyRequest.getter(ExportKeyRequest::exportKeyIdentifier)).setter(ExportKeyRequest.setter(Builder::exportKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportKeyIdentifier").build()}).build();
    private static final SdkField<ExportAttributes> EXPORT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExportAttributes").getter(ExportKeyRequest.getter(ExportKeyRequest::exportAttributes)).setter(ExportKeyRequest.setter(Builder::exportAttributes)).constructor(ExportAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_MATERIAL_FIELD, EXPORT_KEY_IDENTIFIER_FIELD, EXPORT_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExportKeyRequest.memberNameToFieldInitializer();
    private final ExportKeyMaterial keyMaterial;
    private final String exportKeyIdentifier;
    private final ExportAttributes exportAttributes;

    private ExportKeyRequest(BuilderImpl builder) {
        super(builder);
        this.keyMaterial = builder.keyMaterial;
        this.exportKeyIdentifier = builder.exportKeyIdentifier;
        this.exportAttributes = builder.exportAttributes;
    }

    public final ExportKeyMaterial keyMaterial() {
        return this.keyMaterial;
    }

    public final String exportKeyIdentifier() {
        return this.exportKeyIdentifier;
    }

    public final ExportAttributes exportAttributes() {
        return this.exportAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyMaterial());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportAttributes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportKeyRequest)) {
            return false;
        }
        ExportKeyRequest other = (ExportKeyRequest)((Object)obj);
        return Objects.equals(this.keyMaterial(), other.keyMaterial()) && Objects.equals(this.exportKeyIdentifier(), other.exportKeyIdentifier()) && Objects.equals(this.exportAttributes(), other.exportAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"ExportKeyRequest").add("KeyMaterial", (Object)this.keyMaterial()).add("ExportKeyIdentifier", (Object)this.exportKeyIdentifier()).add("ExportAttributes", (Object)this.exportAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyMaterial": {
                return Optional.ofNullable(clazz.cast(this.keyMaterial()));
            }
            case "ExportKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.exportKeyIdentifier()));
            }
            case "ExportAttributes": {
                return Optional.ofNullable(clazz.cast(this.exportAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KeyMaterial", KEY_MATERIAL_FIELD);
        map.put("ExportKeyIdentifier", EXPORT_KEY_IDENTIFIER_FIELD);
        map.put("ExportAttributes", EXPORT_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportKeyRequest, T> g) {
        return obj -> g.apply((ExportKeyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PaymentCryptographyRequest.BuilderImpl
    implements Builder {
        private ExportKeyMaterial keyMaterial;
        private String exportKeyIdentifier;
        private ExportAttributes exportAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportKeyRequest model) {
            super(model);
            this.keyMaterial(model.keyMaterial);
            this.exportKeyIdentifier(model.exportKeyIdentifier);
            this.exportAttributes(model.exportAttributes);
        }

        public final ExportKeyMaterial.Builder getKeyMaterial() {
            return this.keyMaterial != null ? this.keyMaterial.toBuilder() : null;
        }

        public final void setKeyMaterial(ExportKeyMaterial.BuilderImpl keyMaterial) {
            this.keyMaterial = keyMaterial != null ? keyMaterial.build() : null;
        }

        @Override
        public final Builder keyMaterial(ExportKeyMaterial keyMaterial) {
            this.keyMaterial = keyMaterial;
            return this;
        }

        public final String getExportKeyIdentifier() {
            return this.exportKeyIdentifier;
        }

        public final void setExportKeyIdentifier(String exportKeyIdentifier) {
            this.exportKeyIdentifier = exportKeyIdentifier;
        }

        @Override
        public final Builder exportKeyIdentifier(String exportKeyIdentifier) {
            this.exportKeyIdentifier = exportKeyIdentifier;
            return this;
        }

        public final ExportAttributes.Builder getExportAttributes() {
            return this.exportAttributes != null ? this.exportAttributes.toBuilder() : null;
        }

        public final void setExportAttributes(ExportAttributes.BuilderImpl exportAttributes) {
            this.exportAttributes = exportAttributes != null ? exportAttributes.build() : null;
        }

        @Override
        public final Builder exportAttributes(ExportAttributes exportAttributes) {
            this.exportAttributes = exportAttributes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExportKeyRequest build() {
            return new ExportKeyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PaymentCryptographyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExportKeyRequest> {
        public Builder keyMaterial(ExportKeyMaterial var1);

        default public Builder keyMaterial(Consumer<ExportKeyMaterial.Builder> keyMaterial) {
            return this.keyMaterial((ExportKeyMaterial)((ExportKeyMaterial.Builder)ExportKeyMaterial.builder().applyMutation(keyMaterial)).build());
        }

        public Builder exportKeyIdentifier(String var1);

        public Builder exportAttributes(ExportAttributes var1);

        default public Builder exportAttributes(Consumer<ExportAttributes.Builder> exportAttributes) {
            return this.exportAttributes((ExportAttributes)((ExportAttributes.Builder)ExportAttributes.builder().applyMutation(exportAttributes)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

