/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptography.model.ExportDukptInitialKey;
import software.amazon.awssdk.services.paymentcryptography.model.KeyCheckValueAlgorithm;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportAttributes> {
    private static final SdkField<ExportDukptInitialKey> EXPORT_DUKPT_INITIAL_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExportDukptInitialKey").getter(ExportAttributes.getter(ExportAttributes::exportDukptInitialKey)).setter(ExportAttributes.setter(Builder::exportDukptInitialKey)).constructor(ExportDukptInitialKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportDukptInitialKey").build()}).build();
    private static final SdkField<String> KEY_CHECK_VALUE_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyCheckValueAlgorithm").getter(ExportAttributes.getter(ExportAttributes::keyCheckValueAlgorithmAsString)).setter(ExportAttributes.setter(Builder::keyCheckValueAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyCheckValueAlgorithm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_DUKPT_INITIAL_KEY_FIELD, KEY_CHECK_VALUE_ALGORITHM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExportAttributes.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ExportDukptInitialKey exportDukptInitialKey;
    private final String keyCheckValueAlgorithm;

    private ExportAttributes(BuilderImpl builder) {
        this.exportDukptInitialKey = builder.exportDukptInitialKey;
        this.keyCheckValueAlgorithm = builder.keyCheckValueAlgorithm;
    }

    public final ExportDukptInitialKey exportDukptInitialKey() {
        return this.exportDukptInitialKey;
    }

    public final KeyCheckValueAlgorithm keyCheckValueAlgorithm() {
        return KeyCheckValueAlgorithm.fromValue(this.keyCheckValueAlgorithm);
    }

    public final String keyCheckValueAlgorithmAsString() {
        return this.keyCheckValueAlgorithm;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.exportDukptInitialKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyCheckValueAlgorithmAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportAttributes)) {
            return false;
        }
        ExportAttributes other = (ExportAttributes)obj;
        return Objects.equals(this.exportDukptInitialKey(), other.exportDukptInitialKey()) && Objects.equals(this.keyCheckValueAlgorithmAsString(), other.keyCheckValueAlgorithmAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ExportAttributes").add("ExportDukptInitialKey", (Object)this.exportDukptInitialKey()).add("KeyCheckValueAlgorithm", (Object)this.keyCheckValueAlgorithmAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExportDukptInitialKey": {
                return Optional.ofNullable(clazz.cast(this.exportDukptInitialKey()));
            }
            case "KeyCheckValueAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.keyCheckValueAlgorithmAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExportDukptInitialKey", EXPORT_DUKPT_INITIAL_KEY_FIELD);
        map.put("KeyCheckValueAlgorithm", KEY_CHECK_VALUE_ALGORITHM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportAttributes, T> g) {
        return obj -> g.apply((ExportAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ExportDukptInitialKey exportDukptInitialKey;
        private String keyCheckValueAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportAttributes model) {
            this.exportDukptInitialKey(model.exportDukptInitialKey);
            this.keyCheckValueAlgorithm(model.keyCheckValueAlgorithm);
        }

        public final ExportDukptInitialKey.Builder getExportDukptInitialKey() {
            return this.exportDukptInitialKey != null ? this.exportDukptInitialKey.toBuilder() : null;
        }

        public final void setExportDukptInitialKey(ExportDukptInitialKey.BuilderImpl exportDukptInitialKey) {
            this.exportDukptInitialKey = exportDukptInitialKey != null ? exportDukptInitialKey.build() : null;
        }

        @Override
        public final Builder exportDukptInitialKey(ExportDukptInitialKey exportDukptInitialKey) {
            this.exportDukptInitialKey = exportDukptInitialKey;
            return this;
        }

        public final String getKeyCheckValueAlgorithm() {
            return this.keyCheckValueAlgorithm;
        }

        public final void setKeyCheckValueAlgorithm(String keyCheckValueAlgorithm) {
            this.keyCheckValueAlgorithm = keyCheckValueAlgorithm;
        }

        @Override
        public final Builder keyCheckValueAlgorithm(String keyCheckValueAlgorithm) {
            this.keyCheckValueAlgorithm = keyCheckValueAlgorithm;
            return this;
        }

        @Override
        public final Builder keyCheckValueAlgorithm(KeyCheckValueAlgorithm keyCheckValueAlgorithm) {
            this.keyCheckValueAlgorithm(keyCheckValueAlgorithm == null ? null : keyCheckValueAlgorithm.toString());
            return this;
        }

        public ExportAttributes build() {
            return new ExportAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportAttributes> {
        public Builder exportDukptInitialKey(ExportDukptInitialKey var1);

        default public Builder exportDukptInitialKey(Consumer<ExportDukptInitialKey.Builder> exportDukptInitialKey) {
            return this.exportDukptInitialKey((ExportDukptInitialKey)((ExportDukptInitialKey.Builder)ExportDukptInitialKey.builder().applyMutation(exportDukptInitialKey)).build());
        }

        public Builder keyCheckValueAlgorithm(String var1);

        public Builder keyCheckValueAlgorithm(KeyCheckValueAlgorithm var1);
    }
}

