/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralselling.PartnerCentralSellingAsyncClient;
import software.amazon.awssdk.services.partnercentralselling.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralselling.model.ListOpportunitiesRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListOpportunitiesResponse;
import software.amazon.awssdk.services.partnercentralselling.model.OpportunitySummary;

public class ListOpportunitiesPublisher
implements SdkPublisher<ListOpportunitiesResponse> {
    private final PartnerCentralSellingAsyncClient client;
    private final ListOpportunitiesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOpportunitiesPublisher(PartnerCentralSellingAsyncClient client, ListOpportunitiesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOpportunitiesPublisher(PartnerCentralSellingAsyncClient client, ListOpportunitiesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOpportunitiesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOpportunitiesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OpportunitySummary> opportunitySummaries() {
        Function<ListOpportunitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.opportunitySummaries() != null) {
                return response.opportunitySummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOpportunitiesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListOpportunitiesResponseFetcher
    implements AsyncPageFetcher<ListOpportunitiesResponse> {
        private ListOpportunitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListOpportunitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListOpportunitiesResponse> nextPage(ListOpportunitiesResponse previousPage) {
            if (previousPage == null) {
                return ListOpportunitiesPublisher.this.client.listOpportunities(ListOpportunitiesPublisher.this.firstRequest);
            }
            return ListOpportunitiesPublisher.this.client.listOpportunities((ListOpportunitiesRequest)((Object)ListOpportunitiesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

