/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralselling.PartnerCentralSellingAsyncClient;
import software.amazon.awssdk.services.partnercentralselling.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralselling.model.EngagementMember;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementMembersRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementMembersResponse;

public class ListEngagementMembersPublisher
implements SdkPublisher<ListEngagementMembersResponse> {
    private final PartnerCentralSellingAsyncClient client;
    private final ListEngagementMembersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEngagementMembersPublisher(PartnerCentralSellingAsyncClient client, ListEngagementMembersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEngagementMembersPublisher(PartnerCentralSellingAsyncClient client, ListEngagementMembersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEngagementMembersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEngagementMembersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EngagementMember> engagementMemberList() {
        Function<ListEngagementMembersResponse, Iterator> getIterator = response -> {
            if (response != null && response.engagementMemberList() != null) {
                return response.engagementMemberList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEngagementMembersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEngagementMembersResponseFetcher
    implements AsyncPageFetcher<ListEngagementMembersResponse> {
        private ListEngagementMembersResponseFetcher() {
        }

        public boolean hasNextPage(ListEngagementMembersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEngagementMembersResponse> nextPage(ListEngagementMembersResponse previousPage) {
            if (previousPage == null) {
                return ListEngagementMembersPublisher.this.client.listEngagementMembers(ListEngagementMembersPublisher.this.firstRequest);
            }
            return ListEngagementMembersPublisher.this.client.listEngagementMembers((ListEngagementMembersRequest)((Object)ListEngagementMembersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

