/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralselling.model.EngagementContextType;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerCentralSellingRequest;
import software.amazon.awssdk.services.partnercentralselling.model.UpdateEngagementContextPayload;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEngagementContextRequest
extends PartnerCentralSellingRequest
implements ToCopyableBuilder<Builder, UpdateEngagementContextRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(UpdateEngagementContextRequest.getter(UpdateEngagementContextRequest::catalog)).setter(UpdateEngagementContextRequest.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<String> ENGAGEMENT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngagementIdentifier").getter(UpdateEngagementContextRequest.getter(UpdateEngagementContextRequest::engagementIdentifier)).setter(UpdateEngagementContextRequest.setter(Builder::engagementIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementIdentifier").build()}).build();
    private static final SdkField<String> CONTEXT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContextIdentifier").getter(UpdateEngagementContextRequest.getter(UpdateEngagementContextRequest::contextIdentifier)).setter(UpdateEngagementContextRequest.setter(Builder::contextIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextIdentifier").build()}).build();
    private static final SdkField<Instant> ENGAGEMENT_LAST_MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EngagementLastModifiedAt").getter(UpdateEngagementContextRequest.getter(UpdateEngagementContextRequest::engagementLastModifiedAt)).setter(UpdateEngagementContextRequest.setter(Builder::engagementLastModifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementLastModifiedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(UpdateEngagementContextRequest.getter(UpdateEngagementContextRequest::typeAsString)).setter(UpdateEngagementContextRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<UpdateEngagementContextPayload> PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Payload").getter(UpdateEngagementContextRequest.getter(UpdateEngagementContextRequest::payload)).setter(UpdateEngagementContextRequest.setter(Builder::payload)).constructor(UpdateEngagementContextPayload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Payload").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, ENGAGEMENT_IDENTIFIER_FIELD, CONTEXT_IDENTIFIER_FIELD, ENGAGEMENT_LAST_MODIFIED_AT_FIELD, TYPE_FIELD, PAYLOAD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateEngagementContextRequest.memberNameToFieldInitializer();
    private final String catalog;
    private final String engagementIdentifier;
    private final String contextIdentifier;
    private final Instant engagementLastModifiedAt;
    private final String type;
    private final UpdateEngagementContextPayload payload;

    private UpdateEngagementContextRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.engagementIdentifier = builder.engagementIdentifier;
        this.contextIdentifier = builder.contextIdentifier;
        this.engagementLastModifiedAt = builder.engagementLastModifiedAt;
        this.type = builder.type;
        this.payload = builder.payload;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final String engagementIdentifier() {
        return this.engagementIdentifier;
    }

    public final String contextIdentifier() {
        return this.contextIdentifier;
    }

    public final Instant engagementLastModifiedAt() {
        return this.engagementLastModifiedAt;
    }

    public final EngagementContextType type() {
        return EngagementContextType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final UpdateEngagementContextPayload payload() {
        return this.payload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.engagementIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.contextIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.engagementLastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEngagementContextRequest)) {
            return false;
        }
        UpdateEngagementContextRequest other = (UpdateEngagementContextRequest)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.engagementIdentifier(), other.engagementIdentifier()) && Objects.equals(this.contextIdentifier(), other.contextIdentifier()) && Objects.equals(this.engagementLastModifiedAt(), other.engagementLastModifiedAt()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.payload(), other.payload());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateEngagementContextRequest").add("Catalog", (Object)this.catalog()).add("EngagementIdentifier", (Object)this.engagementIdentifier()).add("ContextIdentifier", (Object)this.contextIdentifier()).add("EngagementLastModifiedAt", (Object)this.engagementLastModifiedAt()).add("Type", (Object)this.typeAsString()).add("Payload", (Object)this.payload()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "EngagementIdentifier": {
                return Optional.ofNullable(clazz.cast(this.engagementIdentifier()));
            }
            case "ContextIdentifier": {
                return Optional.ofNullable(clazz.cast(this.contextIdentifier()));
            }
            case "EngagementLastModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.engagementLastModifiedAt()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("EngagementIdentifier", ENGAGEMENT_IDENTIFIER_FIELD);
        map.put("ContextIdentifier", CONTEXT_IDENTIFIER_FIELD);
        map.put("EngagementLastModifiedAt", ENGAGEMENT_LAST_MODIFIED_AT_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Payload", PAYLOAD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateEngagementContextRequest, T> g) {
        return obj -> g.apply((UpdateEngagementContextRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralSellingRequest.BuilderImpl
    implements Builder {
        private String catalog;
        private String engagementIdentifier;
        private String contextIdentifier;
        private Instant engagementLastModifiedAt;
        private String type;
        private UpdateEngagementContextPayload payload;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEngagementContextRequest model) {
            super(model);
            this.catalog(model.catalog);
            this.engagementIdentifier(model.engagementIdentifier);
            this.contextIdentifier(model.contextIdentifier);
            this.engagementLastModifiedAt(model.engagementLastModifiedAt);
            this.type(model.type);
            this.payload(model.payload);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getEngagementIdentifier() {
            return this.engagementIdentifier;
        }

        public final void setEngagementIdentifier(String engagementIdentifier) {
            this.engagementIdentifier = engagementIdentifier;
        }

        @Override
        public final Builder engagementIdentifier(String engagementIdentifier) {
            this.engagementIdentifier = engagementIdentifier;
            return this;
        }

        public final String getContextIdentifier() {
            return this.contextIdentifier;
        }

        public final void setContextIdentifier(String contextIdentifier) {
            this.contextIdentifier = contextIdentifier;
        }

        @Override
        public final Builder contextIdentifier(String contextIdentifier) {
            this.contextIdentifier = contextIdentifier;
            return this;
        }

        public final Instant getEngagementLastModifiedAt() {
            return this.engagementLastModifiedAt;
        }

        public final void setEngagementLastModifiedAt(Instant engagementLastModifiedAt) {
            this.engagementLastModifiedAt = engagementLastModifiedAt;
        }

        @Override
        public final Builder engagementLastModifiedAt(Instant engagementLastModifiedAt) {
            this.engagementLastModifiedAt = engagementLastModifiedAt;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EngagementContextType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final UpdateEngagementContextPayload.Builder getPayload() {
            return this.payload != null ? this.payload.toBuilder() : null;
        }

        public final void setPayload(UpdateEngagementContextPayload.BuilderImpl payload) {
            this.payload = payload != null ? payload.build() : null;
        }

        @Override
        public final Builder payload(UpdateEngagementContextPayload payload) {
            this.payload = payload;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEngagementContextRequest build() {
            return new UpdateEngagementContextRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralSellingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEngagementContextRequest> {
        public Builder catalog(String var1);

        public Builder engagementIdentifier(String var1);

        public Builder contextIdentifier(String var1);

        public Builder engagementLastModifiedAt(Instant var1);

        public Builder type(String var1);

        public Builder type(EngagementContextType var1);

        public Builder payload(UpdateEngagementContextPayload var1);

        default public Builder payload(Consumer<UpdateEngagementContextPayload.Builder> payload) {
            return this.payload((UpdateEngagementContextPayload)((UpdateEngagementContextPayload.Builder)UpdateEngagementContextPayload.builder().applyMutation(payload)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

