/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralselling.model.ListOpportunityFromEngagementTaskSummariesCopier;
import software.amazon.awssdk.services.partnercentralselling.model.ListOpportunityFromEngagementTaskSummary;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerCentralSellingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOpportunityFromEngagementTasksResponse
extends PartnerCentralSellingResponse
implements ToCopyableBuilder<Builder, ListOpportunityFromEngagementTasksResponse> {
    private static final SdkField<List<ListOpportunityFromEngagementTaskSummary>> TASK_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TaskSummaries").getter(ListOpportunityFromEngagementTasksResponse.getter(ListOpportunityFromEngagementTasksResponse::taskSummaries)).setter(ListOpportunityFromEngagementTasksResponse.setter(Builder::taskSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListOpportunityFromEngagementTaskSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListOpportunityFromEngagementTasksResponse.getter(ListOpportunityFromEngagementTasksResponse::nextToken)).setter(ListOpportunityFromEngagementTasksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListOpportunityFromEngagementTasksResponse.memberNameToFieldInitializer();
    private final List<ListOpportunityFromEngagementTaskSummary> taskSummaries;
    private final String nextToken;

    private ListOpportunityFromEngagementTasksResponse(BuilderImpl builder) {
        super(builder);
        this.taskSummaries = builder.taskSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTaskSummaries() {
        return this.taskSummaries != null && !(this.taskSummaries instanceof SdkAutoConstructList);
    }

    public final List<ListOpportunityFromEngagementTaskSummary> taskSummaries() {
        return this.taskSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaskSummaries() ? this.taskSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOpportunityFromEngagementTasksResponse)) {
            return false;
        }
        ListOpportunityFromEngagementTasksResponse other = (ListOpportunityFromEngagementTasksResponse)((Object)obj);
        return this.hasTaskSummaries() == other.hasTaskSummaries() && Objects.equals(this.taskSummaries(), other.taskSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListOpportunityFromEngagementTasksResponse").add("TaskSummaries", this.hasTaskSummaries() ? this.taskSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TaskSummaries": {
                return Optional.ofNullable(clazz.cast(this.taskSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TaskSummaries", TASK_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListOpportunityFromEngagementTasksResponse, T> g) {
        return obj -> g.apply((ListOpportunityFromEngagementTasksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralSellingResponse.BuilderImpl
    implements Builder {
        private List<ListOpportunityFromEngagementTaskSummary> taskSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOpportunityFromEngagementTasksResponse model) {
            super(model);
            this.taskSummaries(model.taskSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<ListOpportunityFromEngagementTaskSummary.Builder> getTaskSummaries() {
            List<ListOpportunityFromEngagementTaskSummary.Builder> result = ListOpportunityFromEngagementTaskSummariesCopier.copyToBuilder(this.taskSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaskSummaries(Collection<ListOpportunityFromEngagementTaskSummary.BuilderImpl> taskSummaries) {
            this.taskSummaries = ListOpportunityFromEngagementTaskSummariesCopier.copyFromBuilder(taskSummaries);
        }

        @Override
        public final Builder taskSummaries(Collection<ListOpportunityFromEngagementTaskSummary> taskSummaries) {
            this.taskSummaries = ListOpportunityFromEngagementTaskSummariesCopier.copy(taskSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskSummaries(ListOpportunityFromEngagementTaskSummary ... taskSummaries) {
            this.taskSummaries(Arrays.asList(taskSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskSummaries(Consumer<ListOpportunityFromEngagementTaskSummary.Builder> ... taskSummaries) {
            this.taskSummaries(Stream.of(taskSummaries).map(c -> (ListOpportunityFromEngagementTaskSummary)((ListOpportunityFromEngagementTaskSummary.Builder)ListOpportunityFromEngagementTaskSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListOpportunityFromEngagementTasksResponse build() {
            return new ListOpportunityFromEngagementTasksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralSellingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOpportunityFromEngagementTasksResponse> {
        public Builder taskSummaries(Collection<ListOpportunityFromEngagementTaskSummary> var1);

        public Builder taskSummaries(ListOpportunityFromEngagementTaskSummary ... var1);

        public Builder taskSummaries(Consumer<ListOpportunityFromEngagementTaskSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

