/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralselling.PartnerCentralSellingAsyncClient;
import software.amazon.awssdk.services.partnercentralselling.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralselling.model.EngagementSummary;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementsResponse;

public class ListEngagementsPublisher
implements SdkPublisher<ListEngagementsResponse> {
    private final PartnerCentralSellingAsyncClient client;
    private final ListEngagementsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEngagementsPublisher(PartnerCentralSellingAsyncClient client, ListEngagementsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEngagementsPublisher(PartnerCentralSellingAsyncClient client, ListEngagementsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEngagementsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEngagementsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EngagementSummary> engagementSummaryList() {
        Function<ListEngagementsResponse, Iterator> getIterator = response -> {
            if (response != null && response.engagementSummaryList() != null) {
                return response.engagementSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEngagementsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEngagementsResponseFetcher
    implements AsyncPageFetcher<ListEngagementsResponse> {
        private ListEngagementsResponseFetcher() {
        }

        public boolean hasNextPage(ListEngagementsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEngagementsResponse> nextPage(ListEngagementsResponse previousPage) {
            if (previousPage == null) {
                return ListEngagementsPublisher.this.client.listEngagements(ListEngagementsPublisher.this.firstRequest);
            }
            return ListEngagementsPublisher.this.client.listEngagements((ListEngagementsRequest)((Object)ListEngagementsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

