/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralselling.model.AwsFundingUsed;
import software.amazon.awssdk.services.partnercentralselling.model.Channel;
import software.amazon.awssdk.services.partnercentralselling.model.ChannelsCopier;
import software.amazon.awssdk.services.partnercentralselling.model.MarketingSource;
import software.amazon.awssdk.services.partnercentralselling.model.UseCasesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Marketing
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Marketing> {
    private static final SdkField<String> CAMPAIGN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CampaignName").getter(Marketing.getter(Marketing::campaignName)).setter(Marketing.setter(Builder::campaignName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CampaignName").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(Marketing.getter(Marketing::sourceAsString)).setter(Marketing.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<List<String>> USE_CASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UseCases").getter(Marketing.getter(Marketing::useCases)).setter(Marketing.setter(Builder::useCases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseCases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Channels").getter(Marketing.getter(Marketing::channelsAsStrings)).setter(Marketing.setter(Builder::channelsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AWS_FUNDING_USED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsFundingUsed").getter(Marketing.getter(Marketing::awsFundingUsedAsString)).setter(Marketing.setter(Builder::awsFundingUsed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsFundingUsed").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGN_NAME_FIELD, SOURCE_FIELD, USE_CASES_FIELD, CHANNELS_FIELD, AWS_FUNDING_USED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Marketing.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String campaignName;
    private final String source;
    private final List<String> useCases;
    private final List<String> channels;
    private final String awsFundingUsed;

    private Marketing(BuilderImpl builder) {
        this.campaignName = builder.campaignName;
        this.source = builder.source;
        this.useCases = builder.useCases;
        this.channels = builder.channels;
        this.awsFundingUsed = builder.awsFundingUsed;
    }

    public final String campaignName() {
        return this.campaignName;
    }

    public final MarketingSource source() {
        return MarketingSource.fromValue(this.source);
    }

    public final String sourceAsString() {
        return this.source;
    }

    public final boolean hasUseCases() {
        return this.useCases != null && !(this.useCases instanceof SdkAutoConstructList);
    }

    public final List<String> useCases() {
        return this.useCases;
    }

    public final List<Channel> channels() {
        return ChannelsCopier.copyStringToEnum(this.channels);
    }

    public final boolean hasChannels() {
        return this.channels != null && !(this.channels instanceof SdkAutoConstructList);
    }

    public final List<String> channelsAsStrings() {
        return this.channels;
    }

    public final AwsFundingUsed awsFundingUsed() {
        return AwsFundingUsed.fromValue(this.awsFundingUsed);
    }

    public final String awsFundingUsedAsString() {
        return this.awsFundingUsed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.campaignName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUseCases() ? this.useCases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannels() ? this.channelsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.awsFundingUsedAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Marketing)) {
            return false;
        }
        Marketing other = (Marketing)obj;
        return Objects.equals(this.campaignName(), other.campaignName()) && Objects.equals(this.sourceAsString(), other.sourceAsString()) && this.hasUseCases() == other.hasUseCases() && Objects.equals(this.useCases(), other.useCases()) && this.hasChannels() == other.hasChannels() && Objects.equals(this.channelsAsStrings(), other.channelsAsStrings()) && Objects.equals(this.awsFundingUsedAsString(), other.awsFundingUsedAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Marketing").add("CampaignName", (Object)this.campaignName()).add("Source", (Object)this.sourceAsString()).add("UseCases", this.hasUseCases() ? this.useCases() : null).add("Channels", this.hasChannels() ? this.channelsAsStrings() : null).add("AwsFundingUsed", (Object)this.awsFundingUsedAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CampaignName": {
                return Optional.ofNullable(clazz.cast(this.campaignName()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.sourceAsString()));
            }
            case "UseCases": {
                return Optional.ofNullable(clazz.cast(this.useCases()));
            }
            case "Channels": {
                return Optional.ofNullable(clazz.cast(this.channelsAsStrings()));
            }
            case "AwsFundingUsed": {
                return Optional.ofNullable(clazz.cast(this.awsFundingUsedAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CampaignName", CAMPAIGN_NAME_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("UseCases", USE_CASES_FIELD);
        map.put("Channels", CHANNELS_FIELD);
        map.put("AwsFundingUsed", AWS_FUNDING_USED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Marketing, T> g) {
        return obj -> g.apply((Marketing)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String campaignName;
        private String source;
        private List<String> useCases = DefaultSdkAutoConstructList.getInstance();
        private List<String> channels = DefaultSdkAutoConstructList.getInstance();
        private String awsFundingUsed;

        private BuilderImpl() {
        }

        private BuilderImpl(Marketing model) {
            this.campaignName(model.campaignName);
            this.source(model.source);
            this.useCases(model.useCases);
            this.channelsWithStrings(model.channels);
            this.awsFundingUsed(model.awsFundingUsed);
        }

        public final String getCampaignName() {
            return this.campaignName;
        }

        public final void setCampaignName(String campaignName) {
            this.campaignName = campaignName;
        }

        @Override
        public final Builder campaignName(String campaignName) {
            this.campaignName = campaignName;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(MarketingSource source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        public final Collection<String> getUseCases() {
            if (this.useCases instanceof SdkAutoConstructList) {
                return null;
            }
            return this.useCases;
        }

        public final void setUseCases(Collection<String> useCases) {
            this.useCases = UseCasesCopier.copy(useCases);
        }

        @Override
        public final Builder useCases(Collection<String> useCases) {
            this.useCases = UseCasesCopier.copy(useCases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder useCases(String ... useCases) {
            this.useCases(Arrays.asList(useCases));
            return this;
        }

        public final Collection<String> getChannels() {
            if (this.channels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.channels;
        }

        public final void setChannels(Collection<String> channels) {
            this.channels = ChannelsCopier.copy(channels);
        }

        @Override
        public final Builder channelsWithStrings(Collection<String> channels) {
            this.channels = ChannelsCopier.copy(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelsWithStrings(String ... channels) {
            this.channelsWithStrings(Arrays.asList(channels));
            return this;
        }

        @Override
        public final Builder channels(Collection<Channel> channels) {
            this.channels = ChannelsCopier.copyEnumToString(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(Channel ... channels) {
            this.channels(Arrays.asList(channels));
            return this;
        }

        public final String getAwsFundingUsed() {
            return this.awsFundingUsed;
        }

        public final void setAwsFundingUsed(String awsFundingUsed) {
            this.awsFundingUsed = awsFundingUsed;
        }

        @Override
        public final Builder awsFundingUsed(String awsFundingUsed) {
            this.awsFundingUsed = awsFundingUsed;
            return this;
        }

        @Override
        public final Builder awsFundingUsed(AwsFundingUsed awsFundingUsed) {
            this.awsFundingUsed(awsFundingUsed == null ? null : awsFundingUsed.toString());
            return this;
        }

        public Marketing build() {
            return new Marketing(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Marketing> {
        public Builder campaignName(String var1);

        public Builder source(String var1);

        public Builder source(MarketingSource var1);

        public Builder useCases(Collection<String> var1);

        public Builder useCases(String ... var1);

        public Builder channelsWithStrings(Collection<String> var1);

        public Builder channelsWithStrings(String ... var1);

        public Builder channels(Collection<Channel> var1);

        public Builder channels(Channel ... var1);

        public Builder awsFundingUsed(String var1);

        public Builder awsFundingUsed(AwsFundingUsed var1);
    }
}

