/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralselling.PartnerCentralSellingAsyncClient;
import software.amazon.awssdk.services.partnercentralselling.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotJobsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotJobsResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ResourceSnapshotJobSummary;

public class ListResourceSnapshotJobsPublisher
implements SdkPublisher<ListResourceSnapshotJobsResponse> {
    private final PartnerCentralSellingAsyncClient client;
    private final ListResourceSnapshotJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResourceSnapshotJobsPublisher(PartnerCentralSellingAsyncClient client, ListResourceSnapshotJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResourceSnapshotJobsPublisher(PartnerCentralSellingAsyncClient client, ListResourceSnapshotJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResourceSnapshotJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResourceSnapshotJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResourceSnapshotJobSummary> resourceSnapshotJobSummaries() {
        Function<ListResourceSnapshotJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceSnapshotJobSummaries() != null) {
                return response.resourceSnapshotJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListResourceSnapshotJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListResourceSnapshotJobsResponseFetcher
    implements AsyncPageFetcher<ListResourceSnapshotJobsResponse> {
        private ListResourceSnapshotJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceSnapshotJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResourceSnapshotJobsResponse> nextPage(ListResourceSnapshotJobsResponse previousPage) {
            if (previousPage == null) {
                return ListResourceSnapshotJobsPublisher.this.client.listResourceSnapshotJobs(ListResourceSnapshotJobsPublisher.this.firstRequest);
            }
            return ListResourceSnapshotJobsPublisher.this.client.listResourceSnapshotJobs((ListResourceSnapshotJobsRequest)((Object)ListResourceSnapshotJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

