/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralselling.PartnerCentralSellingClient;
import software.amazon.awssdk.services.partnercentralselling.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralselling.model.ListOpportunitiesRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListOpportunitiesResponse;
import software.amazon.awssdk.services.partnercentralselling.model.OpportunitySummary;

public class ListOpportunitiesIterable
implements SdkIterable<ListOpportunitiesResponse> {
    private final PartnerCentralSellingClient client;
    private final ListOpportunitiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOpportunitiesIterable(PartnerCentralSellingClient client, ListOpportunitiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListOpportunitiesResponseFetcher();
    }

    public Iterator<ListOpportunitiesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OpportunitySummary> opportunitySummaries() {
        Function<ListOpportunitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.opportunitySummaries() != null) {
                return response.opportunitySummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListOpportunitiesResponseFetcher
    implements SyncPageFetcher<ListOpportunitiesResponse> {
        private ListOpportunitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListOpportunitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListOpportunitiesResponse nextPage(ListOpportunitiesResponse previousPage) {
            if (previousPage == null) {
                return ListOpportunitiesIterable.this.client.listOpportunities(ListOpportunitiesIterable.this.firstRequest);
            }
            return ListOpportunitiesIterable.this.client.listOpportunities((ListOpportunitiesRequest)((Object)ListOpportunitiesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

