/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralselling.PartnerCentralSellingClient;
import software.amazon.awssdk.services.partnercentralselling.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralselling.model.ListSolutionsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListSolutionsResponse;
import software.amazon.awssdk.services.partnercentralselling.model.SolutionBase;

public class ListSolutionsIterable
implements SdkIterable<ListSolutionsResponse> {
    private final PartnerCentralSellingClient client;
    private final ListSolutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSolutionsIterable(PartnerCentralSellingClient client, ListSolutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSolutionsResponseFetcher();
    }

    public Iterator<ListSolutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SolutionBase> solutionSummaries() {
        Function<ListSolutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.solutionSummaries() != null) {
                return response.solutionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSolutionsResponseFetcher
    implements SyncPageFetcher<ListSolutionsResponse> {
        private ListSolutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListSolutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSolutionsResponse nextPage(ListSolutionsResponse previousPage) {
            if (previousPage == null) {
                return ListSolutionsIterable.this.client.listSolutions(ListSolutionsIterable.this.firstRequest);
            }
            return ListSolutionsIterable.this.client.listSolutions((ListSolutionsRequest)((Object)ListSolutionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

