/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralselling.model.Contact;
import software.amazon.awssdk.services.partnercentralselling.model.Customer;
import software.amazon.awssdk.services.partnercentralselling.model.LifeCycleForView;
import software.amazon.awssdk.services.partnercentralselling.model.OpportunityType;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerOpportunityTeamMembersListCopier;
import software.amazon.awssdk.services.partnercentralselling.model.PrimaryNeedFromAws;
import software.amazon.awssdk.services.partnercentralselling.model.PrimaryNeedsFromAwsCopier;
import software.amazon.awssdk.services.partnercentralselling.model.ProjectView;
import software.amazon.awssdk.services.partnercentralselling.model.RelatedEntityIdentifiers;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpportunitySummaryView
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpportunitySummaryView> {
    private static final SdkField<Customer> CUSTOMER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Customer").getter(OpportunitySummaryView.getter(OpportunitySummaryView::customer)).setter(OpportunitySummaryView.setter(Builder::customer)).constructor(Customer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Customer").build()}).build();
    private static final SdkField<LifeCycleForView> LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Lifecycle").getter(OpportunitySummaryView.getter(OpportunitySummaryView::lifecycle)).setter(OpportunitySummaryView.setter(Builder::lifecycle)).constructor(LifeCycleForView::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()}).build();
    private static final SdkField<List<Contact>> OPPORTUNITY_TEAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OpportunityTeam").getter(OpportunitySummaryView.getter(OpportunitySummaryView::opportunityTeam)).setter(OpportunitySummaryView.setter(Builder::opportunityTeam)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpportunityTeam").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Contact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OPPORTUNITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OpportunityType").getter(OpportunitySummaryView.getter(OpportunitySummaryView::opportunityTypeAsString)).setter(OpportunitySummaryView.setter(Builder::opportunityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpportunityType").build()}).build();
    private static final SdkField<List<String>> PRIMARY_NEEDS_FROM_AWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrimaryNeedsFromAws").getter(OpportunitySummaryView.getter(OpportunitySummaryView::primaryNeedsFromAwsAsStrings)).setter(OpportunitySummaryView.setter(Builder::primaryNeedsFromAwsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryNeedsFromAws").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProjectView> PROJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Project").getter(OpportunitySummaryView.getter(OpportunitySummaryView::project)).setter(OpportunitySummaryView.setter(Builder::project)).constructor(ProjectView::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Project").build()}).build();
    private static final SdkField<RelatedEntityIdentifiers> RELATED_ENTITY_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RelatedEntityIdentifiers").getter(OpportunitySummaryView.getter(OpportunitySummaryView::relatedEntityIdentifiers)).setter(OpportunitySummaryView.setter(Builder::relatedEntityIdentifiers)).constructor(RelatedEntityIdentifiers::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedEntityIdentifiers").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_FIELD, LIFECYCLE_FIELD, OPPORTUNITY_TEAM_FIELD, OPPORTUNITY_TYPE_FIELD, PRIMARY_NEEDS_FROM_AWS_FIELD, PROJECT_FIELD, RELATED_ENTITY_IDENTIFIERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OpportunitySummaryView.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Customer customer;
    private final LifeCycleForView lifecycle;
    private final List<Contact> opportunityTeam;
    private final String opportunityType;
    private final List<String> primaryNeedsFromAws;
    private final ProjectView project;
    private final RelatedEntityIdentifiers relatedEntityIdentifiers;

    private OpportunitySummaryView(BuilderImpl builder) {
        this.customer = builder.customer;
        this.lifecycle = builder.lifecycle;
        this.opportunityTeam = builder.opportunityTeam;
        this.opportunityType = builder.opportunityType;
        this.primaryNeedsFromAws = builder.primaryNeedsFromAws;
        this.project = builder.project;
        this.relatedEntityIdentifiers = builder.relatedEntityIdentifiers;
    }

    public final Customer customer() {
        return this.customer;
    }

    public final LifeCycleForView lifecycle() {
        return this.lifecycle;
    }

    public final boolean hasOpportunityTeam() {
        return this.opportunityTeam != null && !(this.opportunityTeam instanceof SdkAutoConstructList);
    }

    public final List<Contact> opportunityTeam() {
        return this.opportunityTeam;
    }

    public final OpportunityType opportunityType() {
        return OpportunityType.fromValue(this.opportunityType);
    }

    public final String opportunityTypeAsString() {
        return this.opportunityType;
    }

    public final List<PrimaryNeedFromAws> primaryNeedsFromAws() {
        return PrimaryNeedsFromAwsCopier.copyStringToEnum(this.primaryNeedsFromAws);
    }

    public final boolean hasPrimaryNeedsFromAws() {
        return this.primaryNeedsFromAws != null && !(this.primaryNeedsFromAws instanceof SdkAutoConstructList);
    }

    public final List<String> primaryNeedsFromAwsAsStrings() {
        return this.primaryNeedsFromAws;
    }

    public final ProjectView project() {
        return this.project;
    }

    public final RelatedEntityIdentifiers relatedEntityIdentifiers() {
        return this.relatedEntityIdentifiers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customer());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycle());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOpportunityTeam() ? this.opportunityTeam() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.opportunityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrimaryNeedsFromAws() ? this.primaryNeedsFromAwsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.project());
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedEntityIdentifiers());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpportunitySummaryView)) {
            return false;
        }
        OpportunitySummaryView other = (OpportunitySummaryView)obj;
        return Objects.equals(this.customer(), other.customer()) && Objects.equals(this.lifecycle(), other.lifecycle()) && this.hasOpportunityTeam() == other.hasOpportunityTeam() && Objects.equals(this.opportunityTeam(), other.opportunityTeam()) && Objects.equals(this.opportunityTypeAsString(), other.opportunityTypeAsString()) && this.hasPrimaryNeedsFromAws() == other.hasPrimaryNeedsFromAws() && Objects.equals(this.primaryNeedsFromAwsAsStrings(), other.primaryNeedsFromAwsAsStrings()) && Objects.equals(this.project(), other.project()) && Objects.equals(this.relatedEntityIdentifiers(), other.relatedEntityIdentifiers());
    }

    public final String toString() {
        return ToString.builder((String)"OpportunitySummaryView").add("Customer", (Object)this.customer()).add("Lifecycle", (Object)this.lifecycle()).add("OpportunityTeam", this.hasOpportunityTeam() ? this.opportunityTeam() : null).add("OpportunityType", (Object)this.opportunityTypeAsString()).add("PrimaryNeedsFromAws", this.hasPrimaryNeedsFromAws() ? this.primaryNeedsFromAwsAsStrings() : null).add("Project", (Object)this.project()).add("RelatedEntityIdentifiers", (Object)this.relatedEntityIdentifiers()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Customer": {
                return Optional.ofNullable(clazz.cast(this.customer()));
            }
            case "Lifecycle": {
                return Optional.ofNullable(clazz.cast(this.lifecycle()));
            }
            case "OpportunityTeam": {
                return Optional.ofNullable(clazz.cast(this.opportunityTeam()));
            }
            case "OpportunityType": {
                return Optional.ofNullable(clazz.cast(this.opportunityTypeAsString()));
            }
            case "PrimaryNeedsFromAws": {
                return Optional.ofNullable(clazz.cast(this.primaryNeedsFromAwsAsStrings()));
            }
            case "Project": {
                return Optional.ofNullable(clazz.cast(this.project()));
            }
            case "RelatedEntityIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.relatedEntityIdentifiers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Customer", CUSTOMER_FIELD);
        map.put("Lifecycle", LIFECYCLE_FIELD);
        map.put("OpportunityTeam", OPPORTUNITY_TEAM_FIELD);
        map.put("OpportunityType", OPPORTUNITY_TYPE_FIELD);
        map.put("PrimaryNeedsFromAws", PRIMARY_NEEDS_FROM_AWS_FIELD);
        map.put("Project", PROJECT_FIELD);
        map.put("RelatedEntityIdentifiers", RELATED_ENTITY_IDENTIFIERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpportunitySummaryView, T> g) {
        return obj -> g.apply((OpportunitySummaryView)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Customer customer;
        private LifeCycleForView lifecycle;
        private List<Contact> opportunityTeam = DefaultSdkAutoConstructList.getInstance();
        private String opportunityType;
        private List<String> primaryNeedsFromAws = DefaultSdkAutoConstructList.getInstance();
        private ProjectView project;
        private RelatedEntityIdentifiers relatedEntityIdentifiers;

        private BuilderImpl() {
        }

        private BuilderImpl(OpportunitySummaryView model) {
            this.customer(model.customer);
            this.lifecycle(model.lifecycle);
            this.opportunityTeam(model.opportunityTeam);
            this.opportunityType(model.opportunityType);
            this.primaryNeedsFromAwsWithStrings(model.primaryNeedsFromAws);
            this.project(model.project);
            this.relatedEntityIdentifiers(model.relatedEntityIdentifiers);
        }

        public final Customer.Builder getCustomer() {
            return this.customer != null ? this.customer.toBuilder() : null;
        }

        public final void setCustomer(Customer.BuilderImpl customer) {
            this.customer = customer != null ? customer.build() : null;
        }

        @Override
        public final Builder customer(Customer customer) {
            this.customer = customer;
            return this;
        }

        public final LifeCycleForView.Builder getLifecycle() {
            return this.lifecycle != null ? this.lifecycle.toBuilder() : null;
        }

        public final void setLifecycle(LifeCycleForView.BuilderImpl lifecycle) {
            this.lifecycle = lifecycle != null ? lifecycle.build() : null;
        }

        @Override
        public final Builder lifecycle(LifeCycleForView lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        public final List<Contact.Builder> getOpportunityTeam() {
            List<Contact.Builder> result = PartnerOpportunityTeamMembersListCopier.copyToBuilder(this.opportunityTeam);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOpportunityTeam(Collection<Contact.BuilderImpl> opportunityTeam) {
            this.opportunityTeam = PartnerOpportunityTeamMembersListCopier.copyFromBuilder(opportunityTeam);
        }

        @Override
        public final Builder opportunityTeam(Collection<Contact> opportunityTeam) {
            this.opportunityTeam = PartnerOpportunityTeamMembersListCopier.copy(opportunityTeam);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder opportunityTeam(Contact ... opportunityTeam) {
            this.opportunityTeam(Arrays.asList(opportunityTeam));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder opportunityTeam(Consumer<Contact.Builder> ... opportunityTeam) {
            this.opportunityTeam(Stream.of(opportunityTeam).map(c -> (Contact)((Contact.Builder)Contact.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOpportunityType() {
            return this.opportunityType;
        }

        public final void setOpportunityType(String opportunityType) {
            this.opportunityType = opportunityType;
        }

        @Override
        public final Builder opportunityType(String opportunityType) {
            this.opportunityType = opportunityType;
            return this;
        }

        @Override
        public final Builder opportunityType(OpportunityType opportunityType) {
            this.opportunityType(opportunityType == null ? null : opportunityType.toString());
            return this;
        }

        public final Collection<String> getPrimaryNeedsFromAws() {
            if (this.primaryNeedsFromAws instanceof SdkAutoConstructList) {
                return null;
            }
            return this.primaryNeedsFromAws;
        }

        public final void setPrimaryNeedsFromAws(Collection<String> primaryNeedsFromAws) {
            this.primaryNeedsFromAws = PrimaryNeedsFromAwsCopier.copy(primaryNeedsFromAws);
        }

        @Override
        public final Builder primaryNeedsFromAwsWithStrings(Collection<String> primaryNeedsFromAws) {
            this.primaryNeedsFromAws = PrimaryNeedsFromAwsCopier.copy(primaryNeedsFromAws);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryNeedsFromAwsWithStrings(String ... primaryNeedsFromAws) {
            this.primaryNeedsFromAwsWithStrings(Arrays.asList(primaryNeedsFromAws));
            return this;
        }

        @Override
        public final Builder primaryNeedsFromAws(Collection<PrimaryNeedFromAws> primaryNeedsFromAws) {
            this.primaryNeedsFromAws = PrimaryNeedsFromAwsCopier.copyEnumToString(primaryNeedsFromAws);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryNeedsFromAws(PrimaryNeedFromAws ... primaryNeedsFromAws) {
            this.primaryNeedsFromAws(Arrays.asList(primaryNeedsFromAws));
            return this;
        }

        public final ProjectView.Builder getProject() {
            return this.project != null ? this.project.toBuilder() : null;
        }

        public final void setProject(ProjectView.BuilderImpl project) {
            this.project = project != null ? project.build() : null;
        }

        @Override
        public final Builder project(ProjectView project) {
            this.project = project;
            return this;
        }

        public final RelatedEntityIdentifiers.Builder getRelatedEntityIdentifiers() {
            return this.relatedEntityIdentifiers != null ? this.relatedEntityIdentifiers.toBuilder() : null;
        }

        public final void setRelatedEntityIdentifiers(RelatedEntityIdentifiers.BuilderImpl relatedEntityIdentifiers) {
            this.relatedEntityIdentifiers = relatedEntityIdentifiers != null ? relatedEntityIdentifiers.build() : null;
        }

        @Override
        public final Builder relatedEntityIdentifiers(RelatedEntityIdentifiers relatedEntityIdentifiers) {
            this.relatedEntityIdentifiers = relatedEntityIdentifiers;
            return this;
        }

        public OpportunitySummaryView build() {
            return new OpportunitySummaryView(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpportunitySummaryView> {
        public Builder customer(Customer var1);

        default public Builder customer(Consumer<Customer.Builder> customer) {
            return this.customer((Customer)((Customer.Builder)Customer.builder().applyMutation(customer)).build());
        }

        public Builder lifecycle(LifeCycleForView var1);

        default public Builder lifecycle(Consumer<LifeCycleForView.Builder> lifecycle) {
            return this.lifecycle((LifeCycleForView)((LifeCycleForView.Builder)LifeCycleForView.builder().applyMutation(lifecycle)).build());
        }

        public Builder opportunityTeam(Collection<Contact> var1);

        public Builder opportunityTeam(Contact ... var1);

        public Builder opportunityTeam(Consumer<Contact.Builder> ... var1);

        public Builder opportunityType(String var1);

        public Builder opportunityType(OpportunityType var1);

        public Builder primaryNeedsFromAwsWithStrings(Collection<String> var1);

        public Builder primaryNeedsFromAwsWithStrings(String ... var1);

        public Builder primaryNeedsFromAws(Collection<PrimaryNeedFromAws> var1);

        public Builder primaryNeedsFromAws(PrimaryNeedFromAws ... var1);

        public Builder project(ProjectView var1);

        default public Builder project(Consumer<ProjectView.Builder> project) {
            return this.project((ProjectView)((ProjectView.Builder)ProjectView.builder().applyMutation(project)).build());
        }

        public Builder relatedEntityIdentifiers(RelatedEntityIdentifiers var1);

        default public Builder relatedEntityIdentifiers(Consumer<RelatedEntityIdentifiers.Builder> relatedEntityIdentifiers) {
            return this.relatedEntityIdentifiers((RelatedEntityIdentifiers)((RelatedEntityIdentifiers.Builder)RelatedEntityIdentifiers.builder().applyMutation(relatedEntityIdentifiers)).build());
        }
    }
}

