/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralbenefits.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralbenefits.PartnerCentralBenefitsAsyncClient;
import software.amazon.awssdk.services.partnercentralbenefits.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralbenefits.model.BenefitSummary;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitsRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitsResponse;

public class ListBenefitsPublisher
implements SdkPublisher<ListBenefitsResponse> {
    private final PartnerCentralBenefitsAsyncClient client;
    private final ListBenefitsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBenefitsPublisher(PartnerCentralBenefitsAsyncClient client, ListBenefitsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBenefitsPublisher(PartnerCentralBenefitsAsyncClient client, ListBenefitsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBenefitsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBenefitsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BenefitSummary> benefitSummaries() {
        Function<ListBenefitsResponse, Iterator> getIterator = response -> {
            if (response != null && response.benefitSummaries() != null) {
                return response.benefitSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBenefitsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBenefitsResponseFetcher
    implements AsyncPageFetcher<ListBenefitsResponse> {
        private ListBenefitsResponseFetcher() {
        }

        public boolean hasNextPage(ListBenefitsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBenefitsResponse> nextPage(ListBenefitsResponse previousPage) {
            if (previousPage == null) {
                return ListBenefitsPublisher.this.client.listBenefits(ListBenefitsPublisher.this.firstRequest);
            }
            return ListBenefitsPublisher.this.client.listBenefits((ListBenefitsRequest)((Object)ListBenefitsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

