/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralaccount.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BusinessValidationCode {
    INCOMPATIBLE_CONNECTION_INVITATION_REQUEST("INCOMPATIBLE_CONNECTION_INVITATION_REQUEST"),
    INCOMPATIBLE_LEGAL_NAME("INCOMPATIBLE_LEGAL_NAME"),
    INCOMPATIBLE_KNOW_YOUR_BUSINESS_STATUS("INCOMPATIBLE_KNOW_YOUR_BUSINESS_STATUS"),
    INCOMPATIBLE_IDENTITY_VERIFICATION_STATUS("INCOMPATIBLE_IDENTITY_VERIFICATION_STATUS"),
    INVALID_ACCOUNT_LINKING_STATUS("INVALID_ACCOUNT_LINKING_STATUS"),
    INVALID_ACCOUNT_STATE("INVALID_ACCOUNT_STATE"),
    INCOMPATIBLE_DOMAIN("INCOMPATIBLE_DOMAIN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BusinessValidationCode> VALUE_MAP;
    private final String value;

    private BusinessValidationCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BusinessValidationCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BusinessValidationCode> knownValues() {
        EnumSet<BusinessValidationCode> knownValues = EnumSet.allOf(BusinessValidationCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BusinessValidationCode.class, BusinessValidationCode::toString);
    }
}

