/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.panorama.model.InputPortListCopier;
import software.amazon.awssdk.services.panorama.model.NodeInputPort;
import software.amazon.awssdk.services.panorama.model.NodeOutputPort;
import software.amazon.awssdk.services.panorama.model.OutputPortListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodeInterface
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodeInterface> {
    private static final SdkField<List<NodeInputPort>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Inputs").getter(NodeInterface.getter(NodeInterface::inputs)).setter(NodeInterface.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NodeInputPort::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<NodeOutputPort>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Outputs").getter(NodeInterface.getter(NodeInterface::outputs)).setter(NodeInterface.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NodeOutputPort::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUTS_FIELD, OUTPUTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NodeInterface.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<NodeInputPort> inputs;
    private final List<NodeOutputPort> outputs;

    private NodeInterface(BuilderImpl builder) {
        this.inputs = builder.inputs;
        this.outputs = builder.outputs;
    }

    public final boolean hasInputs() {
        return this.inputs != null && !(this.inputs instanceof SdkAutoConstructList);
    }

    public final List<NodeInputPort> inputs() {
        return this.inputs;
    }

    public final boolean hasOutputs() {
        return this.outputs != null && !(this.outputs instanceof SdkAutoConstructList);
    }

    public final List<NodeOutputPort> outputs() {
        return this.outputs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputs() ? this.inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputs() ? this.outputs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeInterface)) {
            return false;
        }
        NodeInterface other = (NodeInterface)obj;
        return this.hasInputs() == other.hasInputs() && Objects.equals(this.inputs(), other.inputs()) && this.hasOutputs() == other.hasOutputs() && Objects.equals(this.outputs(), other.outputs());
    }

    public final String toString() {
        return ToString.builder((String)"NodeInterface").add("Inputs", this.hasInputs() ? this.inputs() : null).add("Outputs", this.hasOutputs() ? this.outputs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
            case "Outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Inputs", INPUTS_FIELD);
        map.put("Outputs", OUTPUTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodeInterface, T> g) {
        return obj -> g.apply((NodeInterface)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<NodeInputPort> inputs = DefaultSdkAutoConstructList.getInstance();
        private List<NodeOutputPort> outputs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NodeInterface model) {
            this.inputs(model.inputs);
            this.outputs(model.outputs);
        }

        public final List<NodeInputPort.Builder> getInputs() {
            List<NodeInputPort.Builder> result = InputPortListCopier.copyToBuilder(this.inputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputs(Collection<NodeInputPort.BuilderImpl> inputs) {
            this.inputs = InputPortListCopier.copyFromBuilder(inputs);
        }

        @Override
        public final Builder inputs(Collection<NodeInputPort> inputs) {
            this.inputs = InputPortListCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(NodeInputPort ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Consumer<NodeInputPort.Builder> ... inputs) {
            this.inputs(Stream.of(inputs).map(c -> (NodeInputPort)((NodeInputPort.Builder)NodeInputPort.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<NodeOutputPort.Builder> getOutputs() {
            List<NodeOutputPort.Builder> result = OutputPortListCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<NodeOutputPort.BuilderImpl> outputs) {
            this.outputs = OutputPortListCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<NodeOutputPort> outputs) {
            this.outputs = OutputPortListCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(NodeOutputPort ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<NodeOutputPort.Builder> ... outputs) {
            this.outputs(Stream.of(outputs).map(c -> (NodeOutputPort)((NodeOutputPort.Builder)NodeOutputPort.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public NodeInterface build() {
            return new NodeInterface(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodeInterface> {
        public Builder inputs(Collection<NodeInputPort> var1);

        public Builder inputs(NodeInputPort ... var1);

        public Builder inputs(Consumer<NodeInputPort.Builder> ... var1);

        public Builder outputs(Collection<NodeOutputPort> var1);

        public Builder outputs(NodeOutputPort ... var1);

        public Builder outputs(Consumer<NodeOutputPort.Builder> ... var1);
    }
}

