/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.panorama.PanoramaClient;
import software.amazon.awssdk.services.panorama.PanoramaServiceClientConfiguration;
import software.amazon.awssdk.services.panorama.internal.PanoramaServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.panorama.model.AccessDeniedException;
import software.amazon.awssdk.services.panorama.model.ConflictException;
import software.amazon.awssdk.services.panorama.model.CreateApplicationInstanceRequest;
import software.amazon.awssdk.services.panorama.model.CreateApplicationInstanceResponse;
import software.amazon.awssdk.services.panorama.model.CreateJobForDevicesRequest;
import software.amazon.awssdk.services.panorama.model.CreateJobForDevicesResponse;
import software.amazon.awssdk.services.panorama.model.CreateNodeFromTemplateJobRequest;
import software.amazon.awssdk.services.panorama.model.CreateNodeFromTemplateJobResponse;
import software.amazon.awssdk.services.panorama.model.CreatePackageImportJobRequest;
import software.amazon.awssdk.services.panorama.model.CreatePackageImportJobResponse;
import software.amazon.awssdk.services.panorama.model.CreatePackageRequest;
import software.amazon.awssdk.services.panorama.model.CreatePackageResponse;
import software.amazon.awssdk.services.panorama.model.DeleteDeviceRequest;
import software.amazon.awssdk.services.panorama.model.DeleteDeviceResponse;
import software.amazon.awssdk.services.panorama.model.DeletePackageRequest;
import software.amazon.awssdk.services.panorama.model.DeletePackageResponse;
import software.amazon.awssdk.services.panorama.model.DeregisterPackageVersionRequest;
import software.amazon.awssdk.services.panorama.model.DeregisterPackageVersionResponse;
import software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceDetailsRequest;
import software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceDetailsResponse;
import software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceRequest;
import software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceResponse;
import software.amazon.awssdk.services.panorama.model.DescribeDeviceJobRequest;
import software.amazon.awssdk.services.panorama.model.DescribeDeviceJobResponse;
import software.amazon.awssdk.services.panorama.model.DescribeDeviceRequest;
import software.amazon.awssdk.services.panorama.model.DescribeDeviceResponse;
import software.amazon.awssdk.services.panorama.model.DescribeNodeFromTemplateJobRequest;
import software.amazon.awssdk.services.panorama.model.DescribeNodeFromTemplateJobResponse;
import software.amazon.awssdk.services.panorama.model.DescribeNodeRequest;
import software.amazon.awssdk.services.panorama.model.DescribeNodeResponse;
import software.amazon.awssdk.services.panorama.model.DescribePackageImportJobRequest;
import software.amazon.awssdk.services.panorama.model.DescribePackageImportJobResponse;
import software.amazon.awssdk.services.panorama.model.DescribePackageRequest;
import software.amazon.awssdk.services.panorama.model.DescribePackageResponse;
import software.amazon.awssdk.services.panorama.model.DescribePackageVersionRequest;
import software.amazon.awssdk.services.panorama.model.DescribePackageVersionResponse;
import software.amazon.awssdk.services.panorama.model.InternalServerException;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesRequest;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesResponse;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesRequest;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesResponse;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstancesRequest;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstancesResponse;
import software.amazon.awssdk.services.panorama.model.ListDevicesJobsRequest;
import software.amazon.awssdk.services.panorama.model.ListDevicesJobsResponse;
import software.amazon.awssdk.services.panorama.model.ListDevicesRequest;
import software.amazon.awssdk.services.panorama.model.ListDevicesResponse;
import software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsRequest;
import software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsResponse;
import software.amazon.awssdk.services.panorama.model.ListNodesRequest;
import software.amazon.awssdk.services.panorama.model.ListNodesResponse;
import software.amazon.awssdk.services.panorama.model.ListPackageImportJobsRequest;
import software.amazon.awssdk.services.panorama.model.ListPackageImportJobsResponse;
import software.amazon.awssdk.services.panorama.model.ListPackagesRequest;
import software.amazon.awssdk.services.panorama.model.ListPackagesResponse;
import software.amazon.awssdk.services.panorama.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.panorama.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.panorama.model.PanoramaException;
import software.amazon.awssdk.services.panorama.model.ProvisionDeviceRequest;
import software.amazon.awssdk.services.panorama.model.ProvisionDeviceResponse;
import software.amazon.awssdk.services.panorama.model.RegisterPackageVersionRequest;
import software.amazon.awssdk.services.panorama.model.RegisterPackageVersionResponse;
import software.amazon.awssdk.services.panorama.model.RemoveApplicationInstanceRequest;
import software.amazon.awssdk.services.panorama.model.RemoveApplicationInstanceResponse;
import software.amazon.awssdk.services.panorama.model.ResourceNotFoundException;
import software.amazon.awssdk.services.panorama.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.panorama.model.SignalApplicationInstanceNodeInstancesRequest;
import software.amazon.awssdk.services.panorama.model.SignalApplicationInstanceNodeInstancesResponse;
import software.amazon.awssdk.services.panorama.model.TagResourceRequest;
import software.amazon.awssdk.services.panorama.model.TagResourceResponse;
import software.amazon.awssdk.services.panorama.model.UntagResourceRequest;
import software.amazon.awssdk.services.panorama.model.UntagResourceResponse;
import software.amazon.awssdk.services.panorama.model.UpdateDeviceMetadataRequest;
import software.amazon.awssdk.services.panorama.model.UpdateDeviceMetadataResponse;
import software.amazon.awssdk.services.panorama.model.ValidationException;
import software.amazon.awssdk.services.panorama.transform.CreateApplicationInstanceRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.CreateJobForDevicesRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.CreateNodeFromTemplateJobRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.CreatePackageImportJobRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.CreatePackageRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.DeleteDeviceRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.DeletePackageRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.DeregisterPackageVersionRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.DescribeApplicationInstanceDetailsRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.DescribeApplicationInstanceRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.DescribeDeviceJobRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.DescribeDeviceRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.DescribeNodeFromTemplateJobRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.DescribeNodeRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.DescribePackageImportJobRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.DescribePackageRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.DescribePackageVersionRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.ListApplicationInstanceDependenciesRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.ListApplicationInstanceNodeInstancesRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.ListApplicationInstancesRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.ListDevicesJobsRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.ListDevicesRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.ListNodeFromTemplateJobsRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.ListNodesRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.ListPackageImportJobsRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.ListPackagesRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.ProvisionDeviceRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.RegisterPackageVersionRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.RemoveApplicationInstanceRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.SignalApplicationInstanceNodeInstancesRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.UpdateDeviceMetadataRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultPanoramaClient
implements PanoramaClient {
    private static final Logger log = Logger.loggerFor(DefaultPanoramaClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultPanoramaClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Panorama#2.41.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateApplicationInstanceResponse createApplicationInstance(CreateApplicationInstanceRequest createApplicationInstanceRequest) throws ValidationException, AccessDeniedException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateApplicationInstanceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createApplicationInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, createApplicationInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateApplicationInstance");
            CreateApplicationInstanceResponse createApplicationInstanceResponse = (CreateApplicationInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApplicationInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createApplicationInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateApplicationInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createApplicationInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$createApplicationInstance$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateJobForDevicesResponse createJobForDevices(CreateJobForDevicesRequest createJobForDevicesRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateJobForDevicesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createJobForDevicesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, createJobForDevicesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateJobForDevices");
            CreateJobForDevicesResponse createJobForDevicesResponse = (CreateJobForDevicesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateJobForDevices").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createJobForDevicesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateJobForDevicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createJobForDevicesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$createJobForDevices$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateNodeFromTemplateJobResponse createNodeFromTemplateJob(CreateNodeFromTemplateJobRequest createNodeFromTemplateJobRequest) throws ConflictException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateNodeFromTemplateJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createNodeFromTemplateJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, createNodeFromTemplateJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateNodeFromTemplateJob");
            CreateNodeFromTemplateJobResponse createNodeFromTemplateJobResponse = (CreateNodeFromTemplateJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateNodeFromTemplateJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createNodeFromTemplateJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateNodeFromTemplateJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createNodeFromTemplateJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$createNodeFromTemplateJob$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePackageResponse createPackage(CreatePackageRequest createPackageRequest) throws ConflictException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePackageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createPackageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, createPackageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePackage");
            CreatePackageResponse createPackageResponse = (CreatePackageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePackage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createPackageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePackageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPackageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$createPackage$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePackageImportJobResponse createPackageImportJob(CreatePackageImportJobRequest createPackageImportJobRequest) throws ConflictException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePackageImportJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createPackageImportJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, createPackageImportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePackageImportJob");
            CreatePackageImportJobResponse createPackageImportJobResponse = (CreatePackageImportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePackageImportJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createPackageImportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePackageImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPackageImportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$createPackageImportJob$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDeviceResponse deleteDevice(DeleteDeviceRequest deleteDeviceRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDeviceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDeviceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, deleteDeviceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDevice");
            DeleteDeviceResponse deleteDeviceResponse = (DeleteDeviceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDevice").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDeviceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDeviceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$deleteDevice$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePackageResponse deletePackage(DeletePackageRequest deletePackageRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePackageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deletePackageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, deletePackageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePackage");
            DeletePackageResponse deletePackageResponse = (DeletePackageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePackage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deletePackageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePackageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePackageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$deletePackage$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterPackageVersionResponse deregisterPackageVersion(DeregisterPackageVersionRequest deregisterPackageVersionRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterPackageVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deregisterPackageVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, deregisterPackageVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterPackageVersion");
            DeregisterPackageVersionResponse deregisterPackageVersionResponse = (DeregisterPackageVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterPackageVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deregisterPackageVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeregisterPackageVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deregisterPackageVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$deregisterPackageVersion$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeApplicationInstanceResponse describeApplicationInstance(DescribeApplicationInstanceRequest describeApplicationInstanceRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeApplicationInstanceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeApplicationInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, describeApplicationInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeApplicationInstance");
            DescribeApplicationInstanceResponse describeApplicationInstanceResponse = (DescribeApplicationInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeApplicationInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeApplicationInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeApplicationInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeApplicationInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$describeApplicationInstance$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeApplicationInstanceDetailsResponse describeApplicationInstanceDetails(DescribeApplicationInstanceDetailsRequest describeApplicationInstanceDetailsRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeApplicationInstanceDetailsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeApplicationInstanceDetailsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, describeApplicationInstanceDetailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeApplicationInstanceDetails");
            DescribeApplicationInstanceDetailsResponse describeApplicationInstanceDetailsResponse = (DescribeApplicationInstanceDetailsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeApplicationInstanceDetails").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeApplicationInstanceDetailsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeApplicationInstanceDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeApplicationInstanceDetailsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$describeApplicationInstanceDetails$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDeviceResponse describeDevice(DescribeDeviceRequest describeDeviceRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDeviceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDeviceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, describeDeviceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDevice");
            DescribeDeviceResponse describeDeviceResponse = (DescribeDeviceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDevice").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDeviceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDeviceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$describeDevice$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDeviceJobResponse describeDeviceJob(DescribeDeviceJobRequest describeDeviceJobRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDeviceJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDeviceJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, describeDeviceJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDeviceJob");
            DescribeDeviceJobResponse describeDeviceJobResponse = (DescribeDeviceJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDeviceJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDeviceJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDeviceJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDeviceJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$describeDeviceJob$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeNodeResponse describeNode(DescribeNodeRequest describeNodeRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeNodeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeNodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, describeNodeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeNode");
            DescribeNodeResponse describeNodeResponse = (DescribeNodeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeNode").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeNodeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeNodeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeNodeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$describeNode$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeNodeFromTemplateJobResponse describeNodeFromTemplateJob(DescribeNodeFromTemplateJobRequest describeNodeFromTemplateJobRequest) throws ConflictException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeNodeFromTemplateJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeNodeFromTemplateJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, describeNodeFromTemplateJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeNodeFromTemplateJob");
            DescribeNodeFromTemplateJobResponse describeNodeFromTemplateJobResponse = (DescribeNodeFromTemplateJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeNodeFromTemplateJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeNodeFromTemplateJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeNodeFromTemplateJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeNodeFromTemplateJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$describeNodeFromTemplateJob$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePackageResponse describePackage(DescribePackageRequest describePackageRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePackageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describePackageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, describePackageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePackage");
            DescribePackageResponse describePackageResponse = (DescribePackageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePackage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describePackageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribePackageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describePackageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$describePackage$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePackageImportJobResponse describePackageImportJob(DescribePackageImportJobRequest describePackageImportJobRequest) throws ConflictException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePackageImportJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describePackageImportJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, describePackageImportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePackageImportJob");
            DescribePackageImportJobResponse describePackageImportJobResponse = (DescribePackageImportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePackageImportJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describePackageImportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribePackageImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describePackageImportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$describePackageImportJob$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePackageVersionResponse describePackageVersion(DescribePackageVersionRequest describePackageVersionRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePackageVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describePackageVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, describePackageVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePackageVersion");
            DescribePackageVersionResponse describePackageVersionResponse = (DescribePackageVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePackageVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describePackageVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribePackageVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describePackageVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$describePackageVersion$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListApplicationInstanceDependenciesResponse listApplicationInstanceDependencies(ListApplicationInstanceDependenciesRequest listApplicationInstanceDependenciesRequest) throws AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApplicationInstanceDependenciesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listApplicationInstanceDependenciesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, listApplicationInstanceDependenciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListApplicationInstanceDependencies");
            ListApplicationInstanceDependenciesResponse listApplicationInstanceDependenciesResponse = (ListApplicationInstanceDependenciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApplicationInstanceDependencies").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listApplicationInstanceDependenciesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListApplicationInstanceDependenciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listApplicationInstanceDependenciesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$listApplicationInstanceDependencies$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListApplicationInstanceNodeInstancesResponse listApplicationInstanceNodeInstances(ListApplicationInstanceNodeInstancesRequest listApplicationInstanceNodeInstancesRequest) throws AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApplicationInstanceNodeInstancesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listApplicationInstanceNodeInstancesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, listApplicationInstanceNodeInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListApplicationInstanceNodeInstances");
            ListApplicationInstanceNodeInstancesResponse listApplicationInstanceNodeInstancesResponse = (ListApplicationInstanceNodeInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApplicationInstanceNodeInstances").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listApplicationInstanceNodeInstancesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListApplicationInstanceNodeInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listApplicationInstanceNodeInstancesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$listApplicationInstanceNodeInstances$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListApplicationInstancesResponse listApplicationInstances(ListApplicationInstancesRequest listApplicationInstancesRequest) throws AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApplicationInstancesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listApplicationInstancesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, listApplicationInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListApplicationInstances");
            ListApplicationInstancesResponse listApplicationInstancesResponse = (ListApplicationInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApplicationInstances").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listApplicationInstancesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListApplicationInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listApplicationInstancesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$listApplicationInstances$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDevicesResponse listDevices(ListDevicesRequest listDevicesRequest) throws ConflictException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDevicesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDevicesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, listDevicesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDevices");
            ListDevicesResponse listDevicesResponse = (ListDevicesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDevices").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDevicesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDevicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDevicesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$listDevices$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDevicesJobsResponse listDevicesJobs(ListDevicesJobsRequest listDevicesJobsRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDevicesJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDevicesJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, listDevicesJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDevicesJobs");
            ListDevicesJobsResponse listDevicesJobsResponse = (ListDevicesJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDevicesJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDevicesJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDevicesJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDevicesJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$listDevicesJobs$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListNodeFromTemplateJobsResponse listNodeFromTemplateJobs(ListNodeFromTemplateJobsRequest listNodeFromTemplateJobsRequest) throws ConflictException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListNodeFromTemplateJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listNodeFromTemplateJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, listNodeFromTemplateJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListNodeFromTemplateJobs");
            ListNodeFromTemplateJobsResponse listNodeFromTemplateJobsResponse = (ListNodeFromTemplateJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListNodeFromTemplateJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listNodeFromTemplateJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListNodeFromTemplateJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listNodeFromTemplateJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$listNodeFromTemplateJobs$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListNodesResponse listNodes(ListNodesRequest listNodesRequest) throws ConflictException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListNodesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listNodesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, listNodesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListNodes");
            ListNodesResponse listNodesResponse = (ListNodesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListNodes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listNodesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListNodesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listNodesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$listNodes$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPackageImportJobsResponse listPackageImportJobs(ListPackageImportJobsRequest listPackageImportJobsRequest) throws ConflictException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPackageImportJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPackageImportJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, listPackageImportJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPackageImportJobs");
            ListPackageImportJobsResponse listPackageImportJobsResponse = (ListPackageImportJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPackageImportJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listPackageImportJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPackageImportJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPackageImportJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$listPackageImportJobs$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPackagesResponse listPackages(ListPackagesRequest listPackagesRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPackagesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPackagesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, listPackagesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPackages");
            ListPackagesResponse listPackagesResponse = (ListPackagesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPackages").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listPackagesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPackagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPackagesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$listPackages$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$listTagsForResource$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProvisionDeviceResponse provisionDevice(ProvisionDeviceRequest provisionDeviceRequest) throws ConflictException, ValidationException, AccessDeniedException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ProvisionDeviceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)provisionDeviceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, provisionDeviceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ProvisionDevice");
            ProvisionDeviceResponse provisionDeviceResponse = (ProvisionDeviceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ProvisionDevice").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)provisionDeviceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ProvisionDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return provisionDeviceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$provisionDevice$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterPackageVersionResponse registerPackageVersion(RegisterPackageVersionRequest registerPackageVersionRequest) throws ConflictException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterPackageVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerPackageVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, registerPackageVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterPackageVersion");
            RegisterPackageVersionResponse registerPackageVersionResponse = (RegisterPackageVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterPackageVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)registerPackageVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RegisterPackageVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return registerPackageVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$registerPackageVersion$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveApplicationInstanceResponse removeApplicationInstance(RemoveApplicationInstanceRequest removeApplicationInstanceRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveApplicationInstanceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeApplicationInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, removeApplicationInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveApplicationInstance");
            RemoveApplicationInstanceResponse removeApplicationInstanceResponse = (RemoveApplicationInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveApplicationInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)removeApplicationInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveApplicationInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeApplicationInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$removeApplicationInstance$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SignalApplicationInstanceNodeInstancesResponse signalApplicationInstanceNodeInstances(SignalApplicationInstanceNodeInstancesRequest signalApplicationInstanceNodeInstancesRequest) throws ValidationException, AccessDeniedException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SignalApplicationInstanceNodeInstancesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)signalApplicationInstanceNodeInstancesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, signalApplicationInstanceNodeInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SignalApplicationInstanceNodeInstances");
            SignalApplicationInstanceNodeInstancesResponse signalApplicationInstanceNodeInstancesResponse = (SignalApplicationInstanceNodeInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SignalApplicationInstanceNodeInstances").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)signalApplicationInstanceNodeInstancesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SignalApplicationInstanceNodeInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return signalApplicationInstanceNodeInstancesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$signalApplicationInstanceNodeInstances$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$tagResource$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$untagResource$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDeviceMetadataResponse updateDeviceMetadata(UpdateDeviceMetadataRequest updateDeviceMetadataRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDeviceMetadataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDeviceMetadataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(clientConfiguration, updateDeviceMetadataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDeviceMetadata");
            UpdateDeviceMetadataResponse updateDeviceMetadataResponse = (UpdateDeviceMetadataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDeviceMetadata").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateDeviceMetadataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDeviceMetadataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDeviceMetadataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$updateDeviceMetadata$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "panorama";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        PanoramaServiceClientConfigurationBuilder serviceConfigBuilder = new PanoramaServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(PanoramaException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final PanoramaServiceClientConfiguration serviceClientConfiguration() {
        return new PanoramaServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateDeviceMetadata$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$signalApplicationInstanceNodeInstances$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeApplicationInstance$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerPackageVersion$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$provisionDevice$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPackages$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPackageImportJobs$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listNodes$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listNodeFromTemplateJobs$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDevicesJobs$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDevices$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listApplicationInstances$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listApplicationInstanceNodeInstances$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listApplicationInstanceDependencies$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describePackageVersion$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describePackageImportJob$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describePackage$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeNodeFromTemplateJob$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeNode$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDeviceJob$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDevice$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeApplicationInstanceDetails$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeApplicationInstance$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deregisterPackageVersion$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePackage$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDevice$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPackageImportJob$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPackage$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createNodeFromTemplateJob$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createJobForDevices$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createApplicationInstance$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

